/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ml.MlStatsIndex;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.notifications.NotificationsIndex;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;

public class MlIndexTemplateRegistry
extends IndexTemplateRegistry {
    private static final String ROOT_RESOURCE_PATH = "/org/elasticsearch/xpack/core/ml/";
    private static final String ANOMALY_DETECTION_PATH = "/org/elasticsearch/xpack/core/ml/anomalydetection/";
    private static final String VERSION_PATTERN = "xpack.ml.version";
    private static final String VERSION_ID_PATTERN = "xpack.ml.version.id";
    private static final String INDEX_LIFECYCLE_NAME = "xpack.ml.index.lifecycle.name";
    private static final String INDEX_LIFECYCLE_ROLLOVER_ALIAS = "xpack.ml.index.lifecycle.rollover_alias";
    public static final IndexTemplateConfig NOTIFICATIONS_TEMPLATE = MlIndexTemplateRegistry.notificationsTemplate();
    private static final String ML_SIZE_BASED_ILM_POLICY_NAME = "ml-size-based-ilm-policy";
    private static final Map<String, ComposableIndexTemplate> COMPOSABLE_INDEX_TEMPLATE_CONFIGS = MlIndexTemplateRegistry.parseComposableTemplates((IndexTemplateConfig[])new IndexTemplateConfig[]{MlIndexTemplateRegistry.anomalyDetectionResultsTemplate(), MlIndexTemplateRegistry.stateTemplate(), NOTIFICATIONS_TEMPLATE, MlIndexTemplateRegistry.statsTemplate()});
    private static final List<LifecyclePolicy> LIFECYCLE_POLICIES = List.of(new LifecyclePolicyConfig("ml-size-based-ilm-policy", "/org/elasticsearch/xpack/core/ml/size_based_ilm_policy.json").load(LifecyclePolicyConfig.DEFAULT_X_CONTENT_REGISTRY));

    private static IndexTemplateConfig stateTemplate() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(VERSION_ID_PATTERN, String.valueOf(Version.CURRENT.id));
        variables.put(INDEX_LIFECYCLE_NAME, ML_SIZE_BASED_ILM_POLICY_NAME);
        variables.put(INDEX_LIFECYCLE_ROLLOVER_ALIAS, AnomalyDetectorsIndex.jobStateIndexWriteAlias());
        return new IndexTemplateConfig(".ml-state", "/org/elasticsearch/xpack/core/ml/anomalydetection/state_index_template.json", Version.CURRENT.id, VERSION_PATTERN, variables);
    }

    private static IndexTemplateConfig anomalyDetectionResultsTemplate() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(VERSION_ID_PATTERN, String.valueOf(Version.CURRENT.id));
        variables.put("xpack.ml.anomalydetection.results.mappings", AnomalyDetectorsIndex.resultsMapping());
        return new IndexTemplateConfig(AnomalyDetectorsIndex.jobResultsIndexPrefix(), "/org/elasticsearch/xpack/core/ml/anomalydetection/results_index_template.json", Version.CURRENT.id, VERSION_PATTERN, variables);
    }

    private static IndexTemplateConfig notificationsTemplate() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(VERSION_ID_PATTERN, String.valueOf(Version.CURRENT.id));
        variables.put("xpack.ml.notifications.mappings", NotificationsIndex.mapping());
        return new IndexTemplateConfig(".ml-notifications-000002", "/org/elasticsearch/xpack/core/ml/notifications_index_template.json", Version.CURRENT.id, VERSION_PATTERN, variables);
    }

    private static IndexTemplateConfig statsTemplate() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(VERSION_ID_PATTERN, String.valueOf(Version.CURRENT.id));
        variables.put("xpack.ml.stats.mappings", MlStatsIndex.mapping());
        variables.put(INDEX_LIFECYCLE_NAME, ML_SIZE_BASED_ILM_POLICY_NAME);
        variables.put(INDEX_LIFECYCLE_ROLLOVER_ALIAS, MlStatsIndex.writeAlias());
        return new IndexTemplateConfig(".ml-stats", "/org/elasticsearch/xpack/core/ml/stats_index_template.json", Version.CURRENT.id, VERSION_PATTERN, variables);
    }

    public MlIndexTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
    }

    protected boolean requiresMasterNode() {
        return true;
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        return COMPOSABLE_INDEX_TEMPLATE_CONFIGS;
    }

    protected List<LifecyclePolicy> getPolicyConfigs() {
        return LIFECYCLE_POLICIES;
    }

    protected String getOrigin() {
        return "ml";
    }
}

