/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.features.ResetFeatureStateResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.AssociatedIndexDescriptor;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.breaker.BreakerSettings;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.CircuitBreakerPlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.plugins.ShutdownAwarePlugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ScalingExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.SetResetModeActionRequest;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlMetaIndex;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlStatsIndex;
import org.elasticsearch.xpack.core.ml.action.CancelJobModelSnapshotUpgradeAction;
import org.elasticsearch.xpack.core.ml.action.CloseJobAction;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAllocationAction;
import org.elasticsearch.xpack.core.ml.action.DeleteCalendarAction;
import org.elasticsearch.xpack.core.ml.action.DeleteCalendarEventAction;
import org.elasticsearch.xpack.core.ml.action.DeleteDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.DeleteDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.DeleteExpiredDataAction;
import org.elasticsearch.xpack.core.ml.action.DeleteFilterAction;
import org.elasticsearch.xpack.core.ml.action.DeleteForecastAction;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.action.DeleteModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.DeleteTrainedModelAction;
import org.elasticsearch.xpack.core.ml.action.DeleteTrainedModelAliasAction;
import org.elasticsearch.xpack.core.ml.action.DeleteTrainedModelAllocationAction;
import org.elasticsearch.xpack.core.ml.action.EstimateModelMemoryAction;
import org.elasticsearch.xpack.core.ml.action.EvaluateDataFrameAction;
import org.elasticsearch.xpack.core.ml.action.ExplainDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.FinalizeJobExecutionAction;
import org.elasticsearch.xpack.core.ml.action.FlushJobAction;
import org.elasticsearch.xpack.core.ml.action.ForecastJobAction;
import org.elasticsearch.xpack.core.ml.action.GetBucketsAction;
import org.elasticsearch.xpack.core.ml.action.GetCalendarEventsAction;
import org.elasticsearch.xpack.core.ml.action.GetCalendarsAction;
import org.elasticsearch.xpack.core.ml.action.GetCategoriesAction;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedRunningStateAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetDeploymentStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetFiltersAction;
import org.elasticsearch.xpack.core.ml.action.GetInfluencersAction;
import org.elasticsearch.xpack.core.ml.action.GetJobModelSnapshotsUpgradeStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetModelSnapshotsAction;
import org.elasticsearch.xpack.core.ml.action.GetOverallBucketsAction;
import org.elasticsearch.xpack.core.ml.action.GetRecordsAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsStatsAction;
import org.elasticsearch.xpack.core.ml.action.InferTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.action.InternalInferModelAction;
import org.elasticsearch.xpack.core.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.KillProcessAction;
import org.elasticsearch.xpack.core.ml.action.MlInfoAction;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.PersistJobAction;
import org.elasticsearch.xpack.core.ml.action.PostCalendarEventsAction;
import org.elasticsearch.xpack.core.ml.action.PostDataAction;
import org.elasticsearch.xpack.core.ml.action.PreviewDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.PreviewDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.PutCalendarAction;
import org.elasticsearch.xpack.core.ml.action.PutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.PutFilterAction;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelAction;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelAliasAction;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelDefinitionPartAction;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelVocabularyAction;
import org.elasticsearch.xpack.core.ml.action.ResetJobAction;
import org.elasticsearch.xpack.core.ml.action.RevertModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.SetResetModeAction;
import org.elasticsearch.xpack.core.ml.action.SetUpgradeModeAction;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.action.StopDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.StopDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.StopTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.action.UpdateCalendarJobAction;
import org.elasticsearch.xpack.core.ml.action.UpdateDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.UpdateDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.UpdateFilterAction;
import org.elasticsearch.xpack.core.ml.action.UpdateJobAction;
import org.elasticsearch.xpack.core.ml.action.UpdateModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.UpdateProcessAction;
import org.elasticsearch.xpack.core.ml.action.UpdateTrainedModelAllocationStateAction;
import org.elasticsearch.xpack.core.ml.action.UpgradeJobModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.ValidateDetectorAction;
import org.elasticsearch.xpack.core.ml.action.ValidateJobConfigAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsTaskState;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.MlDataFrameAnalysisNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.stats.AnalysisStatsNamedWriteablesProvider;
import org.elasticsearch.xpack.core.ml.inference.MlInferenceNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskParams;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskState;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.template.TemplateUtils;
import org.elasticsearch.xpack.ml.InvalidLicenseEnforcer;
import org.elasticsearch.xpack.ml.MachineLearningInfoTransportAction;
import org.elasticsearch.xpack.ml.MachineLearningUsageTransportAction;
import org.elasticsearch.xpack.ml.MlAssignmentNotifier;
import org.elasticsearch.xpack.ml.MlAutoUpdateService;
import org.elasticsearch.xpack.ml.MlConfigMigrationEligibilityCheck;
import org.elasticsearch.xpack.ml.MlIndexTemplateRegistry;
import org.elasticsearch.xpack.ml.MlInitializationService;
import org.elasticsearch.xpack.ml.MlLifeCycleService;
import org.elasticsearch.xpack.ml.MlUpgradeModeActionFilter;
import org.elasticsearch.xpack.ml.action.TransportCancelJobModelSnapshotUpgradeAction;
import org.elasticsearch.xpack.ml.action.TransportCloseJobAction;
import org.elasticsearch.xpack.ml.action.TransportCreateTrainedModelAllocationAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteCalendarAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteCalendarEventAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteExpiredDataAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteFilterAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteForecastAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteJobAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteTrainedModelAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteTrainedModelAliasAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteTrainedModelAllocationAction;
import org.elasticsearch.xpack.ml.action.TransportEstimateModelMemoryAction;
import org.elasticsearch.xpack.ml.action.TransportEvaluateDataFrameAction;
import org.elasticsearch.xpack.ml.action.TransportExplainDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportFinalizeJobExecutionAction;
import org.elasticsearch.xpack.ml.action.TransportFlushJobAction;
import org.elasticsearch.xpack.ml.action.TransportForecastJobAction;
import org.elasticsearch.xpack.ml.action.TransportGetBucketsAction;
import org.elasticsearch.xpack.ml.action.TransportGetCalendarEventsAction;
import org.elasticsearch.xpack.ml.action.TransportGetCalendarsAction;
import org.elasticsearch.xpack.ml.action.TransportGetCategoriesAction;
import org.elasticsearch.xpack.ml.action.TransportGetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportGetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.ml.action.TransportGetDatafeedRunningStateAction;
import org.elasticsearch.xpack.ml.action.TransportGetDatafeedsAction;
import org.elasticsearch.xpack.ml.action.TransportGetDatafeedsStatsAction;
import org.elasticsearch.xpack.ml.action.TransportGetDeploymentStatsAction;
import org.elasticsearch.xpack.ml.action.TransportGetFiltersAction;
import org.elasticsearch.xpack.ml.action.TransportGetInfluencersAction;
import org.elasticsearch.xpack.ml.action.TransportGetJobModelSnapshotsUpgradeStatsAction;
import org.elasticsearch.xpack.ml.action.TransportGetJobsAction;
import org.elasticsearch.xpack.ml.action.TransportGetJobsStatsAction;
import org.elasticsearch.xpack.ml.action.TransportGetModelSnapshotsAction;
import org.elasticsearch.xpack.ml.action.TransportGetOverallBucketsAction;
import org.elasticsearch.xpack.ml.action.TransportGetRecordsAction;
import org.elasticsearch.xpack.ml.action.TransportGetTrainedModelsAction;
import org.elasticsearch.xpack.ml.action.TransportGetTrainedModelsStatsAction;
import org.elasticsearch.xpack.ml.action.TransportInferTrainedModelDeploymentAction;
import org.elasticsearch.xpack.ml.action.TransportInternalInferModelAction;
import org.elasticsearch.xpack.ml.action.TransportIsolateDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportKillProcessAction;
import org.elasticsearch.xpack.ml.action.TransportMlInfoAction;
import org.elasticsearch.xpack.ml.action.TransportOpenJobAction;
import org.elasticsearch.xpack.ml.action.TransportPersistJobAction;
import org.elasticsearch.xpack.ml.action.TransportPostCalendarEventsAction;
import org.elasticsearch.xpack.ml.action.TransportPostDataAction;
import org.elasticsearch.xpack.ml.action.TransportPreviewDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportPreviewDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportPutCalendarAction;
import org.elasticsearch.xpack.ml.action.TransportPutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportPutDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportPutFilterAction;
import org.elasticsearch.xpack.ml.action.TransportPutJobAction;
import org.elasticsearch.xpack.ml.action.TransportPutTrainedModelAction;
import org.elasticsearch.xpack.ml.action.TransportPutTrainedModelAliasAction;
import org.elasticsearch.xpack.ml.action.TransportPutTrainedModelDefinitionPartAction;
import org.elasticsearch.xpack.ml.action.TransportPutTrainedModelVocabularyAction;
import org.elasticsearch.xpack.ml.action.TransportResetJobAction;
import org.elasticsearch.xpack.ml.action.TransportRevertModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.TransportSetResetModeAction;
import org.elasticsearch.xpack.ml.action.TransportSetUpgradeModeAction;
import org.elasticsearch.xpack.ml.action.TransportStartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportStartDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportStartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.ml.action.TransportStopDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportStopDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportStopTrainedModelDeploymentAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateCalendarJobAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateFilterAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateJobAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateProcessAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateTrainedModelAllocationStateAction;
import org.elasticsearch.xpack.ml.action.TransportUpgradeJobModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.TransportValidateDetectorAction;
import org.elasticsearch.xpack.ml.action.TransportValidateJobConfigAction;
import org.elasticsearch.xpack.ml.aggs.categorization.CategorizeTextAggregationBuilder;
import org.elasticsearch.xpack.ml.aggs.categorization.InternalCategorizationAggregation;
import org.elasticsearch.xpack.ml.aggs.correlation.BucketCorrelationAggregationBuilder;
import org.elasticsearch.xpack.ml.aggs.correlation.CorrelationNamedContentProvider;
import org.elasticsearch.xpack.ml.aggs.heuristic.PValueScore;
import org.elasticsearch.xpack.ml.aggs.inference.InferencePipelineAggregationBuilder;
import org.elasticsearch.xpack.ml.aggs.kstest.BucketCountKSTestAggregationBuilder;
import org.elasticsearch.xpack.ml.annotations.AnnotationPersister;
import org.elasticsearch.xpack.ml.autoscaling.MlAutoscalingDeciderService;
import org.elasticsearch.xpack.ml.autoscaling.MlAutoscalingNamedWritableProvider;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfigAutoUpdater;
import org.elasticsearch.xpack.ml.datafeed.DatafeedContextProvider;
import org.elasticsearch.xpack.ml.datafeed.DatafeedJobBuilder;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;
import org.elasticsearch.xpack.ml.datafeed.DatafeedRunner;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsManager;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsConfigProvider;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessManager;
import org.elasticsearch.xpack.ml.dataframe.process.MemoryUsageEstimationProcessManager;
import org.elasticsearch.xpack.ml.dataframe.process.NativeAnalyticsProcessFactory;
import org.elasticsearch.xpack.ml.dataframe.process.NativeMemoryUsageEstimationProcessFactory;
import org.elasticsearch.xpack.ml.inference.ModelAliasMetadata;
import org.elasticsearch.xpack.ml.inference.TrainedModelStatsService;
import org.elasticsearch.xpack.ml.inference.allocation.TrainedModelAllocationClusterService;
import org.elasticsearch.xpack.ml.inference.allocation.TrainedModelAllocationMetadata;
import org.elasticsearch.xpack.ml.inference.allocation.TrainedModelAllocationService;
import org.elasticsearch.xpack.ml.inference.deployment.DeploymentManager;
import org.elasticsearch.xpack.ml.inference.ingest.InferenceProcessor;
import org.elasticsearch.xpack.ml.inference.loadingservice.ModelLoadingService;
import org.elasticsearch.xpack.ml.inference.modelsize.MlModelSizeNamedXContentProvider;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;
import org.elasticsearch.xpack.ml.inference.pytorch.process.NativePyTorchProcessFactory;
import org.elasticsearch.xpack.ml.inference.pytorch.process.PyTorchProcessFactory;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.JobManagerHolder;
import org.elasticsearch.xpack.ml.job.NodeLoadDetector;
import org.elasticsearch.xpack.ml.job.UpdateJobProcessNotifier;
import org.elasticsearch.xpack.ml.job.categorization.FirstLineWithLettersCharFilterFactory;
import org.elasticsearch.xpack.ml.job.categorization.FirstNonBlankLineCharFilterFactory;
import org.elasticsearch.xpack.ml.job.categorization.MlClassicTokenizer;
import org.elasticsearch.xpack.ml.job.categorization.MlClassicTokenizerFactory;
import org.elasticsearch.xpack.ml.job.categorization.MlStandardTokenizer;
import org.elasticsearch.xpack.ml.job.categorization.MlStandardTokenizerFactory;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobDataCountsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectBuilder;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessFactory;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.job.process.autodetect.BlackHoleAutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.NativeAutodetectProcessFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.MultiplyingNormalizerProcess;
import org.elasticsearch.xpack.ml.job.process.normalizer.NativeNormalizerProcessFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerProcessFactory;
import org.elasticsearch.xpack.ml.job.snapshot.upgrader.SnapshotUpgradeTaskExecutor;
import org.elasticsearch.xpack.ml.job.task.OpenJobPersistentTasksExecutor;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.notifications.InferenceAuditor;
import org.elasticsearch.xpack.ml.process.DummyController;
import org.elasticsearch.xpack.ml.process.MlController;
import org.elasticsearch.xpack.ml.process.MlControllerHolder;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.NativeStorageProvider;
import org.elasticsearch.xpack.ml.rest.RestDeleteExpiredDataAction;
import org.elasticsearch.xpack.ml.rest.RestMlInfoAction;
import org.elasticsearch.xpack.ml.rest.RestSetUpgradeModeAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestDeleteCalendarAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestDeleteCalendarEventAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestDeleteCalendarJobAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestGetCalendarEventsAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestGetCalendarsAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestPostCalendarEventAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestPutCalendarAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestPutCalendarJobAction;
import org.elasticsearch.xpack.ml.rest.cat.RestCatDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.cat.RestCatDatafeedsAction;
import org.elasticsearch.xpack.ml.rest.cat.RestCatJobsAction;
import org.elasticsearch.xpack.ml.rest.cat.RestCatTrainedModelsAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestDeleteDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestGetDatafeedStatsAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestGetDatafeedsAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestPreviewDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestPutDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestStartDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestStopDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestUpdateDatafeedAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestDeleteDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestEvaluateDataFrameAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestExplainDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestGetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestGetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestPostDataFrameAnalyticsUpdateAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestPreviewDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestPutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestStartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestStopDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.filter.RestDeleteFilterAction;
import org.elasticsearch.xpack.ml.rest.filter.RestGetFiltersAction;
import org.elasticsearch.xpack.ml.rest.filter.RestPutFilterAction;
import org.elasticsearch.xpack.ml.rest.filter.RestUpdateFilterAction;
import org.elasticsearch.xpack.ml.rest.inference.RestDeleteTrainedModelAction;
import org.elasticsearch.xpack.ml.rest.inference.RestDeleteTrainedModelAliasAction;
import org.elasticsearch.xpack.ml.rest.inference.RestGetTrainedModelsAction;
import org.elasticsearch.xpack.ml.rest.inference.RestGetTrainedModelsStatsAction;
import org.elasticsearch.xpack.ml.rest.inference.RestInferTrainedModelDeploymentAction;
import org.elasticsearch.xpack.ml.rest.inference.RestPutTrainedModelAction;
import org.elasticsearch.xpack.ml.rest.inference.RestPutTrainedModelAliasAction;
import org.elasticsearch.xpack.ml.rest.inference.RestPutTrainedModelDefinitionPartAction;
import org.elasticsearch.xpack.ml.rest.inference.RestPutTrainedModelVocabularyAction;
import org.elasticsearch.xpack.ml.rest.inference.RestStartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.ml.rest.inference.RestStopTrainedModelDeploymentAction;
import org.elasticsearch.xpack.ml.rest.job.RestCloseJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestDeleteForecastAction;
import org.elasticsearch.xpack.ml.rest.job.RestDeleteJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestEstimateModelMemoryAction;
import org.elasticsearch.xpack.ml.rest.job.RestFlushJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestForecastJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestGetJobStatsAction;
import org.elasticsearch.xpack.ml.rest.job.RestGetJobsAction;
import org.elasticsearch.xpack.ml.rest.job.RestOpenJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestPostDataAction;
import org.elasticsearch.xpack.ml.rest.job.RestPostJobUpdateAction;
import org.elasticsearch.xpack.ml.rest.job.RestPutJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestResetJobAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestDeleteModelSnapshotAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestGetJobModelSnapshotsUpgradeStatsAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestGetModelSnapshotsAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestRevertModelSnapshotAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestUpdateModelSnapshotAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestUpgradeJobModelSnapshotAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetBucketsAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetCategoriesAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetInfluencersAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetOverallBucketsAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetRecordsAction;
import org.elasticsearch.xpack.ml.rest.validate.RestValidateDetectorAction;
import org.elasticsearch.xpack.ml.rest.validate.RestValidateJobConfigAction;
import org.elasticsearch.xpack.ml.utils.NativeMemoryCalculator;
import org.elasticsearch.xpack.ml.utils.persistence.ResultsPersisterService;

public class MachineLearning
extends Plugin
implements SystemIndexPlugin,
AnalysisPlugin,
CircuitBreakerPlugin,
IngestPlugin,
PersistentTaskPlugin,
SearchPlugin,
ShutdownAwarePlugin {
    public static final String NAME = "ml";
    public static final String BASE_PATH = "/_ml/";
    public static final String PRE_V7_BASE_PATH = "/_xpack/ml/";
    public static final String DATAFEED_THREAD_POOL_NAME = "ml_datafeed";
    public static final String JOB_COMMS_THREAD_POOL_NAME = "ml_job_comms";
    public static final String UTILITY_THREAD_POOL_NAME = "ml_utility";
    public static final String TRAINED_MODEL_CIRCUIT_BREAKER_NAME = "model_inference";
    private static final long DEFAULT_MODEL_CIRCUIT_BREAKER_LIMIT = (long)(0.5 * (double)JvmInfo.jvmInfo().getMem().getHeapMax().getBytes());
    private static final double DEFAULT_MODEL_CIRCUIT_BREAKER_OVERHEAD = 1.0;
    public static final boolean CATEGORIZATION_TOKENIZATION_IN_JAVA = true;
    public static final LicensedFeature.Persistent ML_ANOMALY_JOBS_FEATURE = LicensedFeature.persistent((String)"machine-learning", (String)"anomaly-detection-job", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Persistent ML_ANALYTICS_JOBS_FEATURE = LicensedFeature.persistent((String)"machine-learning", (String)"data-frame-analytics-job", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Persistent ML_MODEL_INFERENCE_FEATURE = LicensedFeature.persistent((String)"machine-learning", (String)"model-inference", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Persistent ML_PYTORCH_MODEL_INFERENCE_FEATURE = LicensedFeature.persistent((String)"machine-learning", (String)"pytorch-model-inference", (License.OperationMode)License.OperationMode.PLATINUM);
    private static final String PRE_V8_MAX_OPEN_JOBS_NODE_ATTR = "ml.max_open_jobs";
    public static final String MACHINE_MEMORY_NODE_ATTR = "ml.machine_memory";
    public static final String MAX_JVM_SIZE_NODE_ATTR = "ml.max_jvm_size";
    public static final Setting<Integer> CONCURRENT_JOB_ALLOCATIONS = Setting.intSetting((String)"xpack.ml.node_concurrent_job_allocations", (int)2, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final ByteSizeValue NATIVE_EXECUTABLE_CODE_OVERHEAD = ByteSizeValue.ofMb((long)30L);
    public static final Setting<Integer> MAX_MACHINE_MEMORY_PERCENT = Setting.intSetting((String)"xpack.ml.max_machine_memory_percent", (int)30, (int)5, (int)200, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Setting<Boolean> USE_AUTO_MACHINE_MEMORY_PERCENT = Setting.boolSetting((String)"xpack.ml.use_auto_machine_memory_percent", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Setting<Integer> MAX_LAZY_ML_NODES = Setting.intSetting((String)"xpack.ml.max_lazy_ml_nodes", (int)0, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    private static final int MAX_MAX_OPEN_JOBS_PER_NODE = 512;
    public static final int DEFAULT_MAX_OPEN_JOBS_PER_NODE = 512;
    public static final Setting<Integer> MAX_OPEN_JOBS_PER_NODE = Setting.intSetting((String)"xpack.ml.max_open_jobs", (int)512, (int)1, (int)512, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> PROCESS_CONNECT_TIMEOUT = Setting.timeSetting((String)"xpack.ml.process_connect_timeout", (TimeValue)TimeValue.timeValueSeconds((long)10L), (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> MIN_DISK_SPACE_OFF_HEAP = Setting.byteSizeSetting((String)"xpack.ml.min_disk_space_off_heap", (ByteSizeValue)ByteSizeValue.ofGb((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Float> NIGHTLY_MAINTENANCE_REQUESTS_PER_SECOND = new Setting("xpack.ml.nightly_maintenance_requests_per_second", s -> Float.toString(-1.0f), s -> {
        float value = Float.parseFloat(s);
        if (value <= 0.0f && value != -1.0f) {
            throw new IllegalArgumentException("Failed to parse value [" + s + "] for setting [xpack.ml.nightly_maintenance_requests_per_second] must be > 0.0 or exactly equal to -1.0");
        }
        return Float.valueOf(value);
    }, new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> MAX_ML_NODE_SIZE = Setting.byteSizeSetting((String)"xpack.ml.max_ml_node_size", (ByteSizeValue)ByteSizeValue.ZERO, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> DELAYED_DATA_CHECK_FREQ = Setting.timeSetting((String)"xpack.ml.delayed_data_check_freq", (TimeValue)TimeValue.timeValueMinutes((long)15L), (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(MachineLearning.class);
    private final Settings settings;
    private final boolean enabled;
    private final SetOnce<AutodetectProcessManager> autodetectProcessManager = new SetOnce();
    private final SetOnce<DatafeedConfigProvider> datafeedConfigProvider = new SetOnce();
    private final SetOnce<DatafeedRunner> datafeedRunner = new SetOnce();
    private final SetOnce<DataFrameAnalyticsManager> dataFrameAnalyticsManager = new SetOnce();
    private final SetOnce<DataFrameAnalyticsAuditor> dataFrameAnalyticsAuditor = new SetOnce();
    private final SetOnce<MlMemoryTracker> memoryTracker = new SetOnce();
    private final SetOnce<ActionFilter> mlUpgradeModeActionFilter = new SetOnce();
    private final SetOnce<MlLifeCycleService> mlLifeCycleService = new SetOnce();
    private final SetOnce<CircuitBreaker> inferenceModelBreaker = new SetOnce();
    private final SetOnce<ModelLoadingService> modelLoadingService = new SetOnce();
    private final SetOnce<MlAutoscalingDeciderService> mlAutoscalingDeciderService = new SetOnce();
    private final SetOnce<DeploymentManager> deploymentManager = new SetOnce();
    private final SetOnce<TrainedModelAllocationClusterService> trainedModelAllocationClusterServiceSetOnce = new SetOnce();
    private static final Collection<AssociatedIndexDescriptor> ASSOCIATED_INDEX_DESCRIPTORS = List.of(new AssociatedIndexDescriptor(".ml-anomalies-*", "Results indices"), new AssociatedIndexDescriptor(".ml-state*", "State indices"), new AssociatedIndexDescriptor(MlStatsIndex.indexPattern(), "ML stats index"), new AssociatedIndexDescriptor(".ml-notifications*", "ML notifications indices"), new AssociatedIndexDescriptor(".ml-annotations*", "ML annotations indices"));

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        if (!this.enabled) {
            return Collections.emptyMap();
        }
        InferenceProcessor.Factory inferenceFactory = new InferenceProcessor.Factory(parameters.client, parameters.ingestService.getClusterService(), this.settings);
        parameters.ingestService.addIngestClusterStateListener((Consumer)inferenceFactory);
        return Collections.singletonMap("inference", inferenceFactory);
    }

    public MachineLearning(Settings settings) {
        this.settings = settings;
        this.enabled = (Boolean)XPackSettings.MACHINE_LEARNING_ENABLED.get(settings);
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public static boolean isMlNode(DiscoveryNode node) {
        return node.getRoles().contains(DiscoveryNodeRole.ML_ROLE);
    }

    public List<Setting<?>> getSettings() {
        return List.of(MachineLearningField.AUTODETECT_PROCESS, PROCESS_CONNECT_TIMEOUT, CONCURRENT_JOB_ALLOCATIONS, MachineLearningField.MAX_MODEL_MEMORY_LIMIT, MAX_LAZY_ML_NODES, MAX_MACHINE_MEMORY_PERCENT, AutodetectBuilder.MAX_ANOMALY_RECORDS_SETTING_DYNAMIC, MAX_OPEN_JOBS_PER_NODE, MIN_DISK_SPACE_OFF_HEAP, MlConfigMigrationEligibilityCheck.ENABLE_CONFIG_MIGRATION, InferenceProcessor.MAX_INFERENCE_PROCESSORS, ModelLoadingService.INFERENCE_MODEL_CACHE_SIZE, ModelLoadingService.INFERENCE_MODEL_CACHE_TTL, ResultsPersisterService.PERSIST_RESULTS_MAX_RETRIES, NIGHTLY_MAINTENANCE_REQUESTS_PER_SECOND, USE_AUTO_MACHINE_MEMORY_PERCENT, MAX_ML_NODE_SIZE, DELAYED_DATA_CHECK_FREQ);
    }

    public Settings additionalSettings() {
        String maxOpenJobsPerNodeNodeAttrName = "node.attr.ml.max_open_jobs";
        String machineMemoryAttrName = "node.attr.ml.machine_memory";
        String jvmSizeAttrName = "node.attr.ml.max_jvm_size";
        if (!this.enabled) {
            this.disallowMlNodeAttributes(maxOpenJobsPerNodeNodeAttrName, machineMemoryAttrName, jvmSizeAttrName);
            return Settings.EMPTY;
        }
        Settings.Builder additionalSettings = Settings.builder();
        if (DiscoveryNode.hasRole((Settings)this.settings, (DiscoveryNodeRole)DiscoveryNodeRole.ML_ROLE)) {
            this.addMlNodeAttribute(additionalSettings, machineMemoryAttrName, Long.toString(OsProbe.getInstance().osStats().getMem().getAdjustedTotal().getBytes()));
            this.addMlNodeAttribute(additionalSettings, jvmSizeAttrName, Long.toString(Runtime.getRuntime().maxMemory()));
            this.disallowMlNodeAttributes(maxOpenJobsPerNodeNodeAttrName);
        } else {
            this.disallowMlNodeAttributes(maxOpenJobsPerNodeNodeAttrName, machineMemoryAttrName, jvmSizeAttrName);
        }
        return additionalSettings.build();
    }

    private void addMlNodeAttribute(Settings.Builder additionalSettings, String attrName, String value) {
        String oldValue = this.settings.get(attrName);
        if (oldValue == null) {
            additionalSettings.put(attrName, value);
        } else {
            this.reportClashingNodeAttribute(attrName);
        }
    }

    private void disallowMlNodeAttributes(String ... mlNodeAttributes) {
        for (String attrName : mlNodeAttributes) {
            if (this.settings.get(attrName) == null) continue;
            this.reportClashingNodeAttribute(attrName);
        }
    }

    private void reportClashingNodeAttribute(String attrName) {
        throw new IllegalArgumentException("Directly setting [" + attrName + "] is not permitted - it is reserved for machine learning. If your intention was to customize machine learning, set the [" + attrName.replace("node.attr.", "xpack.") + "] setting instead.");
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        MlController mlController;
        PyTorchProcessFactory pyTorchProcessFactory;
        NativeMemoryUsageEstimationProcessFactory memoryEstimationProcessFactory;
        NativeAnalyticsProcessFactory analyticsProcessFactory;
        NormalizerProcessFactory normalizerProcessFactory;
        AutodetectProcessFactory autodetectProcessFactory;
        if (!this.enabled) {
            return Collections.singletonList(new JobManagerHolder());
        }
        this.mlUpgradeModeActionFilter.set((Object)new MlUpgradeModeActionFilter(clusterService));
        MlIndexTemplateRegistry registry = new MlIndexTemplateRegistry(this.settings, clusterService, threadPool, client, xContentRegistry);
        registry.initialize();
        AnomalyDetectionAuditor anomalyDetectionAuditor = new AnomalyDetectionAuditor(client, clusterService);
        DataFrameAnalyticsAuditor dataFrameAnalyticsAuditor = new DataFrameAnalyticsAuditor(client, clusterService);
        InferenceAuditor inferenceAuditor = new InferenceAuditor(client, clusterService);
        this.dataFrameAnalyticsAuditor.set((Object)dataFrameAnalyticsAuditor);
        OriginSettingClient originSettingClient = new OriginSettingClient(client, NAME);
        ResultsPersisterService resultsPersisterService = new ResultsPersisterService(threadPool, originSettingClient, clusterService, this.settings);
        AnnotationPersister anomalyDetectionAnnotationPersister = new AnnotationPersister(resultsPersisterService);
        JobResultsProvider jobResultsProvider = new JobResultsProvider(client, this.settings, indexNameExpressionResolver);
        JobResultsPersister jobResultsPersister = new JobResultsPersister(originSettingClient, resultsPersisterService);
        JobDataCountsPersister jobDataCountsPersister = new JobDataCountsPersister(client, resultsPersisterService, anomalyDetectionAuditor);
        JobConfigProvider jobConfigProvider = new JobConfigProvider(client, xContentRegistry);
        DatafeedConfigProvider datafeedConfigProvider = new DatafeedConfigProvider(client, xContentRegistry);
        this.datafeedConfigProvider.set((Object)datafeedConfigProvider);
        UpdateJobProcessNotifier notifier = new UpdateJobProcessNotifier(client, clusterService, threadPool);
        JobManager jobManager = new JobManager(jobResultsProvider, jobResultsPersister, clusterService, anomalyDetectionAuditor, threadPool, client, notifier, xContentRegistry, indexNameExpressionResolver, () -> NativeMemoryCalculator.getMaxModelMemoryLimit(clusterService));
        DatafeedManager datafeedManager = new DatafeedManager(datafeedConfigProvider, jobConfigProvider, xContentRegistry, this.settings, client);
        JobManagerHolder jobManagerHolder = new JobManagerHolder(jobManager);
        NativeStorageProvider nativeStorageProvider = new NativeStorageProvider(environment, (ByteSizeValue)MIN_DISK_SPACE_OFF_HEAP.get(this.settings));
        if (((Boolean)MachineLearningField.AUTODETECT_PROCESS.get(this.settings)).booleanValue()) {
            try {
                NativeController nativeController = NativeController.makeNativeController(clusterService.getNodeName(), environment, xContentRegistry);
                autodetectProcessFactory = new NativeAutodetectProcessFactory(environment, this.settings, nativeController, clusterService, resultsPersisterService, anomalyDetectionAuditor);
                normalizerProcessFactory = new NativeNormalizerProcessFactory(environment, nativeController, clusterService);
                analyticsProcessFactory = new NativeAnalyticsProcessFactory(environment, nativeController, clusterService, xContentRegistry, resultsPersisterService, dataFrameAnalyticsAuditor);
                memoryEstimationProcessFactory = new NativeMemoryUsageEstimationProcessFactory(environment, nativeController, clusterService);
                pyTorchProcessFactory = new NativePyTorchProcessFactory(environment, nativeController, clusterService);
                mlController = nativeController;
            }
            catch (IOException e) {
                logger.trace("Failed to connect to ML native controller", (Throwable)e);
                throw new ElasticsearchException("Failure running machine learning native code. This could be due to running on an unsupported OS or distribution, missing OS libraries, or a problem with the temp directory. To bypass this problem by running Elasticsearch without machine learning functionality set [" + XPackSettings.MACHINE_LEARNING_ENABLED.getKey() + ": false].", new Object[0]);
            }
        } else {
            mlController = new DummyController();
            autodetectProcessFactory = (pipelineId, job, autodetectParams, executorService, onProcessCrash) -> new BlackHoleAutodetectProcess(pipelineId, onProcessCrash);
            normalizerProcessFactory = (jobId, quantilesState, bucketSpan, executorService) -> new MultiplyingNormalizerProcess(1.0);
            analyticsProcessFactory = (jobId, analyticsProcessConfig, hasState, executorService, onProcessCrash) -> null;
            memoryEstimationProcessFactory = (jobId, analyticsProcessConfig, hasState, executorService, onProcessCrash) -> null;
            pyTorchProcessFactory = (task, executorService, onProcessCrash) -> null;
        }
        NormalizerFactory normalizerFactory = new NormalizerFactory(normalizerProcessFactory, threadPool.executor(UTILITY_THREAD_POOL_NAME));
        AutodetectProcessManager autodetectProcessManager = new AutodetectProcessManager(this.settings, client, threadPool, xContentRegistry, anomalyDetectionAuditor, clusterService, jobManager, jobResultsProvider, jobResultsPersister, jobDataCountsPersister, anomalyDetectionAnnotationPersister, autodetectProcessFactory, normalizerFactory, nativeStorageProvider, indexNameExpressionResolver);
        this.autodetectProcessManager.set((Object)autodetectProcessManager);
        DatafeedJobBuilder datafeedJobBuilder = new DatafeedJobBuilder(client, xContentRegistry, anomalyDetectionAuditor, anomalyDetectionAnnotationPersister, System::currentTimeMillis, jobResultsPersister, this.settings, clusterService);
        DatafeedContextProvider datafeedContextProvider = new DatafeedContextProvider(jobConfigProvider, datafeedConfigProvider, jobResultsProvider);
        DatafeedRunner datafeedRunner = new DatafeedRunner(threadPool, client, clusterService, datafeedJobBuilder, System::currentTimeMillis, anomalyDetectionAuditor, autodetectProcessManager, datafeedContextProvider);
        this.datafeedRunner.set((Object)datafeedRunner);
        TrainedModelStatsService trainedModelStatsService = new TrainedModelStatsService(resultsPersisterService, originSettingClient, indexNameExpressionResolver, clusterService, threadPool);
        TrainedModelProvider trainedModelProvider = new TrainedModelProvider(client, xContentRegistry);
        ModelLoadingService modelLoadingService = new ModelLoadingService(trainedModelProvider, inferenceAuditor, threadPool, clusterService, trainedModelStatsService, this.settings, clusterService.getNodeName(), (CircuitBreaker)this.inferenceModelBreaker.get(), this.getLicenseState());
        this.modelLoadingService.set((Object)modelLoadingService);
        this.deploymentManager.set((Object)new DeploymentManager(client, xContentRegistry, threadPool, pyTorchProcessFactory));
        AnalyticsProcessManager analyticsProcessManager = new AnalyticsProcessManager(this.settings, client, threadPool, analyticsProcessFactory, dataFrameAnalyticsAuditor, trainedModelProvider, resultsPersisterService, EsExecutors.allocatedProcessors((Settings)this.settings));
        MemoryUsageEstimationProcessManager memoryEstimationProcessManager = new MemoryUsageEstimationProcessManager(threadPool.generic(), threadPool.executor(UTILITY_THREAD_POOL_NAME), memoryEstimationProcessFactory);
        DataFrameAnalyticsConfigProvider dataFrameAnalyticsConfigProvider = new DataFrameAnalyticsConfigProvider(client, xContentRegistry, dataFrameAnalyticsAuditor);
        assert (client instanceof NodeClient);
        DataFrameAnalyticsManager dataFrameAnalyticsManager = new DataFrameAnalyticsManager(this.settings, (NodeClient)client, threadPool, clusterService, dataFrameAnalyticsConfigProvider, analyticsProcessManager, dataFrameAnalyticsAuditor, indexNameExpressionResolver, resultsPersisterService, modelLoadingService);
        this.dataFrameAnalyticsManager.set((Object)dataFrameAnalyticsManager);
        MlMemoryTracker memoryTracker = new MlMemoryTracker(this.settings, clusterService, threadPool, jobManager, jobResultsProvider, dataFrameAnalyticsConfigProvider);
        this.memoryTracker.set((Object)memoryTracker);
        MlLifeCycleService mlLifeCycleService = new MlLifeCycleService(clusterService, datafeedRunner, mlController, autodetectProcessManager, dataFrameAnalyticsManager, memoryTracker);
        this.mlLifeCycleService.set((Object)mlLifeCycleService);
        MlAssignmentNotifier mlAssignmentNotifier = new MlAssignmentNotifier(anomalyDetectionAuditor, dataFrameAnalyticsAuditor, threadPool, clusterService);
        MlAutoUpdateService mlAutoUpdateService = new MlAutoUpdateService(threadPool, List.of(new DatafeedConfigAutoUpdater(datafeedConfigProvider, indexNameExpressionResolver)));
        clusterService.addListener((ClusterStateListener)mlAutoUpdateService);
        InvalidLicenseEnforcer enforcer = new InvalidLicenseEnforcer(this.getLicenseState(), threadPool, datafeedRunner, autodetectProcessManager);
        enforcer.listenForLicenseStateChanges();
        nativeStorageProvider.cleanupLocalTmpStorageInCaseOfUncleanShutdown();
        TrainedModelAllocationService trainedModelAllocationService = new TrainedModelAllocationService(client, clusterService, threadPool);
        this.trainedModelAllocationClusterServiceSetOnce.set((Object)new TrainedModelAllocationClusterService(this.settings, clusterService, new NodeLoadDetector(memoryTracker)));
        this.mlAutoscalingDeciderService.set((Object)new MlAutoscalingDeciderService(memoryTracker, this.settings, clusterService));
        return Arrays.asList(new Object[]{mlLifeCycleService, new MlControllerHolder(mlController), jobResultsProvider, jobResultsPersister, jobConfigProvider, datafeedConfigProvider, jobManager, jobManagerHolder, autodetectProcessManager, new MlInitializationService(this.settings, threadPool, clusterService, client, mlAssignmentNotifier), jobDataCountsPersister, datafeedRunner, datafeedManager, anomalyDetectionAuditor, dataFrameAnalyticsAuditor, inferenceAuditor, mlAssignmentNotifier, mlAutoUpdateService, memoryTracker, analyticsProcessManager, memoryEstimationProcessManager, dataFrameAnalyticsConfigProvider, nativeStorageProvider, modelLoadingService, trainedModelProvider, trainedModelAllocationService, this.trainedModelAllocationClusterServiceSetOnce.get(), this.deploymentManager.get()});
    }

    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule, IndexNameExpressionResolver expressionResolver) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new PersistentTasksExecutor[]{new OpenJobPersistentTasksExecutor(this.settings, clusterService, (AutodetectProcessManager)this.autodetectProcessManager.get(), (DatafeedConfigProvider)this.datafeedConfigProvider.get(), (MlMemoryTracker)this.memoryTracker.get(), client, expressionResolver, this.getLicenseState()), new TransportStartDatafeedAction.StartDatafeedPersistentTasksExecutor((DatafeedRunner)this.datafeedRunner.get(), expressionResolver), new TransportStartDataFrameAnalyticsAction.TaskExecutor(this.settings, client, clusterService, (DataFrameAnalyticsManager)this.dataFrameAnalyticsManager.get(), (DataFrameAnalyticsAuditor)((Object)this.dataFrameAnalyticsAuditor.get()), (MlMemoryTracker)this.memoryTracker.get(), expressionResolver, this.getLicenseState()), new SnapshotUpgradeTaskExecutor(this.settings, clusterService, (AutodetectProcessManager)this.autodetectProcessManager.get(), (MlMemoryTracker)this.memoryTracker.get(), expressionResolver, client, this.getLicenseState())});
    }

    public List<RestHandler> getRestHandlers(Settings unused, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new RestHandler[]{new RestGetJobsAction(), new RestGetJobStatsAction(), new RestMlInfoAction(), new RestPutJobAction(), new RestPostJobUpdateAction(), new RestDeleteJobAction(), new RestOpenJobAction(), new RestGetFiltersAction(), new RestPutFilterAction(), new RestUpdateFilterAction(), new RestDeleteFilterAction(), new RestGetInfluencersAction(), new RestGetRecordsAction(), new RestGetBucketsAction(), new RestGetOverallBucketsAction(), new RestPostDataAction(), new RestCloseJobAction(), new RestFlushJobAction(), new RestResetJobAction(), new RestValidateDetectorAction(), new RestValidateJobConfigAction(), new RestEstimateModelMemoryAction(), new RestGetCategoriesAction(), new RestGetModelSnapshotsAction(), new RestRevertModelSnapshotAction(), new RestUpdateModelSnapshotAction(), new RestGetDatafeedsAction(), new RestGetDatafeedStatsAction(), new RestPutDatafeedAction(), new RestUpdateDatafeedAction(), new RestDeleteDatafeedAction(), new RestPreviewDatafeedAction(), new RestStartDatafeedAction(), new RestStopDatafeedAction(), new RestDeleteModelSnapshotAction(), new RestDeleteExpiredDataAction(), new RestForecastJobAction(), new RestDeleteForecastAction(), new RestGetCalendarsAction(), new RestPutCalendarAction(), new RestDeleteCalendarAction(), new RestDeleteCalendarEventAction(), new RestDeleteCalendarJobAction(), new RestPutCalendarJobAction(), new RestGetCalendarEventsAction(), new RestPostCalendarEventAction(), new RestSetUpgradeModeAction(), new RestGetDataFrameAnalyticsAction(), new RestGetDataFrameAnalyticsStatsAction(), new RestPutDataFrameAnalyticsAction(), new RestPostDataFrameAnalyticsUpdateAction(), new RestDeleteDataFrameAnalyticsAction(), new RestStartDataFrameAnalyticsAction(), new RestStopDataFrameAnalyticsAction(), new RestEvaluateDataFrameAction(), new RestExplainDataFrameAnalyticsAction(), new RestGetTrainedModelsAction(), new RestDeleteTrainedModelAction(), new RestGetTrainedModelsStatsAction(), new RestPutTrainedModelAction(), new RestUpgradeJobModelSnapshotAction(), new RestGetJobModelSnapshotsUpgradeStatsAction(), new RestPutTrainedModelAliasAction(), new RestDeleteTrainedModelAliasAction(), new RestPreviewDataFrameAnalyticsAction(), new RestStartTrainedModelDeploymentAction(), new RestStopTrainedModelDeploymentAction(), new RestInferTrainedModelDeploymentAction(), new RestPutTrainedModelDefinitionPartAction(), new RestPutTrainedModelVocabularyAction(), new RestCatJobsAction(), new RestCatTrainedModelsAction(), new RestCatDatafeedsAction(), new RestCatDataFrameAnalyticsAction()});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ActionPlugin.ActionHandler usageAction = new ActionPlugin.ActionHandler((ActionType)XPackUsageFeatureAction.MACHINE_LEARNING, MachineLearningUsageTransportAction.class);
        ActionPlugin.ActionHandler infoAction = new ActionPlugin.ActionHandler((ActionType)XPackInfoFeatureAction.MACHINE_LEARNING, MachineLearningInfoTransportAction.class);
        if (!this.enabled) {
            return List.of(usageAction, infoAction);
        }
        return List.of(new ActionPlugin.ActionHandler((ActionType)GetJobsAction.INSTANCE, TransportGetJobsAction.class), new ActionPlugin.ActionHandler((ActionType)GetJobsStatsAction.INSTANCE, TransportGetJobsStatsAction.class), new ActionPlugin.ActionHandler((ActionType)MlInfoAction.INSTANCE, TransportMlInfoAction.class), new ActionPlugin.ActionHandler((ActionType)PutJobAction.INSTANCE, TransportPutJobAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateJobAction.INSTANCE, TransportUpdateJobAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteJobAction.INSTANCE, TransportDeleteJobAction.class), new ActionPlugin.ActionHandler((ActionType)OpenJobAction.INSTANCE, TransportOpenJobAction.class), new ActionPlugin.ActionHandler((ActionType)GetFiltersAction.INSTANCE, TransportGetFiltersAction.class), new ActionPlugin.ActionHandler((ActionType)PutFilterAction.INSTANCE, TransportPutFilterAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateFilterAction.INSTANCE, TransportUpdateFilterAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteFilterAction.INSTANCE, TransportDeleteFilterAction.class), new ActionPlugin.ActionHandler((ActionType)KillProcessAction.INSTANCE, TransportKillProcessAction.class), new ActionPlugin.ActionHandler((ActionType)GetBucketsAction.INSTANCE, TransportGetBucketsAction.class), new ActionPlugin.ActionHandler((ActionType)GetInfluencersAction.INSTANCE, TransportGetInfluencersAction.class), new ActionPlugin.ActionHandler((ActionType)GetOverallBucketsAction.INSTANCE, TransportGetOverallBucketsAction.class), new ActionPlugin.ActionHandler((ActionType)GetRecordsAction.INSTANCE, TransportGetRecordsAction.class), new ActionPlugin.ActionHandler((ActionType)PostDataAction.INSTANCE, TransportPostDataAction.class), new ActionPlugin.ActionHandler((ActionType)CloseJobAction.INSTANCE, TransportCloseJobAction.class), new ActionPlugin.ActionHandler((ActionType)FinalizeJobExecutionAction.INSTANCE, TransportFinalizeJobExecutionAction.class), new ActionPlugin.ActionHandler((ActionType)FlushJobAction.INSTANCE, TransportFlushJobAction.class), new ActionPlugin.ActionHandler((ActionType)ResetJobAction.INSTANCE, TransportResetJobAction.class), new ActionPlugin.ActionHandler((ActionType)ValidateDetectorAction.INSTANCE, TransportValidateDetectorAction.class), new ActionPlugin.ActionHandler((ActionType)ValidateJobConfigAction.INSTANCE, TransportValidateJobConfigAction.class), new ActionPlugin.ActionHandler((ActionType)EstimateModelMemoryAction.INSTANCE, TransportEstimateModelMemoryAction.class), new ActionPlugin.ActionHandler((ActionType)GetCategoriesAction.INSTANCE, TransportGetCategoriesAction.class), new ActionPlugin.ActionHandler((ActionType)GetModelSnapshotsAction.INSTANCE, TransportGetModelSnapshotsAction.class), new ActionPlugin.ActionHandler((ActionType)RevertModelSnapshotAction.INSTANCE, TransportRevertModelSnapshotAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateModelSnapshotAction.INSTANCE, TransportUpdateModelSnapshotAction.class), new ActionPlugin.ActionHandler((ActionType)GetDatafeedsAction.INSTANCE, TransportGetDatafeedsAction.class), new ActionPlugin.ActionHandler((ActionType)GetDatafeedsStatsAction.INSTANCE, TransportGetDatafeedsStatsAction.class), new ActionPlugin.ActionHandler((ActionType)PutDatafeedAction.INSTANCE, TransportPutDatafeedAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateDatafeedAction.INSTANCE, TransportUpdateDatafeedAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteDatafeedAction.INSTANCE, TransportDeleteDatafeedAction.class), new ActionPlugin.ActionHandler((ActionType)PreviewDatafeedAction.INSTANCE, TransportPreviewDatafeedAction.class), new ActionPlugin.ActionHandler((ActionType)StartDatafeedAction.INSTANCE, TransportStartDatafeedAction.class), new ActionPlugin.ActionHandler((ActionType)StopDatafeedAction.INSTANCE, TransportStopDatafeedAction.class), new ActionPlugin.ActionHandler((ActionType)IsolateDatafeedAction.INSTANCE, TransportIsolateDatafeedAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteModelSnapshotAction.INSTANCE, TransportDeleteModelSnapshotAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateProcessAction.INSTANCE, TransportUpdateProcessAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteExpiredDataAction.INSTANCE, TransportDeleteExpiredDataAction.class), new ActionPlugin.ActionHandler((ActionType)ForecastJobAction.INSTANCE, TransportForecastJobAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteForecastAction.INSTANCE, TransportDeleteForecastAction.class), new ActionPlugin.ActionHandler((ActionType)GetCalendarsAction.INSTANCE, TransportGetCalendarsAction.class), new ActionPlugin.ActionHandler((ActionType)PutCalendarAction.INSTANCE, TransportPutCalendarAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteCalendarAction.INSTANCE, TransportDeleteCalendarAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteCalendarEventAction.INSTANCE, TransportDeleteCalendarEventAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateCalendarJobAction.INSTANCE, TransportUpdateCalendarJobAction.class), new ActionPlugin.ActionHandler((ActionType)GetCalendarEventsAction.INSTANCE, TransportGetCalendarEventsAction.class), new ActionPlugin.ActionHandler((ActionType)PostCalendarEventsAction.INSTANCE, TransportPostCalendarEventsAction.class), new ActionPlugin.ActionHandler((ActionType)PersistJobAction.INSTANCE, TransportPersistJobAction.class), new ActionPlugin.ActionHandler((ActionType)SetUpgradeModeAction.INSTANCE, TransportSetUpgradeModeAction.class), new ActionPlugin.ActionHandler((ActionType)GetDataFrameAnalyticsAction.INSTANCE, TransportGetDataFrameAnalyticsAction.class), new ActionPlugin.ActionHandler((ActionType)GetDataFrameAnalyticsStatsAction.INSTANCE, TransportGetDataFrameAnalyticsStatsAction.class), new ActionPlugin.ActionHandler((ActionType)PutDataFrameAnalyticsAction.INSTANCE, TransportPutDataFrameAnalyticsAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateDataFrameAnalyticsAction.INSTANCE, TransportUpdateDataFrameAnalyticsAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteDataFrameAnalyticsAction.INSTANCE, TransportDeleteDataFrameAnalyticsAction.class), new ActionPlugin.ActionHandler((ActionType)StartDataFrameAnalyticsAction.INSTANCE, TransportStartDataFrameAnalyticsAction.class), new ActionPlugin.ActionHandler((ActionType)StopDataFrameAnalyticsAction.INSTANCE, TransportStopDataFrameAnalyticsAction.class), new ActionPlugin.ActionHandler((ActionType)EvaluateDataFrameAction.INSTANCE, TransportEvaluateDataFrameAction.class), new ActionPlugin.ActionHandler((ActionType)ExplainDataFrameAnalyticsAction.INSTANCE, TransportExplainDataFrameAnalyticsAction.class), new ActionPlugin.ActionHandler((ActionType)InternalInferModelAction.INSTANCE, TransportInternalInferModelAction.class), new ActionPlugin.ActionHandler((ActionType)GetTrainedModelsAction.INSTANCE, TransportGetTrainedModelsAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteTrainedModelAction.INSTANCE, TransportDeleteTrainedModelAction.class), new ActionPlugin.ActionHandler((ActionType)GetTrainedModelsStatsAction.INSTANCE, TransportGetTrainedModelsStatsAction.class), new ActionPlugin.ActionHandler((ActionType)PutTrainedModelAction.INSTANCE, TransportPutTrainedModelAction.class), new ActionPlugin.ActionHandler((ActionType)UpgradeJobModelSnapshotAction.INSTANCE, TransportUpgradeJobModelSnapshotAction.class), new ActionPlugin.ActionHandler((ActionType)CancelJobModelSnapshotUpgradeAction.INSTANCE, TransportCancelJobModelSnapshotUpgradeAction.class), new ActionPlugin.ActionHandler((ActionType)GetJobModelSnapshotsUpgradeStatsAction.INSTANCE, TransportGetJobModelSnapshotsUpgradeStatsAction.class), new ActionPlugin.ActionHandler((ActionType)PutTrainedModelAliasAction.INSTANCE, TransportPutTrainedModelAliasAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteTrainedModelAliasAction.INSTANCE, TransportDeleteTrainedModelAliasAction.class), new ActionPlugin.ActionHandler((ActionType)PreviewDataFrameAnalyticsAction.INSTANCE, TransportPreviewDataFrameAnalyticsAction.class), new ActionPlugin.ActionHandler((ActionType)SetResetModeAction.INSTANCE, TransportSetResetModeAction.class), new ActionPlugin.ActionHandler((ActionType)StartTrainedModelDeploymentAction.INSTANCE, TransportStartTrainedModelDeploymentAction.class), new ActionPlugin.ActionHandler((ActionType)StopTrainedModelDeploymentAction.INSTANCE, TransportStopTrainedModelDeploymentAction.class), new ActionPlugin.ActionHandler((ActionType)InferTrainedModelDeploymentAction.INSTANCE, TransportInferTrainedModelDeploymentAction.class), new ActionPlugin.ActionHandler((ActionType)GetDeploymentStatsAction.INSTANCE, TransportGetDeploymentStatsAction.class), new ActionPlugin.ActionHandler((ActionType)GetDatafeedRunningStateAction.INSTANCE, TransportGetDatafeedRunningStateAction.class), new ActionPlugin.ActionHandler((ActionType)CreateTrainedModelAllocationAction.INSTANCE, TransportCreateTrainedModelAllocationAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteTrainedModelAllocationAction.INSTANCE, TransportDeleteTrainedModelAllocationAction.class), new ActionPlugin.ActionHandler((ActionType)PutTrainedModelDefinitionPartAction.INSTANCE, TransportPutTrainedModelDefinitionPartAction.class), new ActionPlugin.ActionHandler((ActionType)PutTrainedModelVocabularyAction.INSTANCE, TransportPutTrainedModelVocabularyAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateTrainedModelAllocationStateAction.INSTANCE, TransportUpdateTrainedModelAllocationStateAction.class), usageAction, infoAction);
    }

    public List<ActionFilter> getActionFilters() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Collections.singletonList((ActionFilter)this.mlUpgradeModeActionFilter.get());
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings unused) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        ScalingExecutorBuilder jobComms = new ScalingExecutorBuilder(JOB_COMMS_THREAD_POOL_NAME, 4, 2048, TimeValue.timeValueMinutes((long)1L), false, "xpack.ml.job_comms_thread_pool");
        ScalingExecutorBuilder utility = new ScalingExecutorBuilder(UTILITY_THREAD_POOL_NAME, 1, 2048, TimeValue.timeValueMinutes((long)10L), false, "xpack.ml.utility_thread_pool");
        ScalingExecutorBuilder datafeed = new ScalingExecutorBuilder(DATAFEED_THREAD_POOL_NAME, 1, 512, TimeValue.timeValueMinutes((long)1L), false, "xpack.ml.datafeed_thread_pool");
        return List.of(jobComms, utility, datafeed);
    }

    public Map<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> getCharFilters() {
        return MapBuilder.newMapBuilder().put((Object)"first_non_blank_line", FirstNonBlankLineCharFilterFactory::new).put((Object)"first_line_with_letters", FirstLineWithLettersCharFilterFactory::new).map();
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> getTokenizers() {
        return Map.of(MlClassicTokenizer.NAME, MlClassicTokenizerFactory::new, MlStandardTokenizer.NAME, MlStandardTokenizerFactory::new);
    }

    public List<SearchPlugin.PipelineAggregationSpec> getPipelineAggregations() {
        return Arrays.asList(InferencePipelineAggregationBuilder.buildSpec(this.modelLoadingService, this.getLicenseState(), this.settings), BucketCorrelationAggregationBuilder.buildSpec(), BucketCountKSTestAggregationBuilder.buildSpec());
    }

    public List<SearchPlugin.SignificanceHeuristicSpec<?>> getSignificanceHeuristics() {
        return List.of(new SearchPlugin.SignificanceHeuristicSpec("p_value", PValueScore::new, PValueScore.PARSER));
    }

    public List<SearchPlugin.AggregationSpec> getAggregations() {
        return List.of(new SearchPlugin.AggregationSpec("categorize_text", CategorizeTextAggregationBuilder::new, CategorizeTextAggregationBuilder.PARSER).addResultReader(InternalCategorizationAggregation::new).setAggregatorRegistrar(s -> s.registerUsage("categorize_text")));
    }

    public static boolean criticalTemplatesInstalled(ClusterState clusterState) {
        boolean allPresent = true;
        List<String> templateNames = List.of(".ml-state", AnomalyDetectorsIndex.jobResultsIndexPrefix());
        for (String templateName : templateNames) {
            allPresent = allPresent && TemplateUtils.checkTemplateExistsAndVersionIsGTECurrentVersion((String)templateName, (ClusterState)clusterState);
        }
        return allPresent;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        ArrayList<NamedXContentRegistry.Entry> namedXContent = new ArrayList<NamedXContentRegistry.Entry>();
        namedXContent.addAll(new MlEvaluationNamedXContentProvider().getNamedXContentParsers());
        namedXContent.addAll(new MlDataFrameAnalysisNamedXContentProvider().getNamedXContentParsers());
        namedXContent.addAll(new MlInferenceNamedXContentProvider().getNamedXContentParsers());
        namedXContent.addAll(new MlModelSizeNamedXContentProvider().getNamedXContentParsers());
        namedXContent.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("trained_model_alias", new String[0]), ModelAliasMetadata::fromXContent));
        namedXContent.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("trained_model_allocation", new String[0]), TrainedModelAllocationMetadata::fromXContent));
        namedXContent.addAll(new CorrelationNamedContentProvider().getNamedXContentParsers());
        return namedXContent;
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();
        namedWriteables.add(new NamedWriteableRegistry.Entry(Metadata.Custom.class, NAME, MlMetadata::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(NamedDiff.class, NAME, MlMetadata.MlMetadataDiff::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(Metadata.Custom.class, "trained_model_alias", ModelAliasMetadata::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "trained_model_alias", ModelAliasMetadata::readDiffFrom));
        namedWriteables.add(new NamedWriteableRegistry.Entry(Metadata.Custom.class, "trained_model_allocation", TrainedModelAllocationMetadata::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "trained_model_allocation", TrainedModelAllocationMetadata::readDiffFrom));
        namedWriteables.add(new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/ml/datafeed", StartDatafeedAction.DatafeedParams::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/ml/job", OpenJobAction.JobParams::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/ml/data_frame/analytics", StartDataFrameAnalyticsAction.TaskParams::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/ml/job/snapshot/upgrade", SnapshotUpgradeTaskParams::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(PersistentTaskState.class, "xpack/ml/job", JobTaskState::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(PersistentTaskState.class, "xpack/ml/datafeed", DatafeedState::fromStream));
        namedWriteables.add(new NamedWriteableRegistry.Entry(PersistentTaskState.class, "xpack/ml/data_frame/analytics", DataFrameAnalyticsTaskState::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(PersistentTaskState.class, "xpack/ml/job/snapshot/upgrade", SnapshotUpgradeTaskState::new));
        namedWriteables.addAll(new MlDataFrameAnalysisNamedXContentProvider().getNamedWriteables());
        namedWriteables.addAll(new AnalysisStatsNamedWriteablesProvider().getNamedWriteables());
        namedWriteables.addAll(MlEvaluationNamedXContentProvider.getNamedWriteables());
        namedWriteables.addAll(new MlInferenceNamedXContentProvider().getNamedWriteables());
        namedWriteables.addAll(MlAutoscalingNamedWritableProvider.getNamedWriteables());
        namedWriteables.addAll(new CorrelationNamedContentProvider().getNamedWriteables());
        return namedWriteables;
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings unused) {
        return List.of(SystemIndexDescriptor.builder().setIndexPattern(MlMetaIndex.indexName() + "*").setPrimaryIndex(MlMetaIndex.indexName()).setDescription("Contains scheduling and anomaly tracking metadata").setMappings(MlMetaIndex.mapping()).setSettings(MlMetaIndex.settings()).setVersionMetaKey("version").setOrigin(NAME).build(), SystemIndexDescriptor.builder().setIndexPattern(MlConfigIndex.indexName() + "*").setPrimaryIndex(MlConfigIndex.indexName()).setDescription("Contains ML configuration data").setMappings(MlConfigIndex.mapping()).setSettings(MlConfigIndex.settings()).setVersionMetaKey("version").setOrigin(NAME).build(), MachineLearning.getInferenceIndexSystemIndexDescriptor());
    }

    public static SystemIndexDescriptor getInferenceIndexSystemIndexDescriptor() {
        return SystemIndexDescriptor.builder().setIndexPattern(".ml-inference-*").setPrimaryIndex(".ml-inference-000005").setDescription("Contains ML model configuration and statistics").setMappings(InferenceIndexConstants.mapping()).setSettings(InferenceIndexConstants.settings()).setVersionMetaKey("version").setOrigin(NAME).build();
    }

    public void prepareForIndicesMigration(ClusterService clusterService, Client client, ActionListener<Map<String, Object>> listener) {
        boolean isAlreadyInUpgradeMode = MlMetadata.getMlMetadata((ClusterState)clusterService.state()).isUpgradeMode();
        if (isAlreadyInUpgradeMode) {
            listener.onResponse(Collections.singletonMap("already_in_upgrade_mode", true));
            return;
        }
        OriginSettingClient originClient = new OriginSettingClient(client, NAME);
        originClient.execute((ActionType)SetUpgradeModeAction.INSTANCE, (ActionRequest)new SetUpgradeModeAction.Request(true), ActionListener.wrap(r -> listener.onResponse(Collections.singletonMap("already_in_upgrade_mode", false)), arg_0 -> listener.onFailure(arg_0)));
    }

    public void indicesMigrationComplete(Map<String, Object> preUpgradeMetadata, ClusterService clusterService, Client client, ActionListener<Boolean> listener) {
        boolean wasAlreadyInUpgradeMode = (Boolean)preUpgradeMetadata.getOrDefault("already_in_upgrade_mode", false);
        if (wasAlreadyInUpgradeMode) {
            listener.onResponse((Object)true);
            return;
        }
        OriginSettingClient originClient = new OriginSettingClient(client, NAME);
        originClient.execute((ActionType)SetUpgradeModeAction.INSTANCE, (ActionRequest)new SetUpgradeModeAction.Request(false), ActionListener.wrap(r -> listener.onResponse((Object)r.isAcknowledged()), arg_0 -> listener.onFailure(arg_0)));
    }

    public Collection<AssociatedIndexDescriptor> getAssociatedIndexDescriptors() {
        return ASSOCIATED_INDEX_DESCRIPTORS;
    }

    public static String[] getMlHiddenIndexPatterns() {
        return (String[])ASSOCIATED_INDEX_DESCRIPTORS.stream().map(AssociatedIndexDescriptor::getIndexPattern).toArray(String[]::new);
    }

    public UnaryOperator<Map<String, IndexTemplateMetadata>> getIndexTemplateMetadataUpgrader() {
        return templates -> {
            templates.remove(".ml-anomalies-");
            templates.remove(".ml-config");
            templates.remove(".ml-inference-000001");
            templates.remove(".ml-inference-000002");
            templates.remove(".ml-inference-000003");
            templates.remove(".ml-meta");
            templates.remove(".ml-notifications");
            templates.remove(".ml-notifications-000001");
            templates.remove(".ml-state");
            templates.remove(".ml-stats");
            return templates;
        };
    }

    public String getFeatureName() {
        return "machine_learning";
    }

    public String getFeatureDescription() {
        return "Provides anomaly detection and forecasting functionality";
    }

    public void cleanUpFeature(ClusterService clusterService, Client unwrappedClient, ActionListener<ResetFeatureStateResponse.ResetFeatureStateStatus> finalListener) {
        logger.info("Starting machine learning feature reset");
        OriginSettingClient client = new OriginSettingClient(unwrappedClient, NAME);
        ConcurrentHashMap results = new ConcurrentHashMap();
        ActionListener unsetResetModeListener = ActionListener.wrap(success -> client.execute((ActionType)SetResetModeAction.INSTANCE, (ActionRequest)SetResetModeActionRequest.disabled((boolean)true), ActionListener.wrap(resetSuccess -> {
            finalListener.onResponse(success);
            logger.info("Finished machine learning feature reset");
        }, resetFailure -> {
            logger.error("failed to disable reset mode after state otherwise successful machine learning reset", (Throwable)resetFailure);
            finalListener.onFailure((Exception)ExceptionsHelper.serverError((String)"failed to disable reset mode after state otherwise successful machine learning reset", (Throwable)resetFailure));
        })), failure -> {
            logger.error("failed to reset machine learning", (Throwable)failure);
            client.execute((ActionType)SetResetModeAction.INSTANCE, (ActionRequest)SetResetModeActionRequest.disabled((boolean)false), ActionListener.wrap(resetSuccess -> finalListener.onFailure(failure), resetFailure -> {
                logger.error("failed to disable reset mode after state clean up failure", (Throwable)resetFailure);
                finalListener.onFailure(failure);
            }));
        });
        ActionListener afterWaitingForTasks = ActionListener.wrap(listTasksResponse -> {
            listTasksResponse.rethrowFailures("Waiting for indexing requests for .ml-* indices");
            if (results.values().stream().allMatch(b -> b)) {
                if (this.memoryTracker.get() != null) {
                    ((MlMemoryTracker)this.memoryTracker.get()).awaitAndClear((ActionListener<Void>)ActionListener.wrap(cacheCleared -> super.cleanUpFeature(clusterService, (Client)client, unsetResetModeListener), clearFailed -> {
                        logger.error("failed to clear memory tracker cache via machine learning reset feature API", (Throwable)clearFailed);
                        super.cleanUpFeature(clusterService, (Client)client, unsetResetModeListener);
                    }));
                    return;
                }
                super.cleanUpFeature(clusterService, (Client)client, unsetResetModeListener);
            } else {
                List failedComponents = results.entrySet().stream().filter(result -> (Boolean)result.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
                unsetResetModeListener.onFailure((Exception)new RuntimeException("Some machine learning components failed to reset: " + failedComponents));
            }
        }, arg_0 -> ((ActionListener)unsetResetModeListener).onFailure(arg_0));
        ActionListener afterDataframesStopped = ActionListener.wrap(dataFrameStopResponse -> {
            results.put("data_frame/analytics", dataFrameStopResponse.isStopped());
            if (results.values().stream().allMatch(b -> b)) {
                ((ListTasksRequestBuilder)client.admin().cluster().prepareListTasks(new String[0]).setActions(new String[]{"xpack/ml/*"})).setWaitForCompletion(true).execute(ActionListener.wrap(listMlTasks -> {
                    listMlTasks.rethrowFailures("Waiting for machine learning tasks");
                    ((ListTasksRequestBuilder)client.admin().cluster().prepareListTasks(new String[0]).setActions(new String[]{"indices:data/write/bulk"})).setDetailed(true).setWaitForCompletion(true).setDescriptions(new String[]{"*.ml-*"}).execute(afterWaitingForTasks);
                }, arg_0 -> ((ActionListener)unsetResetModeListener).onFailure(arg_0)));
            } else {
                List failedComponents = results.entrySet().stream().filter(result -> (Boolean)result.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
                unsetResetModeListener.onFailure((Exception)new RuntimeException("Some machine learning components failed to reset: " + failedComponents));
            }
        }, arg_0 -> ((ActionListener)unsetResetModeListener).onFailure(arg_0));
        ActionListener afterAnomalyDetectionClosed = ActionListener.wrap(closeJobResponse -> {
            results.put("anomaly_detectors", closeJobResponse.isClosed());
            StopDataFrameAnalyticsAction.Request stopDataFramesReq = new StopDataFrameAnalyticsAction.Request("_all").setAllowNoMatch(true);
            client.execute((ActionType)StopDataFrameAnalyticsAction.INSTANCE, (ActionRequest)stopDataFramesReq, ActionListener.wrap(arg_0 -> ((ActionListener)afterDataframesStopped).onResponse(arg_0), failure -> {
                logger.warn("failed stopping data frame analytics jobs for machine learning feature reset. Attempting with force=true", (Throwable)failure);
                client.execute((ActionType)StopDataFrameAnalyticsAction.INSTANCE, (ActionRequest)stopDataFramesReq.setForce(true), afterDataframesStopped);
            }));
        }, arg_0 -> ((ActionListener)unsetResetModeListener).onFailure(arg_0));
        ActionListener afterDataFeedsStopped = ActionListener.wrap(datafeedResponse -> {
            results.put("datafeeds", datafeedResponse.isStopped());
            CloseJobAction.Request closeJobsRequest = new CloseJobAction.Request().setAllowNoMatch(true).setJobId("_all");
            client.execute((ActionType)KillProcessAction.INSTANCE, (ActionRequest)new KillProcessAction.Request("*"), ActionListener.wrap(success -> client.execute((ActionType)CloseJobAction.INSTANCE, (ActionRequest)closeJobsRequest, ActionListener.wrap(arg_0 -> ((ActionListener)afterAnomalyDetectionClosed).onResponse(arg_0), failure -> {
                logger.warn("failed closing anomaly jobs for machine learning feature reset. Attempting with force=true", (Throwable)failure);
                client.execute((ActionType)CloseJobAction.INSTANCE, (ActionRequest)closeJobsRequest.setForce(true), afterAnomalyDetectionClosed);
            })), arg_0 -> ((ActionListener)unsetResetModeListener).onFailure(arg_0)));
        }, arg_0 -> ((ActionListener)unsetResetModeListener).onFailure(arg_0));
        ActionListener cancelSnapshotUpgradesListener = ActionListener.wrap(cancelUpgradesResponse -> {
            StopDatafeedAction.Request stopDatafeedsReq = new StopDatafeedAction.Request("_all").setAllowNoMatch(true);
            client.execute((ActionType)StopDatafeedAction.INSTANCE, (ActionRequest)stopDatafeedsReq, ActionListener.wrap(arg_0 -> ((ActionListener)afterDataFeedsStopped).onResponse(arg_0), failure -> {
                logger.warn("failed stopping datafeeds for machine learning feature reset. Attempting with force=true", (Throwable)failure);
                client.execute((ActionType)StopDatafeedAction.INSTANCE, (ActionRequest)stopDatafeedsReq.setForce(true), afterDataFeedsStopped);
            }));
        }, arg_0 -> ((ActionListener)unsetResetModeListener).onFailure(arg_0));
        ActionListener stopDeploymentsListener = ActionListener.wrap(acknowledgedResponse -> {
            CancelJobModelSnapshotUpgradeAction.Request cancelSnapshotUpgradesReq = new CancelJobModelSnapshotUpgradeAction.Request("_all", "_all");
            client.execute((ActionType)CancelJobModelSnapshotUpgradeAction.INSTANCE, (ActionRequest)cancelSnapshotUpgradesReq, cancelSnapshotUpgradesListener);
        }, arg_0 -> ((ActionListener)unsetResetModeListener).onFailure(arg_0));
        ActionListener pipelineValidation = ActionListener.wrap(acknowledgedResponse -> {
            if (this.trainedModelAllocationClusterServiceSetOnce.get() == null) {
                stopDeploymentsListener.onResponse((Object)AcknowledgedResponse.TRUE);
                return;
            }
            ((TrainedModelAllocationClusterService)this.trainedModelAllocationClusterServiceSetOnce.get()).removeAllModelAllocations((ActionListener<AcknowledgedResponse>)stopDeploymentsListener);
        }, arg_0 -> ((ActionListener)unsetResetModeListener).onFailure(arg_0));
        ActionListener afterResetModeSet = ActionListener.wrap(acknowledgedResponse -> {
            int numberInferenceProcessors = InferenceProcessor.Factory.countNumberInferenceProcessors(clusterService.state());
            if (numberInferenceProcessors > 0) {
                unsetResetModeListener.onFailure((Exception)new RuntimeException("Unable to reset machine learning feature as there are ingest pipelines still referencing trained machine learning models"));
                return;
            }
            pipelineValidation.onResponse((Object)AcknowledgedResponse.of((boolean)true));
        }, arg_0 -> finalListener.onFailure(arg_0));
        client.execute((ActionType)SetResetModeAction.INSTANCE, (ActionRequest)SetResetModeActionRequest.enabled(), afterResetModeSet);
    }

    public BreakerSettings getCircuitBreaker(Settings settingsToUse) {
        return BreakerSettings.updateFromSettings((BreakerSettings)new BreakerSettings(TRAINED_MODEL_CIRCUIT_BREAKER_NAME, DEFAULT_MODEL_CIRCUIT_BREAKER_LIMIT, 1.0, CircuitBreaker.Type.MEMORY, CircuitBreaker.Durability.TRANSIENT), (Settings)settingsToUse);
    }

    public void setCircuitBreaker(CircuitBreaker circuitBreaker) {
        assert (circuitBreaker.getName().equals(TRAINED_MODEL_CIRCUIT_BREAKER_NAME));
        this.inferenceModelBreaker.set((Object)circuitBreaker);
    }

    public Collection<AutoscalingDeciderService> deciders() {
        if (this.enabled) {
            assert (this.mlAutoscalingDeciderService.get() != null);
            return List.of((AutoscalingDeciderService)this.mlAutoscalingDeciderService.get());
        }
        return List.of();
    }

    public boolean safeToShutdown(String nodeId, SingleNodeShutdownMetadata.Type shutdownType) {
        if (!this.enabled) {
            return true;
        }
        return ((MlLifeCycleService)this.mlLifeCycleService.get()).isNodeSafeToShutdown(nodeId);
    }

    public void signalShutdown(Collection<String> shutdownNodeIds) {
        if (this.enabled) {
            ((MlLifeCycleService)this.mlLifeCycleService.get()).signalGracefulShutdown(shutdownNodeIds);
        }
    }
}

