/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.Header;
import com.azure.core.util.logging.ClientLogger;
import java.util.Collections;

public final class ClientOptions {
    private static final int MAX_APPLICATION_ID_LENGTH = 24;
    private final ClientLogger logger = new ClientLogger(ClientOptions.class);
    private Iterable<Header> headers;
    private String applicationId;

    public String getApplicationId() {
        return this.applicationId;
    }

    public ClientOptions setApplicationId(String applicationId) {
        if (CoreUtils.isNullOrEmpty(applicationId)) {
            this.applicationId = applicationId;
            return this;
        }
        if (applicationId.length() > 24) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("'applicationId' length cannot be greater than 24"));
        }
        if (applicationId.contains(" ")) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("'applicationId' must not contain a space."));
        }
        this.applicationId = applicationId;
        return this;
    }

    public ClientOptions setHeaders(Iterable<Header> headers) {
        this.headers = headers;
        return this;
    }

    public Iterable<Header> getHeaders() {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        return this.headers;
    }
}

