/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.JsonPatchDocument;
import com.azure.core.models.JsonPatchOperation;
import com.azure.core.util.CoreUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.List;

final class JsonPatchDocumentSerializer
extends JsonSerializer<JsonPatchDocument> {
    private static final SimpleModule MODULE = new SimpleModule().addSerializer(JsonPatchDocument.class, (JsonSerializer)new JsonPatchDocumentSerializer());

    JsonPatchDocumentSerializer() {
    }

    public static SimpleModule getModule() {
        return MODULE;
    }

    public void serialize(JsonPatchDocument value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        List<JsonPatchOperation> operations = value.getOperations();
        if (CoreUtils.isNullOrEmpty(operations)) {
            return;
        }
        gen.writeStartArray(operations.size());
        for (JsonPatchOperation operation : operations) {
            gen.writeObject((Object)operation);
        }
        gen.writeEndArray();
    }
}

