/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tools.launchers;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;

public class BootstrapJvmOptions {
    public static List<String> bootstrapJvmOptions(Path plugins) throws IOException {
        if (!Files.isDirectory(plugins, new LinkOption[0])) {
            throw new IllegalArgumentException("Plugins path " + plugins + " must be a directory");
        }
        List<PluginInfo> pluginInfo = BootstrapJvmOptions.getPluginInfo(plugins);
        return BootstrapJvmOptions.generateOptions(pluginInfo);
    }

    private static List<PluginInfo> getPluginInfo(Path plugins) throws IOException {
        ArrayList<PluginInfo> pluginInfo = new ArrayList<PluginInfo>();
        List pluginDirs = Files.list(plugins).collect(Collectors.toList());
        for (Path pluginDir : pluginDirs) {
            ArrayList<String> jarFiles = new ArrayList<String>();
            Properties props = new Properties();
            List pluginFiles = Files.list(pluginDir).collect(Collectors.toList());
            for (Path pluginFile : pluginFiles) {
                String lowerCaseName = pluginFile.getFileName().toString().toLowerCase(Locale.ROOT);
                if (lowerCaseName.endsWith(".jar")) {
                    jarFiles.add(pluginFile.toString());
                    continue;
                }
                if (!lowerCaseName.equals("plugin-descriptor.properties")) continue;
                try {
                    InputStream stream = Files.newInputStream(pluginFile, new OpenOption[0]);
                    try {
                        props.load(stream);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            if (props.isEmpty()) continue;
            pluginInfo.add(new PluginInfo(jarFiles, props));
        }
        return pluginInfo;
    }

    static List<String> generateOptions(List<PluginInfo> pluginInfo) {
        ArrayList<String> bootstrapJars = new ArrayList<String>();
        ArrayList<String> bootstrapOptions = new ArrayList<String>();
        for (PluginInfo info : pluginInfo) {
            String type = info.properties.getProperty("type", "isolated").toLowerCase(Locale.ROOT);
            if (!type.equals("bootstrap")) continue;
            bootstrapJars.addAll(info.jarFiles);
            String javaOpts = info.properties.getProperty("java.opts", "");
            if (javaOpts.isBlank()) continue;
            bootstrapOptions.add(javaOpts);
        }
        if (bootstrapJars.isEmpty()) {
            return List.of();
        }
        bootstrapOptions.add("-Xbootclasspath/a:" + String.join((CharSequence)":", bootstrapJars));
        return bootstrapOptions;
    }

    record PluginInfo(List<String> jarFiles, Properties properties) {
    }
}

