/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs.lucene54;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.backward_codecs.packed.LegacyDirectMonotonicReader;
import org.apache.lucene.backward_codecs.packed.LegacyDirectReader;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.xpack.lucene.bwc.codecs.index.LegacyBinaryDocValues;
import org.elasticsearch.xpack.lucene.bwc.codecs.index.LegacyBinaryDocValuesWrapper;
import org.elasticsearch.xpack.lucene.bwc.codecs.index.LegacySortedSetDocValues;
import org.elasticsearch.xpack.lucene.bwc.codecs.index.LegacySortedSetDocValuesWrapper;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene54.Lucene54DocValuesConsumer;

final class Lucene54DocValuesProducer
extends DocValuesProducer
implements Closeable {
    private final Map<String, NumericEntry> numerics;
    private final Map<String, BinaryEntry> binaries;
    private final Map<String, SortedSetEntry> sortedSets;
    private final Map<String, SortedSetEntry> sortedNumerics;
    private final Map<String, NumericEntry> ords;
    private final Map<String, NumericEntry> ordIndexes;
    private final int numFields;
    private final AtomicLong ramBytesUsed;
    private final IndexInput data;
    private final int maxDoc;
    private final Map<String, MonotonicBlockPackedReader> addressInstances;
    private final Map<String, ReverseTermsIndex> reverseIndexInstances;
    private final Map<String, LegacyDirectMonotonicReader.Meta> directAddressesMeta;
    private final boolean merging;

    Lucene54DocValuesProducer(Lucene54DocValuesProducer original) {
        this.numerics = new HashMap<String, NumericEntry>();
        this.binaries = new HashMap<String, BinaryEntry>();
        this.sortedSets = new HashMap<String, SortedSetEntry>();
        this.sortedNumerics = new HashMap<String, SortedSetEntry>();
        this.ords = new HashMap<String, NumericEntry>();
        this.ordIndexes = new HashMap<String, NumericEntry>();
        this.addressInstances = new HashMap<String, MonotonicBlockPackedReader>();
        this.reverseIndexInstances = new HashMap<String, ReverseTermsIndex>();
        this.directAddressesMeta = new HashMap<String, LegacyDirectMonotonicReader.Meta>();
        assert (Thread.holdsLock(original));
        this.numerics.putAll(original.numerics);
        this.binaries.putAll(original.binaries);
        this.sortedSets.putAll(original.sortedSets);
        this.sortedNumerics.putAll(original.sortedNumerics);
        this.ords.putAll(original.ords);
        this.ordIndexes.putAll(original.ordIndexes);
        this.numFields = original.numFields;
        this.ramBytesUsed = new AtomicLong(original.ramBytesUsed.get());
        this.data = original.data.clone();
        this.maxDoc = original.maxDoc;
        this.addressInstances.putAll(original.addressInstances);
        this.reverseIndexInstances.putAll(original.reverseIndexInstances);
        this.merging = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Lucene54DocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int numFields;
        int version;
        block16: {
            this.numerics = new HashMap<String, NumericEntry>();
            this.binaries = new HashMap<String, BinaryEntry>();
            this.sortedSets = new HashMap<String, SortedSetEntry>();
            this.sortedNumerics = new HashMap<String, SortedSetEntry>();
            this.ords = new HashMap<String, NumericEntry>();
            this.ordIndexes = new HashMap<String, NumericEntry>();
            this.addressInstances = new HashMap<String, MonotonicBlockPackedReader>();
            this.reverseIndexInstances = new HashMap<String, ReverseTermsIndex>();
            this.directAddressesMeta = new HashMap<String, LegacyDirectMonotonicReader.Meta>();
            String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
            this.maxDoc = state.segmentInfo.maxDoc();
            this.merging = false;
            this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(this.getClass()));
            version = -1;
            numFields = -1;
            try (ChecksumIndexInput in = EndiannessReverserUtil.openChecksumInput((Directory)state.directory, (String)metaName, (IOContext)state.context);){
                Throwable priorE = null;
                try {
                    version = CodecUtil.checkIndexHeader((DataInput)in, (String)metaCodec, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    numFields = this.readFields((IndexInput)in, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block16;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)in, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)in, (Throwable)priorE);
            }
        }
        this.numFields = numFields;
        String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
        this.data = EndiannessReverserUtil.openInput((Directory)state.directory, (String)dataName, (IOContext)state.context);
        boolean success = false;
        try {
            int version2 = CodecUtil.checkIndexHeader((DataInput)this.data, (String)dataCodec, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + version + ", data=" + version2, (DataInput)this.data);
            }
            CodecUtil.retrieveChecksum((IndexInput)this.data);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)this.data);
            }
        }
    }

    private void readSortedField(FieldInfo info, IndexInput meta) throws IOException {
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sorted entry for field: " + info.name + " is corrupt", (DataInput)meta);
        }
        if (meta.readByte() != 1) {
            throw new CorruptIndexException("sorted entry for field: " + info.name + " is corrupt", (DataInput)meta);
        }
        BinaryEntry b = this.readBinaryEntry(info, meta);
        this.binaries.put(info.name, b);
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sorted entry for field: " + info.name + " is corrupt", (DataInput)meta);
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sorted entry for field: " + info.name + " is corrupt", (DataInput)meta);
        }
        NumericEntry n = this.readNumericEntry(info, meta);
        this.ords.put(info.name, n);
    }

    private void readSortedSetFieldWithAddresses(FieldInfo info, IndexInput meta) throws IOException {
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", (DataInput)meta);
        }
        if (meta.readByte() != 1) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", (DataInput)meta);
        }
        BinaryEntry b = this.readBinaryEntry(info, meta);
        this.binaries.put(info.name, b);
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", (DataInput)meta);
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", (DataInput)meta);
        }
        NumericEntry n1 = this.readNumericEntry(info, meta);
        this.ords.put(info.name, n1);
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", (DataInput)meta);
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", (DataInput)meta);
        }
        NumericEntry n2 = this.readNumericEntry(info, meta);
        this.ordIndexes.put(info.name, n2);
    }

    private void readSortedSetFieldWithTable(FieldInfo info, IndexInput meta) throws IOException {
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", (DataInput)meta);
        }
        if (meta.readByte() != 1) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", (DataInput)meta);
        }
        BinaryEntry b = this.readBinaryEntry(info, meta);
        this.binaries.put(info.name, b);
        if (meta.readVInt() != info.number) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", (DataInput)meta);
        }
        if (meta.readByte() != 0) {
            throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", (DataInput)meta);
        }
        NumericEntry n = this.readNumericEntry(info, meta);
        this.ords.put(info.name, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int numFields = 0;
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            ++numFields;
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            byte type = meta.readByte();
            if (type == 0) {
                this.numerics.put(info.name, this.readNumericEntry(info, meta));
            } else if (type == 1) {
                BinaryEntry b = this.readBinaryEntry(info, meta);
                this.binaries.put(info.name, b);
            } else if (type == 2) {
                this.readSortedField(info, meta);
            } else if (type == 3) {
                ss = this.readSortedSetEntry(meta);
                this.sortedSets.put(info.name, ss);
                if (ss.format == 0) {
                    this.readSortedSetFieldWithAddresses(info, meta);
                } else if (ss.format == 2) {
                    this.readSortedSetFieldWithTable(info, meta);
                } else {
                    if (ss.format != 1) throw new AssertionError();
                    if (meta.readVInt() != fieldNumber) {
                        throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", (DataInput)meta);
                    }
                    if (meta.readByte() != 2) {
                        throw new CorruptIndexException("sortedset entry for field: " + info.name + " is corrupt", (DataInput)meta);
                    }
                    this.readSortedField(info, meta);
                }
            } else {
                if (type != 4) throw new CorruptIndexException("invalid type: " + type, (DataInput)meta);
                ss = this.readSortedSetEntry(meta);
                this.sortedNumerics.put(info.name, ss);
                if (ss.format == 0) {
                    if (meta.readVInt() != fieldNumber) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt", (DataInput)meta);
                    }
                    if (meta.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt", (DataInput)meta);
                    }
                    this.numerics.put(info.name, this.readNumericEntry(info, meta));
                    if (meta.readVInt() != fieldNumber) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt", (DataInput)meta);
                    }
                    if (meta.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt", (DataInput)meta);
                    }
                    NumericEntry ordIndex = this.readNumericEntry(info, meta);
                    this.ordIndexes.put(info.name, ordIndex);
                } else if (ss.format == 2) {
                    if (meta.readVInt() != info.number) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt", (DataInput)meta);
                    }
                    if (meta.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt", (DataInput)meta);
                    }
                    NumericEntry n = this.readNumericEntry(info, meta);
                    this.ords.put(info.name, n);
                } else {
                    if (ss.format != 1) throw new AssertionError();
                    if (meta.readVInt() != fieldNumber) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt", (DataInput)meta);
                    }
                    if (meta.readByte() != 0) {
                        throw new CorruptIndexException("sortednumeric entry for field: " + info.name + " is corrupt", (DataInput)meta);
                    }
                    this.numerics.put(info.name, this.readNumericEntry(info, meta));
                }
            }
            fieldNumber = meta.readVInt();
        }
        return numFields;
    }

    private NumericEntry readNumericEntry(FieldInfo info, IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        entry.format = meta.readVInt();
        entry.missingOffset = meta.readLong();
        if (entry.format == 5) {
            entry.numDocsWithValue = meta.readVLong();
            int blockShift = meta.readVInt();
            entry.monotonicMeta = LegacyDirectMonotonicReader.loadMeta((IndexInput)meta, (long)entry.numDocsWithValue, (int)blockShift);
            this.ramBytesUsed.addAndGet(entry.monotonicMeta.ramBytesUsed());
            this.directAddressesMeta.put(info.name, entry.monotonicMeta);
        }
        entry.offset = meta.readLong();
        entry.count = meta.readVLong();
        switch (entry.format) {
            case 4: {
                entry.minValue = meta.readLong();
                if (entry.count <= Integer.MAX_VALUE) break;
                throw new CorruptIndexException("illegal CONST_COMPRESSED count: " + entry.count, (DataInput)meta);
            }
            case 1: {
                entry.minValue = meta.readLong();
                entry.gcd = meta.readLong();
                entry.bitsPerValue = meta.readVInt();
                break;
            }
            case 2: {
                int uniqueValues = meta.readVInt();
                if (uniqueValues > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, got=" + uniqueValues, (DataInput)meta);
                }
                entry.table = new long[uniqueValues];
                for (int i = 0; i < uniqueValues; ++i) {
                    entry.table[i] = meta.readLong();
                }
                this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf((long[])entry.table));
                entry.bitsPerValue = meta.readVInt();
                break;
            }
            case 0: {
                entry.minValue = meta.readLong();
                entry.bitsPerValue = meta.readVInt();
                break;
            }
            case 3: {
                int blockShift = meta.readVInt();
                entry.monotonicMeta = LegacyDirectMonotonicReader.loadMeta((IndexInput)meta, (long)(this.maxDoc + 1), (int)blockShift);
                this.ramBytesUsed.addAndGet(entry.monotonicMeta.ramBytesUsed());
                this.directAddressesMeta.put(info.name, entry.monotonicMeta);
                break;
            }
            case 5: {
                byte numberType = meta.readByte();
                switch (numberType) {
                    case 0: {
                        entry.numberType = Lucene54DocValuesConsumer.NumberType.VALUE;
                        break;
                    }
                    case 1: {
                        entry.numberType = Lucene54DocValuesConsumer.NumberType.ORDINAL;
                        break;
                    }
                    default: {
                        throw new CorruptIndexException("Number type can only be 0 or 1, got=" + numberType, (DataInput)meta);
                    }
                }
                int fieldNumber = meta.readVInt();
                if (fieldNumber != info.number) {
                    throw new CorruptIndexException("Field numbers mistmatch: " + fieldNumber + " != " + info.number, (DataInput)meta);
                }
                byte dvFormat = meta.readByte();
                if (dvFormat != 0) {
                    throw new CorruptIndexException("Formats mistmatch: " + dvFormat + " != 0", (DataInput)meta);
                }
                entry.nonMissingValues = this.readNumericEntry(info, meta);
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry.format + ", input=", (DataInput)meta);
            }
        }
        entry.endOffset = meta.readLong();
        return entry;
    }

    private BinaryEntry readBinaryEntry(FieldInfo info, IndexInput meta) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.format = meta.readVInt();
        entry.missingOffset = meta.readLong();
        entry.minLength = meta.readVInt();
        entry.maxLength = meta.readVInt();
        entry.count = meta.readVLong();
        entry.offset = meta.readLong();
        switch (entry.format) {
            case 0: {
                break;
            }
            case 2: {
                entry.addressesOffset = meta.readLong();
                entry.packedIntsVersion = meta.readVInt();
                entry.blockSize = meta.readVInt();
                entry.reverseIndexOffset = meta.readLong();
                break;
            }
            case 1: {
                entry.addressesOffset = meta.readLong();
                int blockShift = meta.readVInt();
                entry.addressesMeta = LegacyDirectMonotonicReader.loadMeta((IndexInput)meta, (long)(entry.count + 1L), (int)blockShift);
                this.ramBytesUsed.addAndGet(entry.addressesMeta.ramBytesUsed());
                this.directAddressesMeta.put(info.name, entry.addressesMeta);
                entry.addressesEndOffset = meta.readLong();
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry.format, (DataInput)meta);
            }
        }
        return entry;
    }

    SortedSetEntry readSortedSetEntry(IndexInput meta) throws IOException {
        SortedSetEntry entry = new SortedSetEntry();
        entry.format = meta.readVInt();
        if (entry.format == 2) {
            int totalTableLength = meta.readInt();
            if (totalTableLength > 256) {
                throw new CorruptIndexException("SORTED_SET_TABLE cannot have more than 256 values in its dictionary, got=" + totalTableLength, (DataInput)meta);
            }
            entry.table = new long[totalTableLength];
            for (int i = 0; i < totalTableLength; ++i) {
                entry.table[i] = meta.readLong();
            }
            this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf((long[])entry.table));
            int tableSize = meta.readInt();
            if (tableSize > totalTableLength + 1) {
                throw new CorruptIndexException("SORTED_SET_TABLE cannot have more set ids than ords in its dictionary, got " + totalTableLength + " ords and " + tableSize + " sets", (DataInput)meta);
            }
            entry.tableOffsets = new int[tableSize + 1];
            for (int i = 1; i < entry.tableOffsets.length; ++i) {
                entry.tableOffsets[i] = entry.tableOffsets[i - 1] + meta.readInt();
            }
            this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf((int[])entry.tableOffsets));
        } else if (entry.format != 1 && entry.format != 0) {
            throw new CorruptIndexException("Unknown format: " + entry.format, (DataInput)meta);
        }
        return entry;
    }

    public NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericEntry entry = this.numerics.get(field.name);
        if (entry.format == 5) {
            return this.getSparseNumericDocValues(entry);
        }
        if (entry.missingOffset == -2L) {
            return DocValues.emptyNumeric();
        }
        if (entry.missingOffset == -1L) {
            final LongValues values = this.getNumeric(entry);
            return new NumericDocValues(){
                private int docID = -1;

                public int docID() {
                    return this.docID;
                }

                public int nextDoc() {
                    ++this.docID;
                    if (this.docID == Lucene54DocValuesProducer.this.maxDoc) {
                        this.docID = Integer.MAX_VALUE;
                    }
                    return this.docID;
                }

                public int advance(int target) {
                    this.docID = target >= Lucene54DocValuesProducer.this.maxDoc ? Integer.MAX_VALUE : target;
                    return this.docID;
                }

                public boolean advanceExact(int target) throws IOException {
                    this.docID = target;
                    return true;
                }

                public long cost() {
                    return 0L;
                }

                public long longValue() {
                    return values.get((long)this.docID);
                }
            };
        }
        final Bits docsWithField = this.getLiveBits(entry.missingOffset, this.maxDoc);
        final LongValues values = this.getNumeric(entry);
        return new NumericDocValues(){
            int doc = -1;
            long value;

            public long longValue() throws IOException {
                return this.value;
            }

            public int docID() {
                return this.doc;
            }

            public int nextDoc() throws IOException {
                return this.advance(this.doc + 1);
            }

            public int advance(int target) throws IOException {
                for (int doc = target; doc < Lucene54DocValuesProducer.this.maxDoc; ++doc) {
                    this.value = values.get((long)doc);
                    if (this.value == 0L && !docsWithField.get(doc)) continue;
                    this.doc = doc;
                    return this.doc;
                }
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            public boolean advanceExact(int target) throws IOException {
                this.doc = target;
                this.value = values.get((long)this.doc);
                return this.value != 0L || docsWithField.get(this.doc);
            }

            public long cost() {
                return Lucene54DocValuesProducer.this.maxDoc;
            }
        };
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.data);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.numFields + ")";
    }

    LongValues getNumeric(NumericEntry entry) throws IOException {
        switch (entry.format) {
            case 4: {
                final long constant = entry.minValue;
                final Bits live = this.getLiveBits(entry.missingOffset, (int)entry.count);
                return new LongValues(){

                    public long get(long index) {
                        return live.get((int)index) ? constant : 0L;
                    }
                };
            }
            case 0: {
                RandomAccessInput slice = this.data.randomAccessSlice(entry.offset, entry.endOffset - entry.offset);
                final long delta = entry.minValue;
                final LongValues values = LegacyDirectReader.getInstance((RandomAccessInput)slice, (int)entry.bitsPerValue, (long)0L);
                return new LongValues(){

                    public long get(long id) {
                        return delta + values.get(id);
                    }
                };
            }
            case 1: {
                RandomAccessInput slice = this.data.randomAccessSlice(entry.offset, entry.endOffset - entry.offset);
                final long min = entry.minValue;
                final long mult = entry.gcd;
                final LongValues quotientReader = LegacyDirectReader.getInstance((RandomAccessInput)slice, (int)entry.bitsPerValue, (long)0L);
                return new LongValues(){

                    public long get(long id) {
                        return min + mult * quotientReader.get(id);
                    }
                };
            }
            case 2: {
                RandomAccessInput slice = this.data.randomAccessSlice(entry.offset, entry.endOffset - entry.offset);
                final long[] table = entry.table;
                final LongValues ords = LegacyDirectReader.getInstance((RandomAccessInput)slice, (int)entry.bitsPerValue, (long)0L);
                return new LongValues(){

                    public long get(long id) {
                        return table[(int)ords.get(id)];
                    }
                };
            }
            case 5: {
                SparseNumericDocValues values = this.getSparseNumericDocValues(entry);
                return new SparseNumericDocValuesRandomAccessWrapper(values, switch (entry.numberType) {
                    case Lucene54DocValuesConsumer.NumberType.ORDINAL -> -1L;
                    case Lucene54DocValuesConsumer.NumberType.VALUE -> 0L;
                    default -> throw new AssertionError();
                });
            }
        }
        throw new AssertionError();
    }

    LegacyBinaryDocValues getLegacyBinary(FieldInfo field) throws IOException {
        BinaryEntry bytes = this.binaries.get(field.name);
        switch (bytes.format) {
            case 0: {
                return this.getFixedBinary(field, bytes);
            }
            case 1: {
                return this.getVariableBinary(field, bytes);
            }
            case 2: {
                return this.getCompressedBinary(field, bytes);
            }
        }
        throw new AssertionError();
    }

    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BinaryEntry be = this.binaries.get(field.name);
        return new LegacyBinaryDocValuesWrapper(this.getLiveBits(be.missingOffset, this.maxDoc), this.getLegacyBinary(field));
    }

    private LegacyBinaryDocValues getFixedBinary(FieldInfo field, BinaryEntry bytes) throws IOException {
        final IndexInput data = this.data.slice("fixed-binary", bytes.offset, bytes.count * (long)bytes.maxLength);
        final BytesRef term = new BytesRef(bytes.maxLength);
        final byte[] buffer = term.bytes;
        final int length = term.length = bytes.maxLength;
        return new LongBinaryDocValues(){

            @Override
            public BytesRef get(long id) {
                try {
                    data.seek(id * (long)length);
                    data.readBytes(buffer, 0, buffer.length);
                    return term;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private LegacyBinaryDocValues getVariableBinary(FieldInfo field, BinaryEntry bytes) throws IOException {
        RandomAccessInput addressesData = this.data.randomAccessSlice(bytes.addressesOffset, bytes.addressesEndOffset - bytes.addressesOffset);
        LegacyDirectMonotonicReader addresses = LegacyDirectMonotonicReader.getInstance((LegacyDirectMonotonicReader.Meta)bytes.addressesMeta, (RandomAccessInput)addressesData);
        IndexInput data = this.data.slice("var-binary", bytes.offset, bytes.addressesOffset - bytes.offset);
        BytesRef term = new BytesRef(Math.max(0, bytes.maxLength));
        byte[] buffer = term.bytes;
        return new LongBinaryDocValues((LongValues)addresses, data, buffer, term){
            final /* synthetic */ LongValues val$addresses;
            final /* synthetic */ IndexInput val$data;
            final /* synthetic */ byte[] val$buffer;
            final /* synthetic */ BytesRef val$term;
            {
                this.val$addresses = longValues;
                this.val$data = indexInput;
                this.val$buffer = byArray;
                this.val$term = bytesRef;
            }

            @Override
            public BytesRef get(long id) {
                long startAddress = this.val$addresses.get(id);
                long endAddress = this.val$addresses.get(id + 1L);
                int length = (int)(endAddress - startAddress);
                try {
                    this.val$data.seek(startAddress);
                    this.val$data.readBytes(this.val$buffer, 0, length);
                    this.val$term.length = length;
                    return this.val$term;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private synchronized MonotonicBlockPackedReader getIntervalInstance(FieldInfo field, BinaryEntry bytes) throws IOException {
        MonotonicBlockPackedReader addresses = this.addressInstances.get(field.name);
        if (addresses == null) {
            this.data.seek(bytes.addressesOffset);
            long size = bytes.count + 15L >>> 4;
            addresses = MonotonicBlockPackedReader.of((IndexInput)this.data, (int)bytes.packedIntsVersion, (int)bytes.blockSize, (long)size);
            if (!this.merging) {
                this.addressInstances.put(field.name, addresses);
                this.ramBytesUsed.addAndGet(addresses.ramBytesUsed() + 4L);
            }
        }
        return addresses;
    }

    private synchronized ReverseTermsIndex getReverseIndexInstance(FieldInfo field, BinaryEntry bytes) throws IOException {
        ReverseTermsIndex index = this.reverseIndexInstances.get(field.name);
        if (index == null) {
            index = new ReverseTermsIndex();
            this.data.seek(bytes.reverseIndexOffset);
            long size = bytes.count + 1023L >>> 10;
            index.termAddresses = MonotonicBlockPackedReader.of((IndexInput)this.data, (int)bytes.packedIntsVersion, (int)bytes.blockSize, (long)size);
            long dataSize = this.data.readVLong();
            PagedBytes pagedBytes = new PagedBytes(15);
            pagedBytes.copy(this.data, dataSize);
            index.terms = pagedBytes.freeze(true);
            if (!this.merging) {
                this.reverseIndexInstances.put(field.name, index);
                this.ramBytesUsed.addAndGet(index.ramBytesUsed());
            }
        }
        return index;
    }

    private LegacyBinaryDocValues getCompressedBinary(FieldInfo field, BinaryEntry bytes) throws IOException {
        MonotonicBlockPackedReader addresses = this.getIntervalInstance(field, bytes);
        ReverseTermsIndex index = this.getReverseIndexInstance(field, bytes);
        assert (addresses.size() > 0L);
        IndexInput slice = this.data.slice("terms", bytes.offset, bytes.addressesOffset - bytes.offset);
        return new CompressedBinaryDocValues(bytes, addresses, index, slice);
    }

    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        final int valueCount = (int)this.binaries.get((Object)field.name).count;
        final LegacyBinaryDocValues binary = this.getLegacyBinary(field);
        NumericEntry entry = this.ords.get(field.name);
        final LongValues ordinals = this.getNumeric(entry);
        if (entry.format == 5) {
            final SparseNumericDocValues sparseValues = ((SparseNumericDocValuesRandomAccessWrapper)ordinals).values;
            return new SortedDocValues(){

                public int ordValue() {
                    return (int)sparseValues.longValue();
                }

                public BytesRef lookupOrd(int ord) {
                    return binary.get(ord);
                }

                public int getValueCount() {
                    return valueCount;
                }

                public int docID() {
                    return sparseValues.docID();
                }

                public int nextDoc() throws IOException {
                    return sparseValues.nextDoc();
                }

                public int advance(int target) throws IOException {
                    return sparseValues.advance(target);
                }

                public boolean advanceExact(int target) throws IOException {
                    return sparseValues.advanceExact(target);
                }

                public long cost() {
                    return sparseValues.cost();
                }
            };
        }
        return new SortedDocValues(){
            private int docID = -1;
            private int ord;

            public int docID() {
                return this.docID;
            }

            public int nextDoc() throws IOException {
                assert (this.docID != Integer.MAX_VALUE);
                do {
                    ++this.docID;
                    if (this.docID == Lucene54DocValuesProducer.this.maxDoc) {
                        this.docID = Integer.MAX_VALUE;
                        break;
                    }
                    this.ord = (int)ordinals.get((long)this.docID);
                } while (this.ord == -1);
                return this.docID;
            }

            public int advance(int target) throws IOException {
                if (target >= Lucene54DocValuesProducer.this.maxDoc) {
                    this.docID = Integer.MAX_VALUE;
                    return this.docID;
                }
                this.docID = target - 1;
                return this.nextDoc();
            }

            public boolean advanceExact(int target) throws IOException {
                this.docID = target;
                this.ord = (int)ordinals.get((long)target);
                return this.ord != -1;
            }

            public int ordValue() {
                return this.ord;
            }

            public long cost() {
                return 0L;
            }

            public BytesRef lookupOrd(int ord) {
                return binary.get(ord);
            }

            public int getValueCount() {
                return valueCount;
            }

            public int lookupTerm(BytesRef key) throws IOException {
                if (binary instanceof CompressedBinaryDocValues) {
                    return (int)((CompressedBinaryDocValues)binary).lookupTerm(key);
                }
                return super.lookupTerm(key);
            }

            public TermsEnum termsEnum() throws IOException {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).getTermsEnum();
                }
                return super.termsEnum();
            }
        };
    }

    private LongValues getOrdIndexInstance(FieldInfo field, NumericEntry entry) throws IOException {
        RandomAccessInput data = this.data.randomAccessSlice(entry.offset, entry.endOffset - entry.offset);
        return LegacyDirectMonotonicReader.getInstance((LegacyDirectMonotonicReader.Meta)entry.monotonicMeta, (RandomAccessInput)data);
    }

    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        SortedSetEntry ss = this.sortedNumerics.get(field.name);
        if (ss.format == 1) {
            NumericEntry numericEntry = this.numerics.get(field.name);
            final LongValues values = this.getNumeric(numericEntry);
            if (numericEntry.format == 5) {
                final SparseNumericDocValues sparseValues = ((SparseNumericDocValuesRandomAccessWrapper)values).values;
                return new SortedNumericDocValues(){

                    public long nextValue() throws IOException {
                        return sparseValues.longValue();
                    }

                    public int docValueCount() {
                        return 1;
                    }

                    public int docID() {
                        return sparseValues.docID();
                    }

                    public int nextDoc() throws IOException {
                        return sparseValues.nextDoc();
                    }

                    public int advance(int target) throws IOException {
                        return sparseValues.advance(target);
                    }

                    public boolean advanceExact(int target) throws IOException {
                        return sparseValues.advanceExact(target);
                    }

                    public long cost() {
                        return sparseValues.cost();
                    }
                };
            }
            final Bits docsWithField = this.getLiveBits(numericEntry.missingOffset, this.maxDoc);
            return new SortedNumericDocValues(){
                int docID = -1;

                public int docID() {
                    return this.docID;
                }

                public int nextDoc() {
                    do {
                        ++this.docID;
                        if (this.docID != Lucene54DocValuesProducer.this.maxDoc) continue;
                        this.docID = Integer.MAX_VALUE;
                        break;
                    } while (!docsWithField.get(this.docID));
                    return this.docID;
                }

                public int advance(int target) {
                    if (target >= Lucene54DocValuesProducer.this.maxDoc) {
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.docID = target - 1;
                    return this.nextDoc();
                }

                public boolean advanceExact(int target) throws IOException {
                    this.docID = target;
                    return docsWithField.get(this.docID);
                }

                public long cost() {
                    return 0L;
                }

                public int docValueCount() {
                    return 1;
                }

                public long nextValue() {
                    return values.get((long)this.docID);
                }
            };
        }
        if (ss.format == 0) {
            NumericEntry numericEntry = this.numerics.get(field.name);
            final LongValues values = this.getNumeric(numericEntry);
            final LongValues ordIndex = this.getOrdIndexInstance(field, this.ordIndexes.get(field.name));
            return new SortedNumericDocValues(){
                long startOffset;
                long endOffset;
                int docID = -1;
                long upto;

                public int docID() {
                    return this.docID;
                }

                public int nextDoc() {
                    do {
                        ++this.docID;
                        if (this.docID == Lucene54DocValuesProducer.this.maxDoc) {
                            this.docID = Integer.MAX_VALUE;
                            return this.docID;
                        }
                        this.startOffset = ordIndex.get((long)this.docID);
                        this.endOffset = ordIndex.get((long)this.docID + 1L);
                    } while (this.endOffset <= this.startOffset);
                    this.upto = this.startOffset;
                    return this.docID;
                }

                public int advance(int target) {
                    if (target >= Lucene54DocValuesProducer.this.maxDoc) {
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.docID = target - 1;
                    return this.nextDoc();
                }

                public boolean advanceExact(int target) throws IOException {
                    this.docID = target;
                    this.startOffset = ordIndex.get((long)this.docID);
                    this.endOffset = ordIndex.get((long)this.docID + 1L);
                    this.upto = this.startOffset;
                    return this.endOffset > this.startOffset;
                }

                public long cost() {
                    return 0L;
                }

                public int docValueCount() {
                    return (int)(this.endOffset - this.startOffset);
                }

                public long nextValue() {
                    return values.get(this.upto++);
                }
            };
        }
        if (ss.format == 2) {
            NumericEntry entry = this.ords.get(field.name);
            final LongValues ordinals = this.getNumeric(entry);
            final long[] table = ss.table;
            final int[] offsets = ss.tableOffsets;
            return new SortedNumericDocValues(){
                int startOffset;
                int endOffset;
                int docID = -1;
                int upto;

                public int docID() {
                    return this.docID;
                }

                public int nextDoc() {
                    do {
                        ++this.docID;
                        if (this.docID == Lucene54DocValuesProducer.this.maxDoc) {
                            this.docID = Integer.MAX_VALUE;
                            return this.docID;
                        }
                        int ord = (int)ordinals.get((long)this.docID);
                        this.startOffset = offsets[ord];
                        this.endOffset = offsets[ord + 1];
                    } while (this.endOffset <= this.startOffset);
                    this.upto = this.startOffset;
                    return this.docID;
                }

                public int advance(int target) {
                    if (target >= Lucene54DocValuesProducer.this.maxDoc) {
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    this.docID = target - 1;
                    return this.nextDoc();
                }

                public boolean advanceExact(int target) throws IOException {
                    this.docID = target;
                    int ord = (int)ordinals.get((long)this.docID);
                    this.startOffset = offsets[ord];
                    this.endOffset = offsets[ord + 1];
                    this.upto = this.startOffset;
                    return this.endOffset > this.startOffset;
                }

                public long cost() {
                    return 0L;
                }

                public int docValueCount() {
                    return this.endOffset - this.startOffset;
                }

                public long nextValue() {
                    return table[this.upto++];
                }
            };
        }
        throw new AssertionError();
    }

    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        SortedSetEntry ss = this.sortedSets.get(field.name);
        switch (ss.format) {
            case 1: {
                return DocValues.singleton((SortedDocValues)this.getSorted(field));
            }
            case 0: {
                return this.getSortedSetWithAddresses(field);
            }
            case 2: {
                return this.getSortedSetTable(field, ss);
            }
        }
        throw new AssertionError();
    }

    private SortedSetDocValues getSortedSetWithAddresses(FieldInfo field) throws IOException {
        final long valueCount = this.binaries.get((Object)field.name).count;
        final LongBinaryDocValues binary = (LongBinaryDocValues)this.getLegacyBinary(field);
        final LongValues ordinals = this.getNumeric(this.ords.get(field.name));
        final LongValues ordIndex = this.getOrdIndexInstance(field, this.ordIndexes.get(field.name));
        return new LegacySortedSetDocValuesWrapper(new LegacySortedSetDocValues(){
            long startOffset;
            long offset;
            long endOffset;

            @Override
            public long nextOrd() {
                if (this.offset == this.endOffset) {
                    return -1L;
                }
                long ord = ordinals.get(this.offset);
                ++this.offset;
                return ord;
            }

            @Override
            public void setDocument(int docID) {
                this.startOffset = this.offset = ordIndex.get((long)docID);
                this.endOffset = ordIndex.get((long)docID + 1L);
            }

            @Override
            public BytesRef lookupOrd(long ord) {
                return binary.get(ord);
            }

            @Override
            public long getValueCount() {
                return valueCount;
            }

            @Override
            public long lookupTerm(BytesRef key) {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).lookupTerm(key);
                }
                return super.lookupTerm(key);
            }

            @Override
            public TermsEnum termsEnum() throws IOException {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).getTermsEnum();
                }
                return super.termsEnum();
            }
        }, this.maxDoc);
    }

    private SortedSetDocValues getSortedSetTable(FieldInfo field, SortedSetEntry ss) throws IOException {
        final long valueCount = this.binaries.get((Object)field.name).count;
        final LongBinaryDocValues binary = (LongBinaryDocValues)this.getLegacyBinary(field);
        NumericEntry ordinalsEntry = this.ords.get(field.name);
        final LongValues ordinals = this.getNumeric(ordinalsEntry);
        final long[] table = ss.table;
        final int[] offsets = ss.tableOffsets;
        return new LegacySortedSetDocValuesWrapper(new LegacySortedSetDocValues(){
            int offset;
            int startOffset;
            int endOffset;

            @Override
            public void setDocument(int docID) {
                int ord = (int)ordinals.get((long)docID);
                this.offset = this.startOffset = offsets[ord];
                this.endOffset = offsets[ord + 1];
            }

            @Override
            public long nextOrd() {
                if (this.offset == this.endOffset) {
                    return -1L;
                }
                return table[this.offset++];
            }

            @Override
            public BytesRef lookupOrd(long ord) {
                return binary.get(ord);
            }

            @Override
            public long getValueCount() {
                return valueCount;
            }

            @Override
            public long lookupTerm(BytesRef key) {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).lookupTerm(key);
                }
                return super.lookupTerm(key);
            }

            @Override
            public TermsEnum termsEnum() throws IOException {
                if (binary instanceof CompressedBinaryDocValues) {
                    return ((CompressedBinaryDocValues)binary).getTermsEnum();
                }
                return super.termsEnum();
            }
        }, this.maxDoc);
    }

    private Bits getLiveBits(long offset, final int count) throws IOException {
        if (offset == -2L) {
            return new Bits.MatchNoBits(count);
        }
        if (offset == -1L) {
            return new Bits.MatchAllBits(count);
        }
        int length = (int)((long)count + 7L >>> 3);
        final RandomAccessInput in = this.data.randomAccessSlice(offset, (long)length);
        return new Bits(){

            public boolean get(int index) {
                try {
                    return (in.readByte((long)(index >> 3)) & 1 << (index & 7)) != 0;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public int length() {
                return count;
            }
        };
    }

    private SparseNumericDocValues getSparseNumericDocValues(NumericEntry entry) throws IOException {
        RandomAccessInput docIdsData = this.data.randomAccessSlice(entry.missingOffset, entry.offset - entry.missingOffset);
        LegacyDirectMonotonicReader docIDs = LegacyDirectMonotonicReader.getInstance((LegacyDirectMonotonicReader.Meta)entry.monotonicMeta, (RandomAccessInput)docIdsData);
        LongValues values = this.getNumeric(entry.nonMissingValues);
        return new SparseNumericDocValues(Math.toIntExact(entry.numDocsWithValue), (LongValues)docIDs, values);
    }

    public synchronized DocValuesProducer getMergeInstance() {
        return new Lucene54DocValuesProducer(this);
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    static class BinaryEntry {
        long missingOffset;
        long offset;
        int format;
        public long count;
        int minLength;
        int maxLength;
        public long addressesOffset;
        public long addressesEndOffset;
        public LegacyDirectMonotonicReader.Meta addressesMeta;
        public long reverseIndexOffset;
        public int packedIntsVersion;
        public int blockSize;

        private BinaryEntry() {
        }
    }

    static class NumericEntry {
        long missingOffset;
        public long offset;
        public long endOffset;
        public int bitsPerValue;
        int format;
        public long count;
        public LegacyDirectMonotonicReader.Meta monotonicMeta;
        long minValue;
        long gcd;
        long[] table;
        long numDocsWithValue;
        NumericEntry nonMissingValues;
        Lucene54DocValuesConsumer.NumberType numberType;

        private NumericEntry() {
        }
    }

    static class SortedSetEntry {
        int format;
        long[] table;
        int[] tableOffsets;

        private SortedSetEntry() {
        }
    }

    static final class SparseNumericDocValues
    extends NumericDocValues {
        final int docIDsLength;
        final LongValues docIds;
        final LongValues values;
        int index;
        int doc;

        SparseNumericDocValues(int docIDsLength, LongValues docIDs, LongValues values) {
            this.docIDsLength = docIDsLength;
            this.docIds = docIDs;
            this.values = values;
            this.reset();
        }

        void reset() {
            this.index = -1;
            this.doc = -1;
        }

        public int docID() {
            return this.doc;
        }

        public int nextDoc() throws IOException {
            if (this.index >= this.docIDsLength - 1) {
                this.index = this.docIDsLength;
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = (int)this.docIds.get((long)(++this.index));
            return this.doc;
        }

        public int advance(int target) throws IOException {
            int hiDoc;
            long hiIndex;
            long loIndex = this.index;
            long step = 1L;
            while (true) {
                if ((hiIndex = (long)this.index + step) >= (long)this.docIDsLength) {
                    hiIndex = this.docIDsLength;
                    hiDoc = Integer.MAX_VALUE;
                    break;
                }
                hiDoc = (int)this.docIds.get(hiIndex);
                if (hiDoc >= target) break;
                step <<= 1;
            }
            while (loIndex + 1L < hiIndex) {
                long midIndex = loIndex + 1L + hiIndex >>> 1;
                int midDoc = (int)this.docIds.get(midIndex);
                if (midDoc >= target) {
                    hiIndex = midIndex;
                    hiDoc = midDoc;
                    continue;
                }
                loIndex = midIndex;
            }
            this.index = (int)hiIndex;
            this.doc = hiDoc;
            return this.doc;
        }

        public boolean advanceExact(int target) throws IOException {
            if (this.advance(target) == target) {
                return true;
            }
            --this.index;
            this.doc = target;
            return this.index >= 0 && this.docIds.get((long)this.index) == (long)target;
        }

        public long longValue() {
            assert (this.index >= 0);
            assert (this.index < this.docIDsLength);
            return this.values.get((long)this.index);
        }

        public long cost() {
            return this.docIDsLength;
        }
    }

    static class SparseNumericDocValuesRandomAccessWrapper
    extends LongValues {
        final SparseNumericDocValues values;
        final long missingValue;

        SparseNumericDocValuesRandomAccessWrapper(SparseNumericDocValues values, long missingValue) {
            this.values = values;
            this.missingValue = missingValue;
        }

        public long get(long longIndex) {
            int index = Math.toIntExact(longIndex);
            int doc = this.values.docID();
            if (doc >= index) {
                this.values.reset();
            }
            assert (this.values.docID() < index);
            try {
                doc = this.values.advance(index);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (doc == index) {
                return this.values.longValue();
            }
            return this.missingValue;
        }
    }

    static class ReverseTermsIndex
    implements Accountable {
        public MonotonicBlockPackedReader termAddresses;
        public PagedBytes.Reader terms;

        ReverseTermsIndex() {
        }

        public long ramBytesUsed() {
            return this.termAddresses.ramBytesUsed() + this.terms.ramBytesUsed();
        }

        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            resources.add(Accountables.namedAccountable((String)"term bytes", (Accountable)this.terms));
            resources.add(Accountables.namedAccountable((String)"term addresses", (Accountable)this.termAddresses));
            return Collections.unmodifiableList(resources);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(size=" + this.termAddresses.size() + ")";
        }
    }

    static final class CompressedBinaryDocValues
    extends LongBinaryDocValues {
        final long numValues;
        final long numIndexValues;
        final int maxTermLength;
        final MonotonicBlockPackedReader addresses;
        final IndexInput data;
        final CompressedBinaryTermsEnum termsEnum;
        final PagedBytes.Reader reverseTerms;
        final MonotonicBlockPackedReader reverseAddresses;
        final long numReverseIndexValues;

        CompressedBinaryDocValues(BinaryEntry bytes, MonotonicBlockPackedReader addresses, ReverseTermsIndex index, IndexInput data) throws IOException {
            this.maxTermLength = bytes.maxLength;
            this.numValues = bytes.count;
            this.addresses = addresses;
            this.numIndexValues = addresses.size();
            this.data = data;
            this.reverseTerms = index.terms;
            this.reverseAddresses = index.termAddresses;
            this.numReverseIndexValues = this.reverseAddresses.size();
            this.termsEnum = this.getTermsEnum(data);
        }

        @Override
        public BytesRef get(long id) {
            try {
                this.termsEnum.seekExact(id);
                return this.termsEnum.term();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        long lookupTerm(BytesRef key) {
            try {
                switch (this.termsEnum.seekCeil(key)) {
                    case FOUND: {
                        return this.termsEnum.ord();
                    }
                    case NOT_FOUND: {
                        return -this.termsEnum.ord() - 1L;
                    }
                }
                return -this.numValues - 1L;
            }
            catch (IOException bogus) {
                throw new RuntimeException(bogus);
            }
        }

        TermsEnum getTermsEnum() throws IOException {
            return this.getTermsEnum(this.data.clone());
        }

        private CompressedBinaryTermsEnum getTermsEnum(IndexInput input) throws IOException {
            return new CompressedBinaryTermsEnum(input);
        }

        class CompressedBinaryTermsEnum
        extends BaseTermsEnum {
            private long currentOrd = -1L;
            private long currentBlockStart;
            private final IndexInput input;
            private final int[] offsets = new int[16];
            private final byte[] buffer = new byte[31];
            private final BytesRef term;
            private final BytesRef firstTerm;
            private final BytesRef scratch;

            CompressedBinaryTermsEnum(IndexInput input) throws IOException {
                this.term = new BytesRef(CompressedBinaryDocValues.this.maxTermLength);
                this.firstTerm = new BytesRef(CompressedBinaryDocValues.this.maxTermLength);
                this.scratch = new BytesRef();
                this.input = input;
                input.seek(0L);
            }

            private void readHeader() throws IOException {
                this.firstTerm.length = this.input.readVInt();
                this.input.readBytes(this.firstTerm.bytes, 0, this.firstTerm.length);
                this.input.readBytes(this.buffer, 0, 15);
                if (this.buffer[0] == -1) {
                    this.readShortAddresses();
                } else {
                    this.readByteAddresses();
                }
                this.currentBlockStart = this.input.getFilePointer();
            }

            private void readByteAddresses() throws IOException {
                int addr = 0;
                for (int i = 1; i < this.offsets.length; ++i) {
                    this.offsets[i] = addr += 2 + (this.buffer[i - 1] & 0xFF);
                }
            }

            private void readShortAddresses() throws IOException {
                this.input.readBytes(this.buffer, 15, 16);
                int addr = 0;
                for (int i = 1; i < this.offsets.length; ++i) {
                    int x = i << 1;
                    this.offsets[i] = addr += 2 + (this.buffer[x - 1] << 8 | this.buffer[x] & 0xFF);
                }
            }

            private void readFirstTerm() throws IOException {
                this.term.length = this.firstTerm.length;
                System.arraycopy(this.firstTerm.bytes, this.firstTerm.offset, this.term.bytes, 0, this.term.length);
            }

            private void readTerm(int offset) throws IOException {
                int start = this.input.readByte() & 0xFF;
                System.arraycopy(this.firstTerm.bytes, this.firstTerm.offset, this.term.bytes, 0, start);
                int suffix = this.offsets[offset] - this.offsets[offset - 1] - 1;
                this.input.readBytes(this.term.bytes, start, suffix);
                this.term.length = start + suffix;
            }

            public BytesRef next() throws IOException {
                ++this.currentOrd;
                if (this.currentOrd >= CompressedBinaryDocValues.this.numValues) {
                    return null;
                }
                int offset = (int)(this.currentOrd & 0xFL);
                if (offset == 0) {
                    this.readHeader();
                    this.readFirstTerm();
                } else {
                    this.readTerm(offset);
                }
                return this.term;
            }

            long binarySearchIndex(BytesRef text) throws IOException {
                long low = 0L;
                long high = CompressedBinaryDocValues.this.numReverseIndexValues - 1L;
                while (low <= high) {
                    long mid = low + high >>> 1;
                    CompressedBinaryDocValues.this.reverseTerms.fill(this.scratch, CompressedBinaryDocValues.this.reverseAddresses.get(mid));
                    int cmp = this.scratch.compareTo(text);
                    if (cmp < 0) {
                        low = mid + 1L;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1L;
                        continue;
                    }
                    return mid;
                }
                return high;
            }

            long binarySearchBlock(BytesRef text, long low, long high) throws IOException {
                while (low <= high) {
                    long mid = low + high >>> 1;
                    this.input.seek(CompressedBinaryDocValues.this.addresses.get(mid));
                    this.term.length = this.input.readVInt();
                    this.input.readBytes(this.term.bytes, 0, this.term.length);
                    int cmp = this.term.compareTo(text);
                    if (cmp < 0) {
                        low = mid + 1L;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1L;
                        continue;
                    }
                    return mid;
                }
                return high;
            }

            public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
                long block;
                long indexPos = this.binarySearchIndex(text);
                if (indexPos < 0L) {
                    block = 0L;
                } else {
                    long low = indexPos << 6;
                    long high = Math.min(CompressedBinaryDocValues.this.numIndexValues - 1L, low + 63L);
                    block = Math.max(low, this.binarySearchBlock(text, low, high));
                }
                this.input.seek(CompressedBinaryDocValues.this.addresses.get(block));
                this.currentOrd = (block << 4) - 1L;
                while (this.next() != null) {
                    int cmp = this.term.compareTo(text);
                    if (cmp == 0) {
                        return TermsEnum.SeekStatus.FOUND;
                    }
                    if (cmp <= 0) continue;
                    return TermsEnum.SeekStatus.NOT_FOUND;
                }
                return TermsEnum.SeekStatus.END;
            }

            public void seekExact(long ord) throws IOException {
                long block = ord >>> 4;
                if (block != this.currentOrd >>> 4) {
                    this.input.seek(CompressedBinaryDocValues.this.addresses.get(block));
                    this.readHeader();
                }
                this.currentOrd = ord;
                int offset = (int)(ord & 0xFL);
                if (offset == 0) {
                    this.readFirstTerm();
                } else {
                    this.input.seek(this.currentBlockStart + (long)this.offsets[offset - 1]);
                    this.readTerm(offset);
                }
            }

            public BytesRef term() throws IOException {
                return this.term;
            }

            public long ord() throws IOException {
                return this.currentOrd;
            }

            public int docFreq() throws IOException {
                throw new UnsupportedOperationException();
            }

            public long totalTermFreq() throws IOException {
                return -1L;
            }

            public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
                throw new UnsupportedOperationException();
            }

            public ImpactsEnum impacts(int flags) throws IOException {
                throw new UnsupportedOperationException();
            }
        }
    }

    static abstract class LongBinaryDocValues
    extends LegacyBinaryDocValues {
        LongBinaryDocValues() {
        }

        @Override
        public final BytesRef get(int docID) {
            return this.get((long)docID);
        }

        abstract BytesRef get(long var1);
    }
}

