/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.elasticsearch.Version;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.xpack.lucene.bwc.OldSegmentInfos;
import org.elasticsearch.xpack.lucene.bwc.codecs.BWCCodec;

public class OldLuceneVersions
extends Plugin
implements IndexStorePlugin {
    public void onIndexModule(IndexModule indexModule) {
        if (indexModule.indexSettings().getIndexVersionCreated().before(Version.CURRENT.minimumIndexCompatibilityVersion())) {
            indexModule.addIndexEventListener(new IndexEventListener(){

                public void afterFilesRestoredFromRepository(IndexShard indexShard) {
                    OldLuceneVersions.convertToNewFormat(indexShard);
                }
            });
        }
    }

    private static void convertToNewFormat(IndexShard indexShard) {
        indexShard.store().incRef();
        try {
            OldSegmentInfos oldSegmentInfos = OldSegmentInfos.readLatestCommit(indexShard.store().directory(), 6);
            SegmentInfos segmentInfos = OldLuceneVersions.convertToNewerLuceneVersion(oldSegmentInfos);
            segmentInfos.commit(indexShard.store().directory());
            assert (SegmentInfos.readLatestCommit((Directory)indexShard.store().directory()) != null);
            Lucene.pruneUnreferencedFiles((String)segmentInfos.getSegmentsFileName(), (Directory)indexShard.store().directory());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            indexShard.store().decRef();
        }
    }

    private static SegmentInfos convertToNewerLuceneVersion(OldSegmentInfos oldSegmentInfos) {
        SegmentInfos segmentInfos = new SegmentInfos(org.apache.lucene.util.Version.LATEST.major);
        segmentInfos.version = oldSegmentInfos.version;
        segmentInfos.counter = oldSegmentInfos.counter;
        segmentInfos.setNextWriteGeneration(oldSegmentInfos.getGeneration() + 1L);
        HashMap<String, String> map = new HashMap<String, String>(oldSegmentInfos.getUserData());
        if (!map.containsKey("history_uuid")) {
            map.put("history_uuid", UUIDs.randomBase64UUID());
        }
        if (!map.containsKey("local_checkpoint")) {
            map.put("local_checkpoint", Long.toString(-1L));
        }
        if (!map.containsKey("max_seq_no")) {
            map.put("max_seq_no", Long.toString(-1L));
        }
        if (!map.containsKey("max_unsafe_auto_id_timestamp")) {
            map.put("max_unsafe_auto_id_timestamp", "-1");
        }
        segmentInfos.setUserData(map, false);
        for (SegmentCommitInfo infoPerCommit : oldSegmentInfos.asList()) {
            SegmentInfo newInfo = BWCCodec.wrap(infoPerCommit.info);
            SegmentCommitInfo commitInfo = new SegmentCommitInfo(newInfo, infoPerCommit.getDelCount(), infoPerCommit.getSoftDelCount(), infoPerCommit.getDelGen(), infoPerCommit.getFieldInfosGen(), infoPerCommit.getDocValuesGen(), infoPerCommit.getId());
            commitInfo.setDocValuesUpdatesFiles(infoPerCommit.getDocValuesUpdatesFiles());
            commitInfo.setFieldInfosFiles(infoPerCommit.getFieldInfosFiles());
            segmentInfos.add(commitInfo);
        }
        return segmentInfos;
    }

    public Map<String, IndexStorePlugin.DirectoryFactory> getDirectoryFactories() {
        return Map.of();
    }
}

