/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.query;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.Version;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.script.field.DelegateDocValuesField;
import org.elasticsearch.script.field.DocValuesField;
import org.elasticsearch.xpack.vectors.query.BinaryDenseVectorScriptDocValues;
import org.elasticsearch.xpack.vectors.query.DenseVectorScriptDocValues;
import org.elasticsearch.xpack.vectors.query.KnnDenseVectorScriptDocValues;

final class VectorDVLeafFieldData
implements LeafFieldData {
    private final LeafReader reader;
    private final String field;
    private final Version indexVersion;
    private final int dims;
    private final boolean indexed;

    VectorDVLeafFieldData(LeafReader reader, String field, Version indexVersion, int dims, boolean indexed) {
        this.reader = reader;
        this.field = field;
        this.indexVersion = indexVersion;
        this.dims = dims;
        this.indexed = indexed;
    }

    public long ramBytesUsed() {
        return 0L;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public SortedBinaryDocValues getBytesValues() {
        throw new UnsupportedOperationException("String representation of doc values for vector fields is not supported");
    }

    public DocValuesField<?> getScriptField(String name) {
        try {
            if (this.indexed) {
                VectorValues values = this.reader.getVectorValues(this.field);
                if (values == null || values == VectorValues.EMPTY) {
                    return new DelegateDocValuesField((ScriptDocValues)DenseVectorScriptDocValues.empty(new DenseVectorScriptDocValues.DenseVectorSupplier<float[]>(){

                        @Override
                        public float[] getInternal() {
                            throw new IllegalArgumentException("A document doesn't have a value for a vector field!");
                        }

                        public void setNextDocId(int docId) throws IOException {
                        }

                        public int size() {
                            return 0;
                        }
                    }, this.dims), name);
                }
                return new DelegateDocValuesField((ScriptDocValues)new KnnDenseVectorScriptDocValues(new KnnDenseVectorScriptDocValues.KnnDenseVectorSupplier(values), this.dims), name);
            }
            BinaryDocValues values = DocValues.getBinary((LeafReader)this.reader, (String)this.field);
            return new DelegateDocValuesField((ScriptDocValues)new BinaryDenseVectorScriptDocValues(new BinaryDenseVectorScriptDocValues.BinaryDenseVectorSupplier(values), this.indexVersion, this.dims), name);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values for vector field!", e);
        }
    }

    public void close() {
    }
}

