/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.query;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.VectorUtil;
import org.elasticsearch.xpack.vectors.query.DenseVectorScriptDocValues;

public class KnnDenseVectorScriptDocValues
extends DenseVectorScriptDocValues {
    private final KnnDenseVectorSupplier kdvSupplier;

    KnnDenseVectorScriptDocValues(KnnDenseVectorSupplier supplier, int dims) {
        super(supplier, dims);
        this.kdvSupplier = supplier;
    }

    private float[] getVectorChecked() {
        if (this.kdvSupplier.getInternal() == null) {
            throw new IllegalArgumentException("A document doesn't have a value for a vector field!");
        }
        return this.kdvSupplier.getInternal();
    }

    @Override
    public float[] getVectorValue() {
        float[] vector = this.getVectorChecked();
        return Arrays.copyOf(vector, vector.length);
    }

    @Override
    public float getMagnitude() {
        float[] vector = this.getVectorChecked();
        double magnitude = 0.0;
        for (float elem : vector) {
            magnitude += (double)(elem * elem);
        }
        return (float)Math.sqrt(magnitude);
    }

    @Override
    public double dotProduct(float[] queryVector) {
        return VectorUtil.dotProduct((float[])this.getVectorChecked(), (float[])queryVector);
    }

    @Override
    public double l1Norm(float[] queryVector) {
        float[] vectorValue = this.getVectorChecked();
        double result = 0.0;
        for (int i = 0; i < queryVector.length; ++i) {
            result += (double)Math.abs(vectorValue[i] - queryVector[i]);
        }
        return result;
    }

    @Override
    public double l2Norm(float[] queryVector) {
        return Math.sqrt(VectorUtil.squareDistance((float[])this.getVectorValue(), (float[])queryVector));
    }

    public int size() {
        return this.supplier.size();
    }

    public static class KnnDenseVectorSupplier
    implements DenseVectorScriptDocValues.DenseVectorSupplier<float[]> {
        private final VectorValues in;
        private float[] vector;

        public KnnDenseVectorSupplier(VectorValues in) {
            this.in = in;
        }

        public void setNextDocId(int docId) throws IOException {
            int currentDoc = this.in.docID();
            this.vector = (float[])(currentDoc == Integer.MAX_VALUE || docId < currentDoc ? null : (docId == currentDoc ? this.in.vectorValue() : (float[])((currentDoc = this.in.advance(docId)) == docId ? this.in.vectorValue() : null)));
        }

        @Override
        public BytesRef getInternal(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] getInternal() {
            return this.vector;
        }

        public int size() {
            if (this.vector == null) {
                return 0;
            }
            return 1;
        }
    }
}

