/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.query;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.ScriptDocValues;

public abstract class DenseVectorScriptDocValues
extends ScriptDocValues<BytesRef> {
    public static final String MISSING_VECTOR_FIELD_MESSAGE = "A document doesn't have a value for a vector field!";
    private final int dims;

    public DenseVectorScriptDocValues(DenseVectorSupplier<?> supplier, int dims) {
        super(supplier);
        this.dims = dims;
    }

    public int dims() {
        return this.dims;
    }

    public abstract float[] getVectorValue();

    public abstract float getMagnitude();

    public abstract double dotProduct(float[] var1);

    public abstract double l1Norm(float[] var1);

    public abstract double l2Norm(float[] var1);

    public BytesRef get(int index) {
        throw new UnsupportedOperationException("accessing a vector field's value through 'get' or 'value' is not supported!Use 'vectorValue' or 'magnitude' instead!'");
    }

    public static DenseVectorScriptDocValues empty(DenseVectorSupplier<?> supplier, int dims) {
        return new DenseVectorScriptDocValues((DenseVectorSupplier)supplier, dims){

            @Override
            public float[] getVectorValue() {
                throw new IllegalArgumentException(DenseVectorScriptDocValues.MISSING_VECTOR_FIELD_MESSAGE);
            }

            @Override
            public float getMagnitude() {
                throw new IllegalArgumentException(DenseVectorScriptDocValues.MISSING_VECTOR_FIELD_MESSAGE);
            }

            @Override
            public double dotProduct(float[] queryVector) {
                throw new IllegalArgumentException(DenseVectorScriptDocValues.MISSING_VECTOR_FIELD_MESSAGE);
            }

            @Override
            public double l1Norm(float[] queryVector) {
                throw new IllegalArgumentException(DenseVectorScriptDocValues.MISSING_VECTOR_FIELD_MESSAGE);
            }

            @Override
            public double l2Norm(float[] queryVector) {
                throw new IllegalArgumentException(DenseVectorScriptDocValues.MISSING_VECTOR_FIELD_MESSAGE);
            }

            public int size() {
                return this.supplier.size();
            }
        };
    }

    public static interface DenseVectorSupplier<T>
    extends ScriptDocValues.Supplier<BytesRef> {
        default public BytesRef getInternal(int index) {
            throw new UnsupportedOperationException();
        }

        public T getInternal();
    }
}

