/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.query;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.xpack.vectors.mapper.VectorEncoderDecoder;
import org.elasticsearch.xpack.vectors.query.DenseVectorScriptDocValues;

public class BinaryDenseVectorScriptDocValues
extends DenseVectorScriptDocValues {
    private final BinaryDenseVectorSupplier bdvSupplier;
    private final Version indexVersion;
    private final float[] vector;

    BinaryDenseVectorScriptDocValues(BinaryDenseVectorSupplier supplier, Version indexVersion, int dims) {
        super(supplier, dims);
        this.bdvSupplier = supplier;
        this.indexVersion = indexVersion;
        this.vector = new float[dims];
    }

    public int size() {
        return this.supplier.size();
    }

    @Override
    public float[] getVectorValue() {
        VectorEncoderDecoder.decodeDenseVector(this.bdvSupplier.getInternal(), this.vector);
        return this.vector;
    }

    @Override
    public float getMagnitude() {
        return VectorEncoderDecoder.getMagnitude(this.indexVersion, this.bdvSupplier.getInternal());
    }

    @Override
    public double dotProduct(float[] queryVector) {
        BytesRef value = this.bdvSupplier.getInternal();
        ByteBuffer byteBuffer = ByteBuffer.wrap(value.bytes, value.offset, value.length);
        double dotProduct = 0.0;
        for (float queryValue : queryVector) {
            dotProduct += (double)(queryValue * byteBuffer.getFloat());
        }
        return (float)dotProduct;
    }

    @Override
    public double l1Norm(float[] queryVector) {
        BytesRef value = this.bdvSupplier.getInternal();
        ByteBuffer byteBuffer = ByteBuffer.wrap(value.bytes, value.offset, value.length);
        double l1norm = 0.0;
        for (float queryValue : queryVector) {
            l1norm += (double)Math.abs(queryValue - byteBuffer.getFloat());
        }
        return l1norm;
    }

    @Override
    public double l2Norm(float[] queryVector) {
        BytesRef value = this.bdvSupplier.getInternal();
        ByteBuffer byteBuffer = ByteBuffer.wrap(value.bytes, value.offset, value.length);
        double l2norm = 0.0;
        for (float queryValue : queryVector) {
            double diff = queryValue - byteBuffer.getFloat();
            l2norm += diff * diff;
        }
        return Math.sqrt(l2norm);
    }

    public static class BinaryDenseVectorSupplier
    implements DenseVectorScriptDocValues.DenseVectorSupplier<BytesRef> {
        private final BinaryDocValues in;
        private BytesRef value;

        public BinaryDenseVectorSupplier(BinaryDocValues in) {
            this.in = in;
        }

        public void setNextDocId(int docId) throws IOException {
            this.value = this.in.advanceExact(docId) ? this.in.binaryValue() : null;
        }

        @Override
        public BytesRef getInternal(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BytesRef getInternal() {
            return this.value;
        }

        public int size() {
            if (this.value == null) {
                return 0;
            }
            return 1;
        }
    }
}

