/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;

public class NGramTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final int minGram;
    private final int maxGram;
    private final boolean preserveOriginal;
    private static final String PRESERVE_ORIG_KEY = "preserve_original";

    NGramTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        int maxAllowedNgramDiff = indexSettings.getMaxNgramDiff();
        this.minGram = settings.getAsInt("min_gram", Integer.valueOf(1));
        this.maxGram = settings.getAsInt("max_gram", Integer.valueOf(2));
        int ngramDiff = this.maxGram - this.minGram;
        if (ngramDiff > maxAllowedNgramDiff) {
            throw new IllegalArgumentException("The difference between max_gram and min_gram in NGram Tokenizer must be less than or equal to: [" + maxAllowedNgramDiff + "] but was [" + ngramDiff + "]. This limit can be set by changing the [" + IndexSettings.MAX_NGRAM_DIFF_SETTING.getKey() + "] index level setting.");
        }
        this.preserveOriginal = settings.getAsBoolean(PRESERVE_ORIG_KEY, Boolean.valueOf(false));
    }

    public TokenStream create(TokenStream tokenStream) {
        return new NGramTokenFilter(tokenStream, this.minGram, this.maxGram, this.preserveOriginal);
    }

    public TokenFilterFactory getSynonymFilter() {
        throw new IllegalArgumentException("Token filter [" + this.name() + "] cannot be used to parse synonyms");
    }
}

