/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractCharFilterFactory;

public class HtmlStripCharFilterFactory
extends AbstractCharFilterFactory {
    private final Set<String> escapedTags;

    HtmlStripCharFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name);
        List escapedTagsList = settings.getAsList("escaped_tags");
        this.escapedTags = escapedTagsList.size() > 0 ? Collections.unmodifiableSet(Sets.newHashSet((Iterable)escapedTagsList)) : null;
    }

    public Reader create(Reader tokenStream) {
        return new HTMLStripCharFilter(tokenStream, this.escapedTags);
    }
}

