/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.script.mustache.SearchTemplateRequest;
import org.elasticsearch.script.mustache.SearchTemplateResponse;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class TransportSearchTemplateAction
extends HandledTransportAction<SearchTemplateRequest, SearchTemplateResponse> {
    private static final String TEMPLATE_LANG = "mustache";
    private final ScriptService scriptService;
    private final NamedXContentRegistry xContentRegistry;
    private final NodeClient client;

    @Inject
    public TransportSearchTemplateAction(TransportService transportService, ActionFilters actionFilters, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NodeClient client) {
        super("indices:data/read/search/template", transportService, actionFilters, SearchTemplateRequest::new);
        this.scriptService = scriptService;
        this.xContentRegistry = xContentRegistry;
        this.client = client;
    }

    protected void doExecute(Task task, SearchTemplateRequest request, ActionListener<SearchTemplateResponse> listener) {
        SearchTemplateResponse response = new SearchTemplateResponse();
        try {
            SearchRequest searchRequest = TransportSearchTemplateAction.convert(request, response, this.scriptService, this.xContentRegistry);
            if (searchRequest != null) {
                this.client.search(searchRequest, listener.delegateFailure((l, searchResponse) -> {
                    try {
                        response.setResponse((SearchResponse)searchResponse);
                        l.onResponse((Object)response);
                    }
                    catch (Exception t) {
                        l.onFailure(t);
                    }
                }));
            } else {
                listener.onResponse((Object)response);
            }
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }

    static SearchRequest convert(SearchTemplateRequest searchTemplateRequest, SearchTemplateResponse response, ScriptService scriptService, NamedXContentRegistry xContentRegistry) throws IOException {
        Script script = new Script(searchTemplateRequest.getScriptType(), searchTemplateRequest.getScriptType() == ScriptType.STORED ? null : TEMPLATE_LANG, searchTemplateRequest.getScript(), searchTemplateRequest.getScriptParams() == null ? Collections.emptyMap() : searchTemplateRequest.getScriptParams());
        TemplateScript compiledScript = ((TemplateScript.Factory)scriptService.compile(script, TemplateScript.CONTEXT)).newInstance(script.getParams());
        String source = compiledScript.execute();
        response.setSource((BytesReference)new BytesArray(source));
        SearchRequest searchRequest = searchTemplateRequest.getRequest();
        if (searchTemplateRequest.isSimulate()) {
            return null;
        }
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, source);){
            SearchSourceBuilder builder = SearchSourceBuilder.searchSource();
            builder.parseXContent(parser, false);
            builder.explain(Boolean.valueOf(searchTemplateRequest.isExplain()));
            builder.profile(searchTemplateRequest.isProfile());
            TransportSearchTemplateAction.checkRestTotalHitsAsInt(searchRequest, builder);
            searchRequest.source(builder);
        }
        return searchRequest;
    }

    private static void checkRestTotalHitsAsInt(SearchRequest searchRequest, SearchSourceBuilder searchSourceBuilder) {
        Integer trackTotalHitsUpTo;
        if (searchRequest.source() == null) {
            searchRequest.source(new SearchSourceBuilder());
        }
        if ((trackTotalHitsUpTo = searchRequest.source().trackTotalHitsUpTo()) != null) {
            if (searchSourceBuilder.trackTotalHitsUpTo() == null) {
                searchSourceBuilder.trackTotalHitsUpTo(trackTotalHitsUpTo.intValue());
            } else if (searchSourceBuilder.trackTotalHitsUpTo() != Integer.MAX_VALUE && searchSourceBuilder.trackTotalHitsUpTo() != -1) {
                throw new IllegalArgumentException("[rest_total_hits_as_int] cannot be used if the tracking of total hits is not accurate, got " + searchSourceBuilder.trackTotalHitsUpTo());
            }
        }
    }
}

