/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.mustache.MultiSearchTemplateAction;
import org.elasticsearch.script.mustache.MustacheScriptEngine;
import org.elasticsearch.script.mustache.RestMultiSearchTemplateAction;
import org.elasticsearch.script.mustache.RestRenderSearchTemplateAction;
import org.elasticsearch.script.mustache.RestSearchTemplateAction;
import org.elasticsearch.script.mustache.SearchTemplateAction;
import org.elasticsearch.script.mustache.TransportMultiSearchTemplateAction;
import org.elasticsearch.script.mustache.TransportSearchTemplateAction;

public class MustachePlugin
extends Plugin
implements ScriptPlugin,
ActionPlugin,
SearchPlugin {
    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
        return new MustacheScriptEngine();
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)SearchTemplateAction.INSTANCE, TransportSearchTemplateAction.class), new ActionPlugin.ActionHandler((ActionType)MultiSearchTemplateAction.INSTANCE, TransportMultiSearchTemplateAction.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestHandler[]{new RestSearchTemplateAction(), new RestMultiSearchTemplateAction(settings), new RestRenderSearchTemplateAction()});
    }
}

