/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.matrix.stats;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.matrix.ArrayValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.matrix.stats.MatrixStatsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

final class MatrixStatsAggregatorFactory
extends ArrayValuesSourceAggregatorFactory {
    private final MultiValueMode multiValueMode;

    MatrixStatsAggregatorFactory(String name, Map<String, ValuesSourceConfig> configs, MultiValueMode multiValueMode, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, configs, context, parent, subFactoriesBuilder, metadata);
        this.multiValueMode = multiValueMode;
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new MatrixStatsAggregator(this.name, null, this.context, parent, this.multiValueMode, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(Map<String, ValuesSource> valuesSources, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        Map typedValuesSources = Maps.newMapWithExpectedSize((int)valuesSources.size());
        for (Map.Entry<String, ValuesSource> entry : valuesSources.entrySet()) {
            if (!(entry.getValue() instanceof ValuesSource.Numeric)) {
                throw new AggregationExecutionException("ValuesSource type [" + entry.getValue().toString() + "] is not supported for aggregation [" + this.name() + "]");
            }
            typedValuesSources.put(entry.getKey(), (ValuesSource.Numeric)entry.getValue());
        }
        return new MatrixStatsAggregator(this.name, typedValuesSources, this.context, parent, this.multiValueMode, metadata);
    }
}

