/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.util.json.Jackson;
import java.io.IOException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ReloadablePlugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.s3.S3ClientSettings;
import org.elasticsearch.repositories.s3.S3Repository;
import org.elasticsearch.repositories.s3.S3Service;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class S3RepositoryPlugin
extends Plugin
implements RepositoryPlugin,
ReloadablePlugin {
    private final SetOnce<S3Service> service = new SetOnce();
    private final Settings settings;

    public S3RepositoryPlugin(Settings settings) {
        this.settings = settings;
    }

    S3Service getService() {
        return (S3Service)this.service.get();
    }

    protected S3Repository createRepository(RepositoryMetadata metadata, NamedXContentRegistry registry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings) {
        return new S3Repository(metadata, registry, (S3Service)this.service.get(), clusterService, bigArrays, recoverySettings);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.service.set((Object)this.s3Service(environment));
        ((S3Service)this.service.get()).refreshAndClearCache(S3ClientSettings.load(this.settings));
        return List.of(this.service);
    }

    S3Service s3Service(Environment environment) {
        return new S3Service(environment);
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry registry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings) {
        return Collections.singletonMap("s3", metadata -> this.createRepository(metadata, registry, clusterService, bigArrays, recoverySettings));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(S3ClientSettings.ACCESS_KEY_SETTING, S3ClientSettings.SECRET_KEY_SETTING, S3ClientSettings.SESSION_TOKEN_SETTING, S3ClientSettings.ENDPOINT_SETTING, S3ClientSettings.PROTOCOL_SETTING, S3ClientSettings.PROXY_HOST_SETTING, S3ClientSettings.PROXY_PORT_SETTING, S3ClientSettings.PROXY_USERNAME_SETTING, S3ClientSettings.PROXY_PASSWORD_SETTING, S3ClientSettings.READ_TIMEOUT_SETTING, S3ClientSettings.MAX_RETRIES_SETTING, S3ClientSettings.USE_THROTTLE_RETRIES_SETTING, S3ClientSettings.USE_PATH_STYLE_ACCESS, S3ClientSettings.SIGNER_OVERRIDE, S3ClientSettings.REGION);
    }

    public void reload(Settings settings) {
        Map<String, S3ClientSettings> clientsSettings = S3ClientSettings.load(settings);
        this.getService().refreshAndClearCache(clientsSettings);
    }

    public void close() throws IOException {
        this.getService().close();
    }

    static {
        SpecialPermission.check();
        AccessController.doPrivileged(() -> {
            try {
                Jackson.jsonNodeOf((String)"{}");
                Class.forName("com.amazonaws.ClientConfiguration");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }
}

