/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure.executors;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

@SuppressForbidden(reason="It wraps a ThreadPool and delegates all the work")
public class ReactorScheduledExecutorService
extends AbstractExecutorService
implements ScheduledExecutorService {
    private final ThreadPool threadPool;
    private final String executorName;
    private final ExecutorService delegate;
    private final Logger logger = LogManager.getLogger(ReactorScheduledExecutorService.class);

    public ReactorScheduledExecutorService(ThreadPool threadPool, String executorName) {
        this.threadPool = threadPool;
        this.executorName = executorName;
        this.delegate = threadPool.executor(executorName);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        Scheduler.ScheduledCancellable schedule = this.threadPool.schedule(() -> {
            try {
                this.decorateCallable(callable).call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, new TimeValue(delay, unit), this.executorName);
        return new ReactorFuture((Scheduler.Cancellable)schedule);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        Runnable decoratedCommand = this.decorateRunnable(command);
        Scheduler.ScheduledCancellable schedule = this.threadPool.schedule(decoratedCommand, new TimeValue(delay, unit), this.executorName);
        return new ReactorFuture((Scheduler.Cancellable)schedule);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        Runnable decoratedCommand = this.decorateRunnable(command);
        return this.threadPool.scheduler().scheduleAtFixedRate(() -> {
            try {
                this.delegate.execute(decoratedCommand);
            }
            catch (EsRejectedExecutionException e) {
                if (e.isExecutorShutdown()) {
                    this.logger.debug((Message)new ParameterizedMessage("could not schedule execution of [{}] on [{}] as executor is shut down", (Object)decoratedCommand, (Object)this.executorName), (Throwable)e);
                }
                throw e;
            }
        }, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        Runnable decorateRunnable = this.decorateRunnable(command);
        Scheduler.Cancellable cancellable = this.threadPool.scheduleWithFixedDelay(decorateRunnable, new TimeValue(delay, unit), this.executorName);
        return new ReactorFuture(cancellable);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(this.decorateRunnable(command));
    }

    protected Runnable decorateRunnable(Runnable command) {
        return command;
    }

    protected <V> Callable<V> decorateCallable(Callable<V> callable) {
        return callable;
    }

    private static final class ReactorFuture<V>
    implements ScheduledFuture<V> {
        private final Scheduler.Cancellable cancellable;

        private ReactorFuture(Scheduler.Cancellable cancellable) {
            this.cancellable = cancellable;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(Delayed o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.cancellable.cancel();
        }

        @Override
        public boolean isCancelled() {
            return this.cancellable.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.cancellable.isCancelled();
        }

        @Override
        public V get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V get(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }
    }
}

