/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class CancellableRateLimitedFluxIterator<T>
implements Subscriber<T>,
Iterator<T> {
    private static final Subscription CANCELLED_SUBSCRIPTION = new Subscription(){

        public void request(long n) {
        }

        public void cancel() {
        }
    };
    private final int elementsPerBatch;
    private final Queue<T> queue;
    private final Lock lock;
    private final Condition condition;
    private final Consumer<T> cleaner;
    private final AtomicReference<Subscription> subscription = new AtomicReference();
    private final Logger logger = LogManager.getLogger(CancellableRateLimitedFluxIterator.class);
    private volatile Throwable error;
    private volatile boolean done;
    private int emittedElements;

    CancellableRateLimitedFluxIterator(int elementsPerBatch, Consumer<T> cleaner) {
        this.elementsPerBatch = elementsPerBatch;
        this.queue = new ArrayBlockingQueue<T>(elementsPerBatch);
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.cleaner = cleaner;
    }

    @Override
    public boolean hasNext() {
        block5: while (true) {
            boolean isDone = this.done;
            boolean isQueueEmpty = this.queue.isEmpty();
            if (isDone) {
                Throwable e = this.error;
                if (e != null) {
                    throw new RuntimeException(e);
                }
                if (isQueueEmpty) {
                    return false;
                }
            }
            if (!isQueueEmpty) {
                return true;
            }
            this.lock.lock();
            try {
                while (true) {
                    if (this.done || !this.queue.isEmpty()) continue block5;
                    this.condition.await();
                }
            }
            catch (InterruptedException e) {
                this.cancelSubscription();
                throw new RuntimeException(e);
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T nextElement = this.queue.poll();
        if (nextElement == null) {
            this.cancelSubscription();
            this.signalConsumer();
            throw new IllegalStateException("Queue is empty: Expected one element to be available from the Reactive Streams source.");
        }
        int totalEmittedElements = this.emittedElements + 1;
        if (totalEmittedElements == this.elementsPerBatch) {
            this.emittedElements = 0;
            this.subscription.get().request((long)totalEmittedElements);
        } else {
            this.emittedElements = totalEmittedElements;
        }
        return nextElement;
    }

    public void onSubscribe(Subscription s) {
        if (this.subscription.compareAndSet(null, s)) {
            s.request((long)this.elementsPerBatch);
        } else {
            s.cancel();
        }
    }

    public void onNext(T element) {
        if (this.done) {
            this.cleanElement(element);
            return;
        }
        if (!this.queue.offer(element)) {
            this.cancelSubscription();
            this.onError(new RuntimeException("Queue is full: Reactive Streams source doesn't respect backpressure"));
        }
        this.signalConsumer();
    }

    public void cancel() {
        this.cancelSubscription();
        this.clearQueue();
        this.done = true;
        this.signalConsumer();
    }

    public void onError(Throwable t) {
        this.clearQueue();
        this.error = t;
        this.done = true;
        this.signalConsumer();
    }

    public void onComplete() {
        this.done = true;
        this.signalConsumer();
    }

    Queue<T> getQueue() {
        return this.queue;
    }

    private void signalConsumer() {
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void clearQueue() {
        T element;
        while ((element = this.queue.poll()) != null) {
            this.cleanElement(element);
        }
    }

    private void cleanElement(T element) {
        try {
            this.cleaner.accept(element);
        }
        catch (Exception e) {
            this.logger.warn((Message)new ParameterizedMessage("Unable to clean unused element", new Object[0]), (Throwable)e);
        }
    }

    private void cancelSubscription() {
        Subscription previousSubscription = this.subscription.getAndSet(CANCELLED_SUBSCRIPTION);
        previousSubscription.cancel();
    }
}

