/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import com.azure.core.http.ProxyOptions;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.connectionstring.StorageConnectionString;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.RetryPolicyType;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.repositories.azure.AzureBlobServiceClient;
import org.elasticsearch.repositories.azure.AzureClientProvider;
import org.elasticsearch.repositories.azure.AzureStorageSettings;
import org.elasticsearch.repositories.azure.LocationMode;

public class AzureStorageService {
    public static final ByteSizeValue MIN_CHUNK_SIZE = new ByteSizeValue(1L, ByteSizeUnit.BYTES);
    public static ByteSizeValue MAX_BLOCK_SIZE = new ByteSizeValue(100L, ByteSizeUnit.MB);
    public static final long MAX_BLOCK_NUMBER = 50000L;
    private static final ByteSizeValue DEFAULT_BLOCK_SIZE = new ByteSizeValue(Math.max(ByteSizeUnit.MB.toBytes(5L), Math.min(MAX_BLOCK_SIZE.getBytes(), JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() / 20L)), ByteSizeUnit.BYTES);
    public static final long MAX_BLOB_SIZE = 50000L * DEFAULT_BLOCK_SIZE.getBytes();
    public static final ByteSizeValue MAX_CHUNK_SIZE = new ByteSizeValue(MAX_BLOB_SIZE, ByteSizeUnit.BYTES);
    private static final long DEFAULT_UPLOAD_BLOCK_SIZE = DEFAULT_BLOCK_SIZE.getBytes();
    volatile Map<String, AzureStorageSettings> storageSettings = Collections.emptyMap();
    private final AzureClientProvider azureClientProvider;
    private final ClientLogger clientLogger = new ClientLogger(AzureStorageService.class);

    public AzureStorageService(Settings settings, AzureClientProvider azureClientProvider) {
        Map<String, AzureStorageSettings> clientsSettings = AzureStorageSettings.load(settings);
        this.refreshSettings(clientsSettings);
        this.azureClientProvider = azureClientProvider;
    }

    public AzureBlobServiceClient client(String clientName, LocationMode locationMode) {
        return this.client(clientName, locationMode, null);
    }

    public AzureBlobServiceClient client(String clientName, LocationMode locationMode, BiConsumer<String, URL> successfulRequestConsumer) {
        AzureStorageSettings azureStorageSettings = this.getClientSettings(clientName);
        RequestRetryOptions retryOptions = this.getRetryOptions(locationMode, azureStorageSettings);
        ProxyOptions proxyOptions = AzureStorageService.getProxyOptions(azureStorageSettings);
        return this.azureClientProvider.createClient(azureStorageSettings, locationMode, retryOptions, proxyOptions, successfulRequestConsumer);
    }

    private AzureStorageSettings getClientSettings(String clientName) {
        AzureStorageSettings azureStorageSettings = this.storageSettings.get(clientName);
        if (azureStorageSettings == null) {
            throw new SettingsException("Unable to find client with name [" + clientName + "]");
        }
        return azureStorageSettings;
    }

    private static ProxyOptions getProxyOptions(AzureStorageSettings settings) {
        Proxy proxy = settings.getProxy();
        if (proxy == null) {
            return null;
        }
        return switch (proxy.type()) {
            case Proxy.Type.HTTP -> new ProxyOptions(ProxyOptions.Type.HTTP, (InetSocketAddress)proxy.address());
            case Proxy.Type.SOCKS -> new ProxyOptions(ProxyOptions.Type.SOCKS5, (InetSocketAddress)proxy.address());
            default -> null;
        };
    }

    long getUploadBlockSize() {
        return DEFAULT_UPLOAD_BLOCK_SIZE;
    }

    int getMaxReadRetries(String clientName) {
        AzureStorageSettings azureStorageSettings = this.getClientSettings(clientName);
        return azureStorageSettings.getMaxRetries();
    }

    RequestRetryOptions getRetryOptions(LocationMode locationMode, AzureStorageSettings azureStorageSettings) {
        String connectString = azureStorageSettings.getConnectString();
        StorageConnectionString storageConnectionString = StorageConnectionString.create((String)connectString, (ClientLogger)this.clientLogger);
        String primaryUri = storageConnectionString.getBlobEndpoint().getPrimaryUri();
        String secondaryUri = storageConnectionString.getBlobEndpoint().getSecondaryUri();
        if (locationMode == LocationMode.PRIMARY_THEN_SECONDARY && secondaryUri == null) {
            throw new IllegalArgumentException("Unable to use " + locationMode + " location mode without a secondary location URI");
        }
        String secondaryHost = switch (locationMode) {
            default -> throw new IncompatibleClassChangeError();
            case LocationMode.PRIMARY_ONLY, LocationMode.SECONDARY_ONLY -> null;
            case LocationMode.PRIMARY_THEN_SECONDARY -> secondaryUri;
            case LocationMode.SECONDARY_THEN_PRIMARY -> primaryUri;
        };
        TimeValue configuredTimeout = azureStorageSettings.getTimeout();
        int timeout = configuredTimeout.duration() == -1L ? Integer.MAX_VALUE : Math.max(1, Math.toIntExact(configuredTimeout.getSeconds()));
        return new RequestRetryOptions(RetryPolicyType.EXPONENTIAL, Integer.valueOf(azureStorageSettings.getMaxRetries()), Integer.valueOf(timeout), null, null, secondaryHost);
    }

    public void refreshSettings(Map<String, AzureStorageSettings> clientsSettings) {
        this.storageSettings = Map.copyOf(clientsSettings);
    }
}

