/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.upgrades;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SystemIndexMigrationTaskState
implements PersistentTaskState {
    private static final ParseField CURRENT_INDEX_FIELD = new ParseField("current_index", new String[0]);
    private static final ParseField CURRENT_FEATURE_FIELD = new ParseField("current_feature", new String[0]);
    static final ParseField FEATURE_METADATA_MAP_FIELD = new ParseField("feature_metadata", new String[0]);
    static final ConstructingObjectParser<SystemIndexMigrationTaskState, Void> PARSER = new ConstructingObjectParser("upgrade-system-indices", true, args -> new SystemIndexMigrationTaskState((String)args[0], (String)args[1], (Map)args[2]));
    private final String currentIndex;
    private final String currentFeature;
    private final Map<String, Object> featureCallbackMetadata;

    public SystemIndexMigrationTaskState(String currentIndex, String currentFeature, Map<String, Object> featureCallbackMetadata) {
        this.currentIndex = Objects.requireNonNull(currentIndex);
        this.currentFeature = Objects.requireNonNull(currentFeature);
        this.featureCallbackMetadata = Objects.requireNonNullElse(featureCallbackMetadata, new HashMap());
    }

    public SystemIndexMigrationTaskState(StreamInput in) throws IOException {
        this.currentIndex = in.readString();
        this.currentFeature = in.readString();
        this.featureCallbackMetadata = in.readMap();
    }

    public String getCurrentIndex() {
        return this.currentIndex;
    }

    public String getCurrentFeature() {
        return this.currentFeature;
    }

    public Map<String, Object> getFeatureCallbackMetadata() {
        return this.featureCallbackMetadata;
    }

    public static SystemIndexMigrationTaskState fromXContent(XContentParser parser) throws IOException {
        return (SystemIndexMigrationTaskState)PARSER.parse(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(CURRENT_INDEX_FIELD.getPreferredName(), this.currentIndex);
        builder.field(CURRENT_FEATURE_FIELD.getPreferredName(), this.currentFeature);
        builder.field(FEATURE_METADATA_MAP_FIELD.getPreferredName(), this.featureCallbackMetadata);
        builder.endObject();
        return null;
    }

    @Override
    public String getWriteableName() {
        return "upgrade-system-indices";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.currentIndex);
        out.writeString(this.currentFeature);
        out.writeMap(this.featureCallbackMetadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SystemIndexMigrationTaskState)) {
            return false;
        }
        SystemIndexMigrationTaskState that = (SystemIndexMigrationTaskState)o;
        return this.currentIndex.equals(that.currentIndex) && this.currentFeature.equals(that.currentFeature) && this.featureCallbackMetadata.equals(that.featureCallbackMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.currentIndex, this.currentFeature, this.featureCallbackMetadata);
    }

    public String toString() {
        return "SystemIndexMigrationTaskState{currentIndex='" + this.currentIndex + "', currentFeature='" + this.currentFeature + "', featureCallbackMetadata=" + this.featureCallbackMetadata + "}";
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), CURRENT_INDEX_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), CURRENT_FEATURE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), FEATURE_METADATA_MAP_FIELD);
    }
}

