/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.network.HandlingTimeTracker;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class TransportStats
implements Writeable,
ToXContentFragment {
    private final long serverOpen;
    private final long totalOutboundConnections;
    private final long rxCount;
    private final long rxSize;
    private final long txCount;
    private final long txSize;
    private final long[] inboundHandlingTimeBucketFrequencies;
    private final long[] outboundHandlingTimeBucketFrequencies;

    public TransportStats(long serverOpen, long totalOutboundConnections, long rxCount, long rxSize, long txCount, long txSize, long[] inboundHandlingTimeBucketFrequencies, long[] outboundHandlingTimeBucketFrequencies) {
        this.serverOpen = serverOpen;
        this.totalOutboundConnections = totalOutboundConnections;
        this.rxCount = rxCount;
        this.rxSize = rxSize;
        this.txCount = txCount;
        this.txSize = txSize;
        this.inboundHandlingTimeBucketFrequencies = inboundHandlingTimeBucketFrequencies;
        this.outboundHandlingTimeBucketFrequencies = outboundHandlingTimeBucketFrequencies;
        assert (this.assertHistogramsConsistent());
    }

    public TransportStats(StreamInput in) throws IOException {
        this.serverOpen = in.readVLong();
        this.totalOutboundConnections = in.readVLong();
        this.rxCount = in.readVLong();
        this.rxSize = in.readVLong();
        this.txCount = in.readVLong();
        this.txSize = in.readVLong();
        if (in.getVersion().onOrAfter(Version.V_8_1_0) && in.readBoolean()) {
            int i;
            this.inboundHandlingTimeBucketFrequencies = new long[HandlingTimeTracker.BUCKET_COUNT];
            for (i = 0; i < this.inboundHandlingTimeBucketFrequencies.length; ++i) {
                this.inboundHandlingTimeBucketFrequencies[i] = in.readVLong();
            }
            this.outboundHandlingTimeBucketFrequencies = new long[HandlingTimeTracker.BUCKET_COUNT];
            for (i = 0; i < this.inboundHandlingTimeBucketFrequencies.length; ++i) {
                this.outboundHandlingTimeBucketFrequencies[i] = in.readVLong();
            }
        } else {
            this.inboundHandlingTimeBucketFrequencies = new long[0];
            this.outboundHandlingTimeBucketFrequencies = new long[0];
        }
        assert (this.assertHistogramsConsistent());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.serverOpen);
        out.writeVLong(this.totalOutboundConnections);
        out.writeVLong(this.rxCount);
        out.writeVLong(this.rxSize);
        out.writeVLong(this.txCount);
        out.writeVLong(this.txSize);
        if (out.getVersion().onOrAfter(Version.V_8_1_0)) {
            assert (this.inboundHandlingTimeBucketFrequencies.length > 0 == this.outboundHandlingTimeBucketFrequencies.length > 0);
            out.writeBoolean(this.inboundHandlingTimeBucketFrequencies.length > 0);
            for (long handlingTimeBucketFrequency : this.inboundHandlingTimeBucketFrequencies) {
                out.writeVLong(handlingTimeBucketFrequency);
            }
            for (long handlingTimeBucketFrequency : this.outboundHandlingTimeBucketFrequencies) {
                out.writeVLong(handlingTimeBucketFrequency);
            }
        }
    }

    public long serverOpen() {
        return this.serverOpen;
    }

    public long getServerOpen() {
        return this.serverOpen();
    }

    public long rxCount() {
        return this.rxCount;
    }

    public long getRxCount() {
        return this.rxCount();
    }

    public ByteSizeValue rxSize() {
        return new ByteSizeValue(this.rxSize);
    }

    public ByteSizeValue getRxSize() {
        return this.rxSize();
    }

    public long txCount() {
        return this.txCount;
    }

    public long getTxCount() {
        return this.txCount();
    }

    public ByteSizeValue txSize() {
        return new ByteSizeValue(this.txSize);
    }

    public ByteSizeValue getTxSize() {
        return this.txSize();
    }

    public long[] getInboundHandlingTimeBucketFrequencies() {
        return Arrays.copyOf(this.inboundHandlingTimeBucketFrequencies, this.inboundHandlingTimeBucketFrequencies.length);
    }

    public long[] getOutboundHandlingTimeBucketFrequencies() {
        return Arrays.copyOf(this.outboundHandlingTimeBucketFrequencies, this.outboundHandlingTimeBucketFrequencies.length);
    }

    private boolean assertHistogramsConsistent() {
        assert (this.inboundHandlingTimeBucketFrequencies.length == this.outboundHandlingTimeBucketFrequencies.length);
        if (this.inboundHandlingTimeBucketFrequencies.length == 0 ? !$assertionsDisabled && Version.CURRENT.major != Version.V_8_0_0.major : !$assertionsDisabled && this.inboundHandlingTimeBucketFrequencies.length != HandlingTimeTracker.BUCKET_COUNT) {
            throw new AssertionError();
        }
        return true;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("transport");
        builder.field("server_open", this.serverOpen);
        builder.field("total_outbound_connections", this.totalOutboundConnections);
        builder.field("rx_count", this.rxCount);
        builder.humanReadableField("rx_size_in_bytes", "rx_size", (Object)new ByteSizeValue(this.rxSize));
        builder.field("tx_count", this.txCount);
        builder.humanReadableField("tx_size_in_bytes", "tx_size", (Object)new ByteSizeValue(this.txSize));
        if (this.inboundHandlingTimeBucketFrequencies.length > 0) {
            this.histogramToXContent(builder, this.inboundHandlingTimeBucketFrequencies, "inbound_handling_time_histogram");
            this.histogramToXContent(builder, this.outboundHandlingTimeBucketFrequencies, "outbound_handling_time_histogram");
        } else assert (Version.CURRENT.major == Version.V_8_0_0.major);
        builder.endObject();
        return builder;
    }

    private void histogramToXContent(XContentBuilder builder, long[] bucketFrequencies, String fieldName) throws IOException {
        int[] bucketBounds = HandlingTimeTracker.getBucketUpperBounds();
        assert (bucketFrequencies.length == bucketBounds.length + 1);
        builder.startArray(fieldName);
        for (int i = 0; i < bucketFrequencies.length; ++i) {
            builder.startObject();
            if (i > 0 && i <= bucketBounds.length) {
                builder.field("ge_millis", bucketBounds[i - 1]);
            }
            if (i < bucketBounds.length) {
                builder.field("lt_millis", bucketBounds[i]);
            }
            builder.field("count", bucketFrequencies[i]);
            builder.endObject();
        }
        builder.endArray();
    }

    static final class Fields {
        static final String TRANSPORT = "transport";
        static final String SERVER_OPEN = "server_open";
        static final String TOTAL_OUTBOUND_CONNECTIONS = "total_outbound_connections";
        static final String RX_COUNT = "rx_count";
        static final String RX_SIZE = "rx_size";
        static final String RX_SIZE_IN_BYTES = "rx_size_in_bytes";
        static final String TX_COUNT = "tx_count";
        static final String TX_SIZE = "tx_size";
        static final String TX_SIZE_IN_BYTES = "tx_size_in_bytes";
        static final String INBOUND_HANDLING_TIME_HISTOGRAM = "inbound_handling_time_histogram";
        static final String OUTBOUND_HANDLING_TIME_HISTOGRAM = "outbound_handling_time_histogram";

        Fields() {
        }
    }
}

