/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.transport.RemoteConnectionStrategy;
import org.elasticsearch.transport.SniffConnectionStrategy;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class RemoteConnectionInfo
implements ToXContentFragment,
Writeable {
    final ModeInfo modeInfo;
    final TimeValue initialConnectionTimeout;
    final String clusterAlias;
    final boolean skipUnavailable;

    public RemoteConnectionInfo(String clusterAlias, ModeInfo modeInfo, TimeValue initialConnectionTimeout, boolean skipUnavailable) {
        this.clusterAlias = clusterAlias;
        this.modeInfo = modeInfo;
        this.initialConnectionTimeout = initialConnectionTimeout;
        this.skipUnavailable = skipUnavailable;
    }

    public RemoteConnectionInfo(StreamInput input) throws IOException {
        if (input.getVersion().onOrAfter(Version.V_7_6_0)) {
            RemoteConnectionStrategy.ConnectionStrategy mode = input.readEnum(RemoteConnectionStrategy.ConnectionStrategy.class);
            this.modeInfo = mode.getReader().read(input);
            this.initialConnectionTimeout = input.readTimeValue();
            this.clusterAlias = input.readString();
            this.skipUnavailable = input.readBoolean();
        } else {
            List<String> seedNodes = Arrays.asList(input.readStringArray());
            int connectionsPerCluster = input.readVInt();
            this.initialConnectionTimeout = input.readTimeValue();
            int numNodesConnected = input.readVInt();
            this.clusterAlias = input.readString();
            this.skipUnavailable = input.readBoolean();
            this.modeInfo = new SniffConnectionStrategy.SniffModeInfo(seedNodes, connectionsPerCluster, numNodesConnected);
        }
    }

    public boolean isConnected() {
        return this.modeInfo.isConnected();
    }

    public String getClusterAlias() {
        return this.clusterAlias;
    }

    public ModeInfo getModeInfo() {
        return this.modeInfo;
    }

    public TimeValue getInitialConnectionTimeout() {
        return this.initialConnectionTimeout;
    }

    public boolean isSkipUnavailable() {
        return this.skipUnavailable;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_7_6_0)) {
            out.writeEnum(this.modeInfo.modeType());
            this.modeInfo.writeTo(out);
            out.writeTimeValue(this.initialConnectionTimeout);
        } else if (this.modeInfo.modeType() == RemoteConnectionStrategy.ConnectionStrategy.SNIFF) {
            SniffConnectionStrategy.SniffModeInfo sniffInfo = (SniffConnectionStrategy.SniffModeInfo)this.modeInfo;
            out.writeStringArray(sniffInfo.seedNodes.toArray(new String[0]));
            out.writeVInt(sniffInfo.maxConnectionsPerCluster);
            out.writeTimeValue(this.initialConnectionTimeout);
            out.writeVInt(sniffInfo.numNodesConnected);
        } else {
            out.writeStringArray(new String[0]);
            out.writeVInt(0);
            out.writeTimeValue(this.initialConnectionTimeout);
            out.writeVInt(0);
        }
        out.writeString(this.clusterAlias);
        out.writeBoolean(this.skipUnavailable);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.clusterAlias);
        builder.field("connected", this.modeInfo.isConnected());
        builder.field("mode", this.modeInfo.modeName());
        this.modeInfo.toXContent(builder, params);
        builder.field("initial_connect_timeout", (Object)this.initialConnectionTimeout);
        builder.field("skip_unavailable", this.skipUnavailable);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteConnectionInfo that = (RemoteConnectionInfo)o;
        return this.skipUnavailable == that.skipUnavailable && Objects.equals(this.modeInfo, that.modeInfo) && Objects.equals(this.initialConnectionTimeout, that.initialConnectionTimeout) && Objects.equals(this.clusterAlias, that.clusterAlias);
    }

    public int hashCode() {
        return Objects.hash(this.modeInfo, this.initialConnectionTimeout, this.clusterAlias, this.skipUnavailable);
    }

    public static interface ModeInfo
    extends ToXContentFragment,
    Writeable {
        public boolean isConnected();

        public String modeName();

        public RemoteConnectionStrategy.ConnectionStrategy modeType();
    }
}

