/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.support.AbstractClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.transport.RemoteClusterAwareRequest;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

final class RemoteClusterAwareClient
extends AbstractClient {
    private final TransportService service;
    private final String clusterAlias;
    private final RemoteClusterService remoteClusterService;
    private final boolean ensureConnected;

    RemoteClusterAwareClient(Settings settings, ThreadPool threadPool, TransportService service, String clusterAlias, boolean ensureConnected) {
        super(settings, threadPool);
        this.service = service;
        this.clusterAlias = clusterAlias;
        this.remoteClusterService = service.getRemoteClusterService();
        this.ensureConnected = ensureConnected;
    }

    @Override
    protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.maybeEnsureConnected(ActionListener.wrap(v -> {
            Transport.Connection connection;
            try {
                if (request instanceof RemoteClusterAwareRequest) {
                    DiscoveryNode preferredTargetNode = ((RemoteClusterAwareRequest)((Object)request)).getPreferredTargetNode();
                    connection = this.remoteClusterService.getConnection(preferredTargetNode, this.clusterAlias);
                } else {
                    connection = this.remoteClusterService.getConnection(this.clusterAlias);
                }
            }
            catch (NoSuchRemoteClusterException e) {
                if (!this.ensureConnected) {
                    this.remoteClusterService.ensureConnected(this.clusterAlias, ActionListener.wrap(() -> {}));
                }
                throw e;
            }
            this.service.sendRequest(connection, action.name(), (TransportRequest)request, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler(listener, action.getResponseReader()));
        }, listener::onFailure));
    }

    private void maybeEnsureConnected(ActionListener<Void> ensureConnectedListener) {
        if (this.ensureConnected) {
            this.remoteClusterService.ensureConnected(this.clusterAlias, ensureConnectedListener);
        } else {
            ensureConnectedListener.onResponse(null);
        }
    }

    public void close() {
    }

    @Override
    public Client getRemoteClusterClient(String remoteClusterAlias) {
        return this.remoteClusterService.getRemoteClusterClient(this.threadPool(), remoteClusterAlias);
    }
}

