/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.timeseries.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.timeseries.support.TimeSeriesMetrics;

public class TimeSeriesMetricsService {
    private final Client client;
    private final int bucketBatchSize;
    private final int docBatchSize;
    private final TimeValue staleness;

    public TimeSeriesMetricsService(Client client, int bucketBatchSize, int docBatchSize, TimeValue staleness) {
        this.client = client;
        this.bucketBatchSize = bucketBatchSize;
        this.docBatchSize = docBatchSize;
        this.staleness = staleness;
    }

    public void newMetrics(String[] indices, IndicesOptions indicesOptions, ActionListener<TimeSeriesMetrics> listener) {
        FieldCapabilitiesRequest request = new FieldCapabilitiesRequest();
        request.indices(indices);
        request.fields("*");
        request.indicesOptions(indicesOptions);
        this.client.fieldCaps(request, listener.map(this::newMetrics));
    }

    private TimeSeriesMetrics newMetrics(FieldCapabilitiesResponse response) {
        if (!response.getFailures().isEmpty()) {
            ElasticsearchException e = new ElasticsearchException("Failed to fetch field caps for " + Arrays.toString(response.getFailedIndices()), new Object[0]);
            for (FieldCapabilitiesFailure f : response.getFailures()) {
                e.addSuppressed(new ElasticsearchException("Failed to fetch field caps for " + Arrays.toString(f.getIndices()), (Throwable)f.getException(), new Object[0]));
            }
            throw e;
        }
        ArrayList<String> dimensionFieldNames = new ArrayList<String>();
        TreeMap<String, TimeSeriesParams.MetricType> metricFieldNames = new TreeMap<String, TimeSeriesParams.MetricType>();
        for (Map.Entry<String, Map<String, FieldCapabilities>> e : response.get().entrySet()) {
            for (Map.Entry<String, FieldCapabilities> e2 : e.getValue().entrySet()) {
                this.collectField(dimensionFieldNames, metricFieldNames, e.getKey(), e2.getKey(), e2.getValue());
            }
        }
        return new TimeSeriesMetrics(this.bucketBatchSize, this.docBatchSize, this.staleness, this.client, response.getIndices(), dimensionFieldNames, metricFieldNames);
    }

    private void collectField(List<String> dimensions, Map<String, TimeSeriesParams.MetricType> metrics, String fieldName, String fieldType, FieldCapabilities capabilities) {
        if (capabilities.isDimension()) {
            dimensions.add(fieldName);
        } else if (capabilities.getMetricType() != null) {
            metrics.put(fieldName, capabilities.getMetricType());
        }
    }
}

