/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.timeseries.support;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.RegexpQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.InternalComposite;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilter;
import org.elasticsearch.search.aggregations.metrics.InternalTopHits;
import org.elasticsearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class TimeSeriesMetrics {
    private static final Logger logger = LogManager.getLogger();
    private final int bucketBatchSize;
    private final int docBatchSize;
    private final TimeValue staleness;
    private final Client client;
    private final String[] indices;
    private final List<String> dimensionFieldNames;
    private final Map<String, TimeSeriesParams.MetricType> metricFieldNames;

    TimeSeriesMetrics(int bucketBatchSize, int docBatchSize, TimeValue staleness, Client client, String[] indices, List<String> dimensionFieldNames, Map<String, TimeSeriesParams.MetricType> metricFieldNames) {
        this.bucketBatchSize = bucketBatchSize;
        this.docBatchSize = docBatchSize;
        this.staleness = staleness;
        this.client = client;
        this.indices = indices;
        this.dimensionFieldNames = dimensionFieldNames;
        this.metricFieldNames = metricFieldNames;
    }

    public void latest(List<TimeSeriesMetricSelector> metrics, List<TimeSeriesDimensionSelector> dimensions, long time, MetricsCallback callback) {
        this.retrieve(metrics, dimensions, time, null, null, callback);
    }

    public void range(List<TimeSeriesMetricSelector> metrics, List<TimeSeriesDimensionSelector> dimensions, long time, TimeValue range, MetricsCallback callback) {
        this.retrieve(metrics, dimensions, time, range, null, callback);
    }

    public void range(List<TimeSeriesMetricSelector> metrics, List<TimeSeriesDimensionSelector> dimensions, long time, TimeValue range, TimeValue step, MetricsCallback callback) {
        this.retrieve(metrics, dimensions, time, range, step, callback);
    }

    private void retrieve(List<TimeSeriesMetricSelector> metrics, List<TimeSeriesDimensionSelector> dimensions, long time, @Nullable TimeValue range, @Nullable TimeValue step, MetricsCallback callback) {
        int size;
        long from;
        List<String> resolvedMetrics = this.resolveMetrics(metrics);
        if (range != null) {
            if (step != null) {
                from = time - range.getMillis() - this.staleness.getMillis();
                size = 0;
            } else {
                from = time - range.getMillis();
                size = this.docBatchSize;
            }
        } else {
            if (step != null) {
                throw new IllegalArgumentException("Cannot specify non-null step if range is null");
            }
            from = time - this.staleness.getMillis();
            size = 0;
        }
        SearchRequest search = this.searchInRange(resolvedMetrics, dimensions, from, time, size);
        if (size > 0) {
            this.client.search(search, ActionListener.wrap(new SearchResponseHandler(resolvedMetrics, callback, search), callback::onError));
        } else {
            CompositeAggregationBuilder timeSeries = this.timeSeriesComposite();
            for (String metric : resolvedMetrics) {
                timeSeries.subAggregation(this.latestMetric(metric, time, range, step));
            }
            search.source().aggregation(timeSeries);
            logger.debug("Requesting batch of latest {}", (Object)search);
            this.client.search(search, ActionListener.wrap(new AggsResponseHandler(resolvedMetrics, callback, search, timeSeries), callback::onError));
        }
    }

    private List<String> resolveMetrics(List<TimeSeriesMetricSelector> selectors) {
        Stream<Object> metrics = this.metricFieldNames.keySet().stream();
        for (TimeSeriesMetricSelector selector : selectors) {
            metrics = metrics.filter(selector.asPredicate());
        }
        return metrics.collect(Collectors.toUnmodifiableList());
    }

    private SearchRequest searchInRange(List<String> metrics, List<TimeSeriesDimensionSelector> dimensions, long from, long to, int size) {
        SearchRequest search = new SearchRequest(this.indices);
        BoolQueryBuilder builder = new BoolQueryBuilder();
        builder.must(new RangeQueryBuilder("@timestamp").format(DateFieldMapper.DEFAULT_DATE_TIME_NANOS_FORMATTER.pattern()).gt(from).lte(to));
        for (String metric : metrics) {
            builder.should(new ExistsQueryBuilder(metric));
        }
        for (TimeSeriesDimensionSelector dimension : dimensions) {
            builder.must(dimension.asQuery());
        }
        search.source().query(builder);
        if (size > 0) {
            List<SortBuilder<?>> sorts = Stream.concat(this.dimensionFieldNames.stream().map(d -> (FieldSortBuilder)new FieldSortBuilder((String)d).order(SortOrder.ASC)), Stream.of(((FieldSortBuilder)new FieldSortBuilder("@timestamp").order(SortOrder.ASC)).setFormat("epoch_millis"))).collect(Collectors.toList());
            search.source().sort(sorts);
            for (String metric : metrics) {
                search.source().fetchField(metric);
            }
        }
        search.source().size(size);
        search.source().trackTotalHits(false);
        return search;
    }

    private CompositeAggregationBuilder timeSeriesComposite(@Nullable Map<String, Object> afterKey) {
        Stream<CompositeValuesSourceBuilder> sources = this.dimensionFieldNames.stream().map(d -> ((TermsValuesSourceBuilder)new TermsValuesSourceBuilder((String)d).field((String)d)).missingBucket(true));
        return new CompositeAggregationBuilder("time_series", sources.collect(Collectors.toList())).aggregateAfter(afterKey).size(this.bucketBatchSize);
    }

    private CompositeAggregationBuilder timeSeriesComposite() {
        Stream<CompositeValuesSourceBuilder> sources = this.dimensionFieldNames.stream().map(d -> ((TermsValuesSourceBuilder)new TermsValuesSourceBuilder((String)d).field((String)d)).missingBucket(true));
        return new CompositeAggregationBuilder("time_series", sources.collect(Collectors.toList())).size(this.bucketBatchSize);
    }

    private AggregationBuilder latestMetric(String metric, long time, TimeValue range, TimeValue step) {
        if (step == null) {
            String aggKey = range == null ? Long.toString(time) : "use_timestamp";
            return new FilterAggregationBuilder(metric, new ExistsQueryBuilder(metric)).subAggregation(new FilterAggregationBuilder(aggKey, new MatchAllQueryBuilder()).subAggregation(new TopHitsAggregationBuilder("results").sort((SortBuilder<?>)new FieldSortBuilder("@timestamp").order(range == null ? SortOrder.DESC : SortOrder.ASC)).fetchField(metric).fetchField(new FieldAndFormat("@timestamp", "epoch_millis")).size(range == null ? 1 : IndexSettings.MAX_INNER_RESULT_WINDOW_SETTING.getDefault(Settings.EMPTY))));
        }
        FilterAggregationBuilder metricAgg = new FilterAggregationBuilder(metric, new ExistsQueryBuilder(metric));
        long stepMillis = step.getMillis();
        long from = time - range.getMillis();
        long first = from / stepMillis;
        long last = time / stepMillis;
        for (int i = 0; i < (int)(last - first); ++i) {
            metricAgg.subAggregation(new FilterAggregationBuilder(Long.toString((first + (long)i + 1L) * stepMillis), new BoolQueryBuilder().filter(new RangeQueryBuilder("@timestamp").format(DateFieldMapper.DEFAULT_DATE_TIME_NANOS_FORMATTER.pattern()).gt((first + (long)i + 1L) * stepMillis - this.staleness.getMillis()).lte((first + (long)i + 1L) * stepMillis)).filter(new ExistsQueryBuilder(metric))).subAggregation(new TopHitsAggregationBuilder("results").sort((SortBuilder<?>)new FieldSortBuilder("@timestamp").order(SortOrder.DESC)).fetchField(metric).fetchField(new FieldAndFormat("@timestamp", "epoch_millis")).size(1)));
        }
        return metricAgg;
    }

    static interface MetricsCallback {
        public void onTimeSeriesStart(String var1, Map<String, Object> var2);

        public void onMetric(long var1, double var3);

        public void onSuccess();

        public void onError(Exception var1);
    }

    private class SearchResponseHandler
    implements CheckedConsumer<SearchResponse, RuntimeException> {
        private final List<String> resolvedMetrics;
        Map<String, Object> previousDimensions;
        private final MetricsCallback callback;
        private final SearchRequest search;

        SearchResponseHandler(List<String> resolvedMetrics, MetricsCallback callback, SearchRequest search) {
            this.resolvedMetrics = resolvedMetrics;
            this.previousDimensions = null;
            this.callback = callback;
            this.search = search;
        }

        public void accept(SearchResponse response) {
            SearchHit[] hits = response.getHits().getHits();
            for (String metric : this.resolvedMetrics) {
                for (SearchHit hit : hits) {
                    HashMap<String, Object> dimensions = new HashMap<String, Object>();
                    for (int d = 0; d < TimeSeriesMetrics.this.dimensionFieldNames.size(); ++d) {
                        Object dimensionValue = hit.getSortValues()[d];
                        if (dimensionValue == null) continue;
                        dimensions.put(TimeSeriesMetrics.this.dimensionFieldNames.get(d), dimensionValue);
                    }
                    DocumentField metricField = hit.field(metric);
                    if (metricField == null) continue;
                    if (!Objects.equals(this.previousDimensions, dimensions)) {
                        this.previousDimensions = dimensions;
                        this.callback.onTimeSeriesStart(metric, dimensions);
                    }
                    long time = Long.parseLong((String)hit.getSortValues()[TimeSeriesMetrics.this.dimensionFieldNames.size()]);
                    double value = ((Number)metricField.getValue()).doubleValue();
                    this.callback.onMetric(time, value);
                }
            }
            if (hits.length < TimeSeriesMetrics.this.docBatchSize) {
                this.callback.onSuccess();
            } else {
                this.search.source().searchAfter(hits[hits.length - 1].getSortValues());
                TimeSeriesMetrics.this.client.search(this.search, ActionListener.wrap(this, this.callback::onError));
            }
        }
    }

    private class AggsResponseHandler
    implements CheckedConsumer<SearchResponse, RuntimeException> {
        private final List<String> resolvedMetrics;
        Map<String, Object> previousDimensions;
        private final MetricsCallback callback;
        private final SearchRequest search;
        private final CompositeAggregationBuilder timeSeries;

        AggsResponseHandler(List<String> resolvedMetrics, MetricsCallback callback, SearchRequest search, CompositeAggregationBuilder timeSeries) {
            this.resolvedMetrics = resolvedMetrics;
            this.previousDimensions = null;
            this.callback = callback;
            this.search = search;
            this.timeSeries = timeSeries;
        }

        public void accept(SearchResponse response) {
            InternalComposite composite = (InternalComposite)response.getAggregations().get("time_series");
            for (String metric : this.resolvedMetrics) {
                this.previousDimensions = null;
                for (InternalComposite.InternalBucket bucket : composite.getBuckets()) {
                    Map<String, Object> dimensions = bucket.getKey().entrySet().stream().filter(e -> false == ((String)e.getKey()).equals("@timestamp") && e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    if (!Objects.equals(this.previousDimensions, dimensions)) {
                        this.previousDimensions = dimensions;
                        this.callback.onTimeSeriesStart(metric, dimensions);
                    }
                    InternalFilter filter = (InternalFilter)bucket.getAggregations().get(metric);
                    ArrayList<Aggregation> aggs = new ArrayList<Aggregation>(filter.getAggregations().asList());
                    aggs.sort(Comparator.comparingLong(o -> Long.parseLong(o.getName())));
                    for (Aggregation agg : aggs) {
                        InternalFilter timeFilter = (InternalFilter)agg;
                        Long time = "use_timestamp".equals(timeFilter.getName()) ? null : Long.valueOf(Long.parseLong(timeFilter.getName()));
                        InternalTopHits latest = (InternalTopHits)timeFilter.getAggregations().get("results");
                        for (SearchHit hit : latest.getHits().getHits()) {
                            DocumentField metricField = hit.field(metric);
                            if (metricField == null) {
                                throw new IllegalStateException("Cannot retrieve metric field [" + metric + "][" + bucket + "] from [" + response + "]");
                            }
                            long effectiveTime = time == null ? Long.parseLong((String)hit.field("@timestamp").getValue()) : time;
                            double value = ((Number)metricField.getValue()).doubleValue();
                            this.callback.onMetric(effectiveTime, value);
                        }
                    }
                }
            }
            if (composite.afterKey() == null) {
                this.callback.onSuccess();
            } else {
                this.timeSeries.aggregateAfter(composite.afterKey());
                TimeSeriesMetrics.this.client.search(this.search, ActionListener.wrap(this, this.callback::onError));
            }
        }
    }

    public static class TimeSeriesMetricSelector {
        private final TimeSeriesSelectorMatcher matcher;
        private final String value;

        public TimeSeriesMetricSelector(TimeSeriesSelectorMatcher matcher, String value) {
            this.matcher = matcher;
            this.value = value;
        }

        public Predicate<String> asPredicate() {
            return this.matcher.matcher(this.value);
        }
    }

    public static class TimeSeriesDimensionSelector {
        private final TimeSeriesSelectorMatcher matcher;
        private final String name;
        private final String value;

        public TimeSeriesDimensionSelector(String name, TimeSeriesSelectorMatcher matcher, String value) {
            this.name = name;
            this.matcher = matcher;
            this.value = value;
        }

        public QueryBuilder asQuery() {
            return this.matcher.asQuery(this.name, this.value);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TimeSeriesSelectorMatcher {
        EQUAL{

            @Override
            protected Predicate<String> matcher(String expression) {
                return expression::equals;
            }

            @Override
            protected QueryBuilder asQuery(String name, String value) {
                return new TermQueryBuilder(name, value);
            }
        }
        ,
        NOT_EQUAL{

            @Override
            protected Predicate<String> matcher(String expression) {
                return Predicate.not(expression::equals);
            }

            @Override
            protected QueryBuilder asQuery(String name, String value) {
                return new BoolQueryBuilder().mustNot(EQUAL.asQuery(name, value));
            }
        }
        ,
        RE_EQUAL{

            @Override
            protected Predicate<String> matcher(String expression) {
                return Pattern.compile(expression).asMatchPredicate();
            }

            @Override
            protected QueryBuilder asQuery(String name, String value) {
                return new RegexpQueryBuilder(name, value);
            }
        }
        ,
        RE_NOT_EQUAL{

            @Override
            protected Predicate<String> matcher(String expression) {
                return Predicate.not(RE_EQUAL.matcher(expression));
            }

            @Override
            protected QueryBuilder asQuery(String name, String value) {
                return new BoolQueryBuilder().mustNot(RE_EQUAL.asQuery(name, value));
            }
        };


        protected abstract Predicate<String> matcher(String var1);

        protected abstract QueryBuilder asQuery(String var1, String var2);
    }
}

