/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.timeseries;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollector;

public class TimeSeriesIndexSearcher {
    private final IndexSearcher searcher;

    public TimeSeriesIndexSearcher(IndexSearcher searcher) {
        this.searcher = searcher;
    }

    public void search(Query query, BucketCollector bucketCollector) throws IOException {
        query = this.searcher.rewrite(query);
        Weight weight = this.searcher.createWeight(query, bucketCollector.scoreMode(), 1.0f);
        PriorityQueue<LeafWalker> queue = new PriorityQueue<LeafWalker>(this.searcher.getIndexReader().leaves().size()){

            protected boolean lessThan(LeafWalker a, LeafWalker b) {
                int res = a.tsid.compareTo(b.tsid);
                if (res == 0) {
                    return a.timestamp < b.timestamp;
                }
                return res < 0;
            }
        };
        for (LeafReaderContext leaf : this.searcher.getIndexReader().leaves()) {
            LeafWalker walker;
            LeafBucketCollector leafCollector = bucketCollector.getLeafCollector(leaf);
            Scorer scorer = weight.scorer(leaf);
            if (scorer == null || !(walker = new LeafWalker(leaf, scorer, leafCollector)).next()) continue;
            queue.add((Object)walker);
        }
        while (queue.top() != null) {
            LeafWalker walker = (LeafWalker)queue.top();
            walker.collectCurrent();
            if (walker.next()) {
                queue.updateTop();
                continue;
            }
            queue.pop();
        }
    }

    private static class LeafWalker {
        private final LeafCollector collector;
        private final Bits liveDocs;
        private final DocIdSetIterator iterator;
        private final SortedDocValues tsids;
        private final SortedNumericDocValues timestamps;
        final int docBase;
        int docId;
        BytesRef tsid;
        long timestamp;

        LeafWalker(LeafReaderContext context, Scorer scorer, LeafCollector collector) throws IOException {
            this.collector = collector;
            this.liveDocs = context.reader().getLiveDocs();
            this.collector.setScorer((Scorable)scorer);
            this.iterator = scorer.iterator();
            this.docBase = context.docBase;
            this.tsids = DocValues.getSorted((LeafReader)context.reader(), (String)"_tsid");
            this.timestamps = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)"@timestamp");
        }

        void collectCurrent() throws IOException {
            this.collector.collect(this.docId);
        }

        boolean next() throws IOException {
            do {
                this.docId = this.iterator.nextDoc();
                if (this.docId == Integer.MAX_VALUE || this.liveDocs != null && !this.liveDocs.get(this.docId) || !this.tsids.advanceExact(this.docId)) continue;
                BytesRef tsid = this.tsids.lookupOrd(this.tsids.ordValue());
                if (!this.timestamps.advanceExact(this.docId)) continue;
                this.timestamp = this.timestamps.nextValue();
                if (!tsid.equals((Object)this.tsid)) {
                    this.tsid = BytesRef.deepCopyOf((BytesRef)tsid);
                }
                return true;
            } while (this.docId != Integer.MAX_VALUE);
            return false;
        }
    }
}

