/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.timeseries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.plain.SortedSetBytesLeafFieldData;
import org.elasticsearch.index.mapper.TimeSeriesIdFieldMapper;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.BytesKeyedBucketOrds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.timeseries.InternalTimeSeries;

public class TimeSeriesAggregator
extends BucketsAggregator {
    private final IndexFieldData<SortedSetBytesLeafFieldData> tsidFieldData;
    protected final BytesKeyedBucketOrds bucketOrds;
    private final boolean keyed;

    public TimeSeriesAggregator(String name, AggregatorFactories factories, boolean keyed, AggregationContext context, Aggregator parent, CardinalityUpperBound bucketCardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, bucketCardinality, metadata);
        this.keyed = keyed;
        this.tsidFieldData = Objects.requireNonNull(context.buildFieldContext("_tsid"), "Cannot obtain tsid field").indexFieldData();
        this.bucketOrds = BytesKeyedBucketOrds.build(this.bigArrays(), bucketCardinality);
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        InternalTimeSeries.InternalBucket[][] allBucketsPerOrd = new InternalTimeSeries.InternalBucket[owningBucketOrds.length][];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            BytesRef spareKey = new BytesRef();
            BytesKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrds[ordIdx]);
            ArrayList<InternalTimeSeries.InternalBucket> buckets = new ArrayList<InternalTimeSeries.InternalBucket>();
            while (ordsEnum.next()) {
                long docCount = this.bucketDocCount(ordsEnum.ord());
                ordsEnum.readValue(spareKey);
                InternalTimeSeries.InternalBucket bucket = new InternalTimeSeries.InternalBucket(TimeSeriesIdFieldMapper.decodeTsid(spareKey), docCount, null, this.keyed);
                bucket.bucketOrd = ordsEnum.ord();
                buckets.add(bucket);
            }
            allBucketsPerOrd[ordIdx] = buckets.toArray(new InternalTimeSeries.InternalBucket[0]);
        }
        this.buildSubAggsForAllBuckets(allBucketsPerOrd, b -> b.bucketOrd, (b, a) -> {
            b.aggregations = a;
        });
        InternalAggregation[] result = new InternalAggregation[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            result[ordIdx] = this.buildResult(allBucketsPerOrd[ordIdx]);
        }
        return result;
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalTimeSeries(this.name, new ArrayList<InternalTimeSeries.InternalBucket>(), false, this.metadata());
    }

    @Override
    protected void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext context, final LeafBucketCollector sub) throws IOException {
        final SortedBinaryDocValues tsids = this.tsidFieldData.load(context).getBytesValues();
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (tsids.advanceExact(doc)) {
                    BytesRef newTsid = tsids.nextValue();
                    long bucketOrdinal = TimeSeriesAggregator.this.bucketOrds.add(bucket, newTsid);
                    if (bucketOrdinal < 0L) {
                        bucketOrdinal = -1L - bucketOrdinal;
                        TimeSeriesAggregator.this.collectExistingBucket(sub, doc, bucketOrdinal);
                    } else {
                        TimeSeriesAggregator.this.collectBucket(sub, doc, bucketOrdinal);
                    }
                }
            }
        };
    }

    InternalTimeSeries buildResult(InternalTimeSeries.InternalBucket[] topBuckets) {
        return new InternalTimeSeries(this.name, List.of(topBuckets), this.keyed, this.metadata());
    }
}

