/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.timeseries;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.timeseries.TimeSeriesAggregationFactory;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.InstantiatingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ParserConstructor;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class TimeSeriesAggregationBuilder
extends AbstractAggregationBuilder<TimeSeriesAggregationBuilder> {
    public static final String NAME = "time_series";
    public static final ParseField KEYED_FIELD = new ParseField("keyed", new String[0]);
    public static final InstantiatingObjectParser<TimeSeriesAggregationBuilder, String> PARSER;
    private boolean keyed;

    public TimeSeriesAggregationBuilder(String name) {
        this(name, true);
    }

    @ParserConstructor
    public TimeSeriesAggregationBuilder(String name, Boolean keyed) {
        super(name);
        this.keyed = keyed != null ? keyed : true;
    }

    protected TimeSeriesAggregationBuilder(TimeSeriesAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.keyed = clone.keyed;
    }

    public TimeSeriesAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.keyed = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.keyed);
    }

    @Override
    protected AggregatorFactory doBuild(AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new TimeSeriesAggregationFactory(this.name, this.keyed, context, parent, subFactoriesBuilder, this.metadata);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(KEYED_FIELD.getPreferredName(), this.keyed);
        builder.endObject();
        return builder;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new TimeSeriesAggregationBuilder(this, factoriesBuilder, metadata);
    }

    @Override
    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    public boolean isInSortOrderExecutionRequired() {
        return true;
    }

    public boolean isKeyed() {
        return this.keyed;
    }

    public void setKeyed(boolean keyed) {
        this.keyed = keyed;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeSeriesAggregationBuilder that = (TimeSeriesAggregationBuilder)o;
        return this.keyed == that.keyed;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keyed);
    }

    static {
        InstantiatingObjectParser.Builder parser = InstantiatingObjectParser.builder((String)NAME, (boolean)false, TimeSeriesAggregationBuilder.class);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), KEYED_FIELD);
        PARSER = parser.build();
    }
}

