/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.timeseries;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.search.aggregations.ParsedMultiBucketAggregation;
import org.elasticsearch.search.aggregations.timeseries.TimeSeries;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.XContentParser;

public class ParsedTimeSeries
extends ParsedMultiBucketAggregation<ParsedBucket>
implements TimeSeries {
    private transient Map<String, ParsedBucket> bucketMap;
    private static final ObjectParser<ParsedTimeSeries, Void> PARSER = new ObjectParser(ParsedTimeSeries.class.getSimpleName(), true, ParsedTimeSeries::new);

    @Override
    public String getType() {
        return "time_series";
    }

    @Override
    public List<? extends TimeSeries.Bucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public TimeSeries.Bucket getBucketByKey(String key) {
        if (this.bucketMap == null) {
            this.bucketMap = new HashMap<String, ParsedBucket>(this.buckets.size());
            for (ParsedBucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKeyAsString(), bucket);
            }
        }
        return this.bucketMap.get(key);
    }

    public static ParsedTimeSeries fromXContent(XContentParser parser, String name) throws IOException {
        ParsedTimeSeries aggregation = (ParsedTimeSeries)PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedTimeSeries.declareMultiBucketAggregationFields(PARSER, parser -> ParsedBucket.fromXContent(parser, false), parser -> ParsedBucket.fromXContent(parser, true));
    }

    static class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements TimeSeries.Bucket {
        private Map<String, Object> key;

        ParsedBucket() {
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            return this.key.toString();
        }

        static ParsedBucket fromXContent(XContentParser parser, boolean keyed) throws IOException {
            return ParsedBucket.parseXContent(parser, keyed, ParsedBucket::new, (p, bucket) -> {
                bucket.key = new TreeMap<String, Object>(p.map());
            });
        }
    }
}

