/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.timeseries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.ParsedMultiBucketAggregation;
import org.elasticsearch.search.aggregations.timeseries.ParsedTimeSeries;
import org.elasticsearch.search.aggregations.timeseries.TimeSeries;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalTimeSeries
extends InternalMultiBucketAggregation<InternalTimeSeries, InternalBucket>
implements TimeSeries {
    private static final ObjectParser<ParsedTimeSeries, Void> PARSER = new ObjectParser(ParsedTimeSeries.class.getSimpleName(), true, ParsedTimeSeries::new);
    private final List<InternalBucket> buckets;
    private final boolean keyed;
    private transient Map<String, InternalBucket> bucketMap;

    public InternalTimeSeries(String name, List<InternalBucket> buckets, boolean keyed, Map<String, Object> metadata) {
        super(name, metadata);
        this.buckets = buckets;
        this.keyed = keyed;
    }

    public InternalTimeSeries(StreamInput in) throws IOException {
        super(in);
        this.keyed = in.readBoolean();
        int size = in.readVInt();
        ArrayList<InternalBucket> buckets = new ArrayList<InternalBucket>(size);
        for (int i = 0; i < size; ++i) {
            buckets.add(new InternalBucket(in, this.keyed));
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    public String getWriteableName() {
        return "time_series";
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(Aggregation.CommonFields.BUCKETS.getPreferredName());
        } else {
            builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        }
        for (InternalBucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.keyed);
        out.writeVInt(this.buckets.size());
        for (InternalBucket bucket : this.buckets) {
            bucket.writeTo(out);
        }
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        HashMap<Map<String, Object>, List> bucketsList = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalTimeSeries timeSeries = (InternalTimeSeries)aggregation;
            if (bucketsList != null) {
                for (InternalBucket bucket : timeSeries.buckets) {
                    bucketsList.compute(bucket.key, (map, list) -> {
                        if (list == null) {
                            list = new ArrayList<InternalBucket>();
                        }
                        list.add(bucket);
                        return list;
                    });
                }
                continue;
            }
            bucketsList = new HashMap<Map<String, Object>, List>(timeSeries.buckets.size());
            for (InternalBucket bucket : timeSeries.buckets) {
                ArrayList<InternalBucket> bucketList = new ArrayList<InternalBucket>();
                bucketList.add(bucket);
                bucketsList.put(bucket.key, bucketList);
            }
        }
        reduceContext.consumeBucketsAndMaybeBreak(bucketsList.size());
        InternalTimeSeries reduced = new InternalTimeSeries(this.name, new ArrayList<InternalBucket>(bucketsList.size()), this.keyed, this.getMetadata());
        for (Map.Entry bucketEntry : bucketsList.entrySet()) {
            reduced.buckets.add((InternalBucket)this.reduceBucket((List)bucketEntry.getValue(), reduceContext));
        }
        return reduced;
    }

    @Override
    public InternalTimeSeries create(List<InternalBucket> buckets) {
        return new InternalTimeSeries(this.name, buckets, this.keyed, this.metadata);
    }

    @Override
    public InternalBucket createBucket(InternalAggregations aggregations, InternalBucket prototype) {
        return new InternalBucket(prototype.key, prototype.docCount, aggregations, prototype.keyed);
    }

    @Override
    protected InternalBucket reduceBucket(List<InternalBucket> buckets, AggregationReduceContext context) {
        InternalBucket reduced = null;
        ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
        for (InternalBucket bucket : buckets) {
            if (reduced == null) {
                reduced = new InternalBucket(bucket.key, bucket.docCount, bucket.aggregations, bucket.keyed);
            } else {
                reduced.docCount += bucket.docCount;
            }
            aggregationsList.add(bucket.aggregations);
        }
        reduced.aggregations = InternalAggregations.reduce(aggregationsList, context);
        return reduced;
    }

    @Override
    public List<InternalBucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public InternalBucket getBucketByKey(String key) {
        if (this.bucketMap == null) {
            this.bucketMap = new HashMap<String, InternalBucket>(this.buckets.size());
            for (InternalBucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKeyAsString(), bucket);
            }
        }
        return this.bucketMap.get(key);
    }

    static {
        ParsedMultiBucketAggregation.declareMultiBucketAggregationFields(PARSER, parser -> ParsedTimeSeries.ParsedBucket.fromXContent(parser, false), parser -> ParsedTimeSeries.ParsedBucket.fromXContent(parser, true));
    }

    public static class InternalBucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements TimeSeries.Bucket {
        protected long bucketOrd;
        protected final boolean keyed;
        protected final Map<String, Object> key;
        protected long docCount;
        protected InternalAggregations aggregations;

        public InternalBucket(Map<String, Object> key, long docCount, InternalAggregations aggregations, boolean keyed) {
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
            this.keyed = keyed;
        }

        public InternalBucket(StreamInput in, boolean keyed) throws IOException {
            this.keyed = keyed;
            this.key = in.readOrderedMap(StreamInput::readString, StreamInput::readGenericValue);
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.key, StreamOutput::writeString, StreamOutput::writeGenericValue);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        @Override
        public Map<String, Object> getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            return this.key.toString();
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public InternalAggregations getAggregations() {
            return this.aggregations;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.keyed) {
                builder.startObject(this.getKeyAsString());
            } else {
                builder.startObject();
            }
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            InternalBucket that = (InternalBucket)other;
            return Objects.equals(this.key, that.key) && Objects.equals(this.keyed, that.keyed) && Objects.equals(this.docCount, that.docCount) && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.key, this.keyed, this.docCount, this.aggregations);
        }
    }
}

