/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.script.BucketAggregationSelectorScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class BucketSelectorPipelineAggregator
extends PipelineAggregator {
    private BucketHelpers.GapPolicy gapPolicy;
    private Script script;
    private Map<String, String> bucketsPathsMap;

    BucketSelectorPipelineAggregator(String name, Map<String, String> bucketsPathsMap, Script script, BucketHelpers.GapPolicy gapPolicy, Map<String, Object> metadata) {
        super(name, bucketsPathsMap.values().toArray(new String[0]), metadata);
        this.bucketsPathsMap = bucketsPathsMap;
        this.script = script;
        this.gapPolicy = gapPolicy;
    }

    @Override
    public InternalAggregation reduce(InternalAggregation aggregation, AggregationReduceContext reduceContext) {
        InternalMultiBucketAggregation originalAgg = (InternalMultiBucketAggregation)aggregation;
        List buckets = originalAgg.getBuckets();
        BucketAggregationSelectorScript.Factory factory = reduceContext.scriptService().compile(this.script, BucketAggregationSelectorScript.CONTEXT);
        ArrayList<InternalMultiBucketAggregation.InternalBucket> newBuckets = new ArrayList<InternalMultiBucketAggregation.InternalBucket>();
        for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            if (this.script.getParams() != null) {
                vars.putAll(this.script.getParams());
            }
            for (Map.Entry<String, String> entry : this.bucketsPathsMap.entrySet()) {
                String varName = entry.getKey();
                String bucketsPath = entry.getValue();
                Double value = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)originalAgg, bucket, bucketsPath, this.gapPolicy);
                vars.put(varName, value);
            }
            BucketAggregationSelectorScript executableScript = factory.newInstance(vars);
            if (!executableScript.execute()) continue;
            newBuckets.add(bucket);
        }
        return originalAgg.create(newBuckets);
    }
}

