/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.GeoBounds;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalGeoBounds
extends InternalAggregation
implements GeoBounds {
    public final double top;
    public final double bottom;
    public final double posLeft;
    public final double posRight;
    public final double negLeft;
    public final double negRight;
    public final boolean wrapLongitude;

    public InternalGeoBounds(String name, double top, double bottom, double posLeft, double posRight, double negLeft, double negRight, boolean wrapLongitude, Map<String, Object> metadata) {
        super(name, metadata);
        this.top = top;
        this.bottom = bottom;
        this.posLeft = posLeft;
        this.posRight = posRight;
        this.negLeft = negLeft;
        this.negRight = negRight;
        this.wrapLongitude = wrapLongitude;
    }

    public InternalGeoBounds(StreamInput in) throws IOException {
        super(in);
        this.top = in.readDouble();
        this.bottom = in.readDouble();
        this.posLeft = in.readDouble();
        this.posRight = in.readDouble();
        this.negLeft = in.readDouble();
        this.negRight = in.readDouble();
        this.wrapLongitude = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeDouble(this.top);
        out.writeDouble(this.bottom);
        out.writeDouble(this.posLeft);
        out.writeDouble(this.posRight);
        out.writeDouble(this.negLeft);
        out.writeDouble(this.negRight);
        out.writeBoolean(this.wrapLongitude);
    }

    @Override
    public String getWriteableName() {
        return "geo_bounds";
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        double top = Double.NEGATIVE_INFINITY;
        double bottom = Double.POSITIVE_INFINITY;
        double posLeft = Double.POSITIVE_INFINITY;
        double posRight = Double.NEGATIVE_INFINITY;
        double negLeft = Double.POSITIVE_INFINITY;
        double negRight = Double.NEGATIVE_INFINITY;
        for (InternalAggregation aggregation : aggregations) {
            InternalGeoBounds bounds = (InternalGeoBounds)aggregation;
            if (bounds.top > top) {
                top = bounds.top;
            }
            if (bounds.bottom < bottom) {
                bottom = bounds.bottom;
            }
            if (bounds.posLeft < posLeft) {
                posLeft = bounds.posLeft;
            }
            if (bounds.posRight > posRight) {
                posRight = bounds.posRight;
            }
            if (bounds.negLeft < negLeft) {
                negLeft = bounds.negLeft;
            }
            if (!(bounds.negRight > negRight)) continue;
            negRight = bounds.negRight;
        }
        return new InternalGeoBounds(this.name, top, bottom, posLeft, posRight, negLeft, negRight, this.wrapLongitude, this.getMetadata());
    }

    @Override
    protected boolean mustReduceOnSingleInternalAgg() {
        return false;
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1) {
            String bBoxSide;
            GeoBoundingBox geoBoundingBox = this.resolveGeoBoundingBox();
            return switch (bBoxSide = path.get(0)) {
                case "top" -> geoBoundingBox.top();
                case "left" -> geoBoundingBox.left();
                case "bottom" -> geoBoundingBox.bottom();
                case "right" -> geoBoundingBox.right();
                default -> throw new IllegalArgumentException("Found unknown path element [" + bBoxSide + "] in [" + this.getName() + "]");
            };
        }
        if (path.size() == 2) {
            String latLonString;
            String cornerString;
            GeoBoundingBox geoBoundingBox = this.resolveGeoBoundingBox();
            GeoPoint cornerPoint = null;
            cornerPoint = switch (cornerString = path.get(0)) {
                case "top_left" -> geoBoundingBox.topLeft();
                case "bottom_right" -> geoBoundingBox.bottomRight();
                default -> throw new IllegalArgumentException("Found unknown path element [" + cornerString + "] in [" + this.getName() + "]");
            };
            return switch (latLonString = path.get(1)) {
                case "lat" -> cornerPoint.lat();
                case "lon" -> cornerPoint.lon();
                default -> throw new IllegalArgumentException("Found unknown path element [" + latLonString + "] in [" + this.getName() + "]");
            };
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        GeoBoundingBox bbox = this.resolveGeoBoundingBox();
        if (bbox != null) {
            builder.startObject(GeoBoundingBox.BOUNDS_FIELD.getPreferredName());
            bbox.toXContentFragment(builder, true);
            builder.endObject();
        }
        return builder;
    }

    private GeoBoundingBox resolveGeoBoundingBox() {
        if (Double.isInfinite(this.top)) {
            return null;
        }
        if (Double.isInfinite(this.posLeft)) {
            return new GeoBoundingBox(new GeoPoint(this.top, this.negLeft), new GeoPoint(this.bottom, this.negRight));
        }
        if (Double.isInfinite(this.negLeft)) {
            return new GeoBoundingBox(new GeoPoint(this.top, this.posLeft), new GeoPoint(this.bottom, this.posRight));
        }
        if (this.wrapLongitude) {
            double unwrappedWidth = this.posRight - this.negLeft;
            double wrappedWidth = 180.0 - this.posLeft - (-180.0 - this.negRight);
            if (unwrappedWidth <= wrappedWidth) {
                return new GeoBoundingBox(new GeoPoint(this.top, this.negLeft), new GeoPoint(this.bottom, this.posRight));
            }
            return new GeoBoundingBox(new GeoPoint(this.top, this.posLeft), new GeoPoint(this.bottom, this.negRight));
        }
        return new GeoBoundingBox(new GeoPoint(this.top, this.negLeft), new GeoPoint(this.bottom, this.posRight));
    }

    @Override
    public GeoPoint topLeft() {
        GeoBoundingBox geoBoundingBox = this.resolveGeoBoundingBox();
        if (geoBoundingBox == null) {
            return null;
        }
        return geoBoundingBox.topLeft();
    }

    @Override
    public GeoPoint bottomRight() {
        GeoBoundingBox geoBoundingBox = this.resolveGeoBoundingBox();
        if (geoBoundingBox == null) {
            return null;
        }
        return geoBoundingBox.bottomRight();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalGeoBounds other = (InternalGeoBounds)obj;
        return this.top == other.top && this.bottom == other.bottom && this.posLeft == other.posLeft && this.posRight == other.posRight && this.negLeft == other.negLeft && this.negRight == other.negRight && this.wrapLongitude == other.wrapLongitude;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bottom, this.posLeft, this.posRight, this.negLeft, this.negRight, this.wrapLongitude);
    }
}

