/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.LongRareTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.RareTermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.RareTermsAggregatorSupplier;
import org.elasticsearch.search.aggregations.bucket.terms.StringRareTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedRareTerms;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.xcontent.ParseField;

public class RareTermsAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final RareTermsAggregatorSupplier aggregatorSupplier;
    private final IncludeExclude includeExclude;
    private final int maxDocCount;
    private final double precision;

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(RareTermsAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.KEYWORD, CoreValuesSourceType.IP), RareTermsAggregatorFactory.bytesSupplier(), true);
        builder.register(RareTermsAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN, CoreValuesSourceType.NUMERIC), RareTermsAggregatorFactory.numericSupplier(), true);
    }

    private static RareTermsAggregatorSupplier bytesSupplier() {
        return new RareTermsAggregatorSupplier(){

            @Override
            public Aggregator build(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, int maxDocCount, double precision, IncludeExclude includeExclude, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                ExecutionMode execution = ExecutionMode.MAP;
                if (includeExclude != null && includeExclude.isRegexBased() && format != DocValueFormat.RAW) {
                    throw new IllegalArgumentException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of values for include/exclude clauses");
                }
                return execution.create(name, factories, valuesSource, format, includeExclude, context, parent, metadata, maxDocCount, precision, cardinality);
            }
        };
    }

    private static RareTermsAggregatorSupplier numericSupplier() {
        return new RareTermsAggregatorSupplier(){

            @Override
            public Aggregator build(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, int maxDocCount, double precision, IncludeExclude includeExclude, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                if (includeExclude != null && includeExclude.isRegexBased()) {
                    throw new IllegalArgumentException("Aggregation [" + name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of numeric values for include/exclude clauses used to filter numeric fields");
                }
                IncludeExclude.LongFilter longFilter = null;
                if (((ValuesSource.Numeric)valuesSource).isFloatingPoint()) {
                    throw new IllegalArgumentException("RareTerms aggregation does not support floating point fields.");
                }
                if (includeExclude != null) {
                    longFilter = includeExclude.convertToLongFilter(format);
                }
                return new LongRareTermsAggregator(name, factories, (ValuesSource.Numeric)valuesSource, format, context, parent, longFilter, maxDocCount, precision, cardinality, metadata);
            }
        };
    }

    RareTermsAggregatorFactory(String name, ValuesSourceConfig config, IncludeExclude includeExclude, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, int maxDocCount, double precision, RareTermsAggregatorSupplier aggregatorSupplier) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.aggregatorSupplier = aggregatorSupplier;
        this.includeExclude = includeExclude;
        this.maxDocCount = maxDocCount;
        this.precision = precision;
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        final UnmappedRareTerms aggregation = new UnmappedRareTerms(this.name, metadata);
        return new NonCollectingAggregator(this.name, this.context, parent, this.factories, metadata){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    @Override
    protected Aggregator doCreateInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.aggregatorSupplier.build(this.name, this.factories, this.config.getValuesSource(), this.config.format(), this.maxDocCount, this.precision, this.includeExclude, this.context, parent, cardinality, metadata);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, IncludeExclude includeExclude, AggregationContext context, Aggregator parent, Map<String, Object> metadata, long maxDocCount, double precision, CardinalityUpperBound cardinality) throws IOException {
                IncludeExclude.StringFilter filter = includeExclude == null ? null : includeExclude.convertToStringFilter(format);
                return new StringRareTermsAggregator(name, factories, (ValuesSource.Bytes)valuesSource, format, filter, context, parent, metadata, maxDocCount, precision, cardinality);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return false;
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value, DeprecationLogger deprecationLogger) {
            switch (value) {
                case "map": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of [map]");
                }
            }
            return MAP;
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, ValuesSource var3, DocValueFormat var4, IncludeExclude var5, AggregationContext var6, Aggregator var7, Map<String, Object> var8, long var9, double var11, CardinalityUpperBound var13) throws IOException;

        abstract boolean needsGlobalOrdinals();

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

