/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler.random;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.random.InternalRandomSampler;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class RandomSamplerAggregator
extends BucketsAggregator
implements SingleBucketAggregator {
    private final int seed;
    private final CheckedSupplier<Weight, IOException> weightSupplier;

    RandomSamplerAggregator(String name, int seed, CheckedSupplier<Weight, IOException> weightSupplier, AggregatorFactories factories, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinalityUpperBound, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, cardinalityUpperBound, metadata);
        this.seed = seed;
        if (this.subAggregators().length == 0) {
            throw new IllegalArgumentException("random_sampler aggregation [" + name + "] must have sub aggregations configured");
        }
        this.weightSupplier = weightSupplier;
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForSingleBucket(owningBucketOrds, (owningBucketOrd, subAggregationResults) -> new InternalRandomSampler(this.name, this.bucketDocCount(owningBucketOrd), this.seed, subAggregationResults, this.metadata()));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalRandomSampler(this.name, 0L, this.seed, this.buildEmptySubAggregations(), this.metadata());
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        Scorer scorer = this.weightSupplier.get().scorer(ctx);
        if (scorer == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        DocIdSetIterator docIt = scorer.iterator();
        Bits liveDocs = ctx.reader().getLiveDocs();
        int docId = docIt.nextDoc();
        while (docId != Integer.MAX_VALUE) {
            if (liveDocs == null || liveDocs.get(docIt.docID())) {
                this.collectBucket(sub, docIt.docID(), 0L);
            }
            docId = docIt.nextDoc();
        }
        return LeafBucketCollector.NO_OP_COLLECTOR;
    }
}

