/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.IntPredicate;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.sandbox.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.search.aggregations.bucket.filter.DocValuesFieldExistsAdapter;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.filter.MatchAllQueryToFilterAdapter;
import org.elasticsearch.search.aggregations.bucket.filter.MatchNoneQueryToFilterAdapter;
import org.elasticsearch.search.aggregations.bucket.filter.MergedPointRangeQuery;
import org.elasticsearch.search.aggregations.bucket.filter.TermQueryToFilterAdapter;

public class QueryToFilterAdapter<Q extends Query> {
    private final IndexSearcher searcher;
    private final String key;
    private final Q query;
    private Weight weight;

    public static QueryToFilterAdapter<?> build(IndexSearcher searcher, String key, Query query) throws IOException {
        if ((query = searcher.rewrite(query)) instanceof ConstantScoreQuery) {
            query = ((ConstantScoreQuery)query).getQuery();
        }
        if (query instanceof TermQuery) {
            return new TermQueryToFilterAdapter(searcher, key, (TermQuery)query);
        }
        if (query instanceof DocValuesFieldExistsQuery) {
            return new DocValuesFieldExistsAdapter(searcher, key, (DocValuesFieldExistsQuery)query);
        }
        if (query instanceof MatchAllDocsQuery) {
            return new MatchAllQueryToFilterAdapter(searcher, key, (MatchAllDocsQuery)query);
        }
        if (query instanceof MatchNoDocsQuery) {
            return new MatchNoneQueryToFilterAdapter(searcher, key, (MatchNoDocsQuery)query);
        }
        return new QueryToFilterAdapter<Query>(searcher, key, query);
    }

    QueryToFilterAdapter(IndexSearcher searcher, String key, Q query) {
        this.searcher = searcher;
        this.key = key;
        this.query = query;
    }

    Q query() {
        return this.query;
    }

    public boolean isInefficientUnion() {
        return false;
    }

    public final String key() {
        return this.key;
    }

    protected final IndexSearcher searcher() {
        return this.searcher;
    }

    protected final boolean countCanUseMetadata(FiltersAggregator.Counter counter, Bits live) {
        if (live != null) {
            return false;
        }
        return counter.docCount.alwaysOne();
    }

    QueryToFilterAdapter<?> union(Query extraQuery) throws IOException {
        Query merged;
        extraQuery = this.searcher().rewrite(extraQuery);
        if (extraQuery instanceof MatchAllDocsQuery) {
            return this;
        }
        Query unwrappedQuery = QueryToFilterAdapter.unwrap(this.query);
        Query unwrappedExtraQuery = QueryToFilterAdapter.unwrap(extraQuery);
        if (unwrappedQuery instanceof PointRangeQuery && unwrappedExtraQuery instanceof PointRangeQuery && (merged = MergedPointRangeQuery.merge((PointRangeQuery)unwrappedQuery, (PointRangeQuery)unwrappedExtraQuery)) != null) {
            return new QueryToFilterAdapter<Query>(this.searcher(), this.key(), merged);
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(this.query, BooleanClause.Occur.MUST);
        builder.add(extraQuery, BooleanClause.Occur.MUST);
        return new QueryToFilterAdapter<BooleanQuery>(this.searcher(), this.key(), builder.build()){

            @Override
            public boolean isInefficientUnion() {
                return true;
            }
        };
    }

    private static Query unwrap(Query query) {
        while (true) {
            if (query instanceof ConstantScoreQuery) {
                query = ((ConstantScoreQuery)query).getQuery();
                continue;
            }
            if (query instanceof IndexSortSortedNumericDocValuesRangeQuery) {
                query = ((IndexSortSortedNumericDocValuesRangeQuery)query).getFallbackQuery();
                continue;
            }
            if (!(query instanceof IndexOrDocValuesQuery)) break;
            query = ((IndexOrDocValuesQuery)query).getIndexQuery();
        }
        return query;
    }

    IntPredicate matchingDocIds(LeafReaderContext ctx) throws IOException {
        return arg_0 -> ((Bits)Lucene.asSequentialAccessBits(ctx.reader().maxDoc(), this.weight().scorerSupplier(ctx))).get(arg_0);
    }

    long count(LeafReaderContext ctx, FiltersAggregator.Counter counter, Bits live) throws IOException {
        BulkScorer scorer = this.weight().bulkScorer(ctx);
        if (scorer == null) {
            return 0L;
        }
        scorer.score((LeafCollector)counter, live);
        return counter.readAndReset(ctx);
    }

    void collect(LeafReaderContext ctx, LeafCollector collector, Bits live) throws IOException {
        BulkScorer scorer = this.weight().bulkScorer(ctx);
        if (scorer == null) {
            return;
        }
        scorer.score(collector, live);
    }

    void collectDebugInfo(BiConsumer<String, Object> add) {
        add.accept("query", this.query.toString());
    }

    private Weight weight() throws IOException {
        if (this.weight == null) {
            this.weight = this.searcher().createWeight(this.query, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        }
        return this.weight;
    }
}

