/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.Filters;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalFilters
extends InternalMultiBucketAggregation<InternalFilters, InternalBucket>
implements Filters {
    private final List<InternalBucket> buckets;
    private final boolean keyed;
    private transient Map<String, InternalBucket> bucketMap;

    public InternalFilters(String name, List<InternalBucket> buckets, boolean keyed, Map<String, Object> metadata) {
        super(name, metadata);
        this.buckets = buckets;
        this.keyed = keyed;
    }

    public InternalFilters(StreamInput in) throws IOException {
        super(in);
        this.keyed = in.readBoolean();
        int size = in.readVInt();
        ArrayList<InternalBucket> buckets = new ArrayList<InternalBucket>(size);
        for (int i = 0; i < size; ++i) {
            buckets.add(new InternalBucket(in, this.keyed));
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.keyed);
        out.writeVInt(this.buckets.size());
        for (InternalBucket bucket : this.buckets) {
            bucket.writeTo(out);
        }
    }

    @Override
    public String getWriteableName() {
        return "filters";
    }

    @Override
    public InternalFilters create(List<InternalBucket> buckets) {
        return new InternalFilters(this.name, buckets, this.keyed, this.metadata);
    }

    @Override
    public InternalBucket createBucket(InternalAggregations aggregations, InternalBucket prototype) {
        return new InternalBucket(prototype.key, prototype.docCount, aggregations, prototype.keyed);
    }

    @Override
    public List<InternalBucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public InternalBucket getBucketByKey(String key) {
        if (this.bucketMap == null) {
            this.bucketMap = Maps.newMapWithExpectedSize(this.buckets.size());
            for (InternalBucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKey(), bucket);
            }
        }
        return this.bucketMap.get(key);
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        ArrayList bucketsList = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalFilters internalFilters = (InternalFilters)aggregation;
            if (bucketsList == null) {
                bucketsList = new ArrayList(internalFilters.buckets.size());
                for (InternalBucket bucket : internalFilters.buckets) {
                    ArrayList<InternalBucket> sameRangeList = new ArrayList<InternalBucket>(aggregations.size());
                    sameRangeList.add(bucket);
                    bucketsList.add(sameRangeList);
                }
                continue;
            }
            int i = 0;
            for (InternalBucket bucket : internalFilters.buckets) {
                ((List)bucketsList.get(i++)).add(bucket);
            }
        }
        reduceContext.consumeBucketsAndMaybeBreak(bucketsList.size());
        InternalFilters reduced = new InternalFilters(this.name, new ArrayList<InternalBucket>(bucketsList.size()), this.keyed, this.getMetadata());
        for (List list : bucketsList) {
            reduced.buckets.add((InternalBucket)this.reduceBucket(list, reduceContext));
        }
        return reduced;
    }

    @Override
    protected InternalBucket reduceBucket(List<InternalBucket> buckets, AggregationReduceContext context) {
        assert (buckets.size() > 0);
        InternalBucket reduced = null;
        ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
        for (InternalBucket bucket : buckets) {
            if (reduced == null) {
                reduced = new InternalBucket(bucket.key, bucket.docCount, bucket.aggregations, bucket.keyed);
            } else {
                reduced.docCount += bucket.docCount;
            }
            aggregationsList.add(bucket.aggregations);
        }
        reduced.aggregations = InternalAggregations.reduce(aggregationsList, context);
        return reduced;
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(Aggregation.CommonFields.BUCKETS.getPreferredName());
        } else {
            builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        }
        for (InternalBucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buckets, this.keyed);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalFilters that = (InternalFilters)obj;
        return Objects.equals(this.buckets, that.buckets) && Objects.equals(this.keyed, that.keyed);
    }

    public static class InternalBucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements Filters.Bucket {
        private final boolean keyed;
        private final String key;
        private long docCount;
        InternalAggregations aggregations;

        public InternalBucket(String key, long docCount, InternalAggregations aggregations, boolean keyed) {
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
            this.keyed = keyed;
        }

        public InternalBucket(StreamInput in, boolean keyed) throws IOException {
            this.keyed = keyed;
            this.key = in.readOptionalString();
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.key);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            return this.key;
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public InternalAggregations getAggregations() {
            return this.aggregations;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.keyed) {
                builder.startObject(this.key);
            } else {
                builder.startObject();
            }
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            InternalBucket that = (InternalBucket)other;
            return Objects.equals(this.key, that.key) && Objects.equals(this.keyed, that.keyed) && Objects.equals(this.docCount, that.docCount) && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.key, this.keyed, this.docCount, this.aggregations);
        }
    }
}

