/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;

public class DocCountProvider {
    public static final int DEFAULT_VALUE = 1;
    private PostingsEnum docCountPostings;

    public int getDocCount(int doc) throws IOException {
        if (this.docCountPostings == null) {
            return 1;
        }
        if (this.docCountPostings.docID() < doc) {
            this.docCountPostings.advance(doc);
        }
        if (this.docCountPostings.docID() == doc) {
            return this.docCountPostings.freq();
        }
        return 1;
    }

    public void setLeafReaderContext(LeafReaderContext ctx) throws IOException {
        this.docCountPostings = ctx.reader().postings(new Term("_doc_count", "_doc_count"));
    }

    public boolean alwaysOne() {
        return this.docCountPostings == null;
    }

    public String toString() {
        return "doc counts are " + (String)(this.alwaysOne() ? "always one" : "based on " + this.docCountPostings);
    }
}

