/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.util.Comparators;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.DelayedBucket;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.KeyComparable;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.support.AggregationPath;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public abstract class InternalOrder
extends BucketOrder {
    private static final byte COUNT_DESC_ID = 1;
    private static final byte COUNT_ASC_ID = 2;
    private static final byte KEY_DESC_ID = 3;
    private static final byte KEY_ASC_ID = 4;
    static final InternalOrder COUNT_DESC = new SimpleOrder(1, "_count", SortOrder.DESC, InternalOrder.comparingCounts().reversed(), InternalOrder.comparingDelayedCounts().reversed());
    static final InternalOrder COUNT_ASC = new SimpleOrder(2, "_count", SortOrder.ASC, InternalOrder.comparingCounts(), InternalOrder.comparingDelayedCounts());
    static final InternalOrder KEY_DESC = new SimpleOrder(3, "_key", SortOrder.DESC, InternalOrder.comparingKeys().reversed(), InternalOrder.comparingDelayedKeys().reversed());
    static final InternalOrder KEY_ASC = new SimpleOrder(4, "_key", SortOrder.ASC, InternalOrder.comparingKeys(), InternalOrder.comparingDelayedKeys());

    private static Comparator<MultiBucketsAggregation.Bucket> comparingCounts() {
        return Comparator.comparingLong(MultiBucketsAggregation.Bucket::getDocCount);
    }

    private static Comparator<DelayedBucket<? extends MultiBucketsAggregation.Bucket>> comparingDelayedCounts() {
        return Comparator.comparingLong(DelayedBucket::getDocCount);
    }

    private static Comparator<MultiBucketsAggregation.Bucket> comparingKeys() {
        return (b1, b2) -> {
            if (b1 instanceof KeyComparable) {
                return ((KeyComparable)((Object)b1)).compareKey(b2);
            }
            throw new IllegalStateException("Unexpected order bucket class [" + b1.getClass() + "]");
        };
    }

    private static Comparator<DelayedBucket<? extends MultiBucketsAggregation.Bucket>> comparingDelayedKeys() {
        return DelayedBucket::compareKey;
    }

    public static boolean isCountDesc(BucketOrder order) {
        return InternalOrder.isOrder(order, COUNT_DESC);
    }

    public static boolean isKeyOrder(BucketOrder order) {
        return InternalOrder.isOrder(order, KEY_ASC) || InternalOrder.isOrder(order, KEY_DESC);
    }

    public static boolean isKeyAsc(BucketOrder order) {
        return InternalOrder.isOrder(order, KEY_ASC);
    }

    public static boolean isKeyDesc(BucketOrder order) {
        return InternalOrder.isOrder(order, KEY_DESC);
    }

    private static boolean isOrder(BucketOrder order, BucketOrder expected) {
        List<BucketOrder> orders;
        if (order == expected) {
            return true;
        }
        if (order instanceof CompoundOrder && (orders = ((CompoundOrder)order).orderElements).size() >= 1) {
            return InternalOrder.isOrder(orders.get(0), expected);
        }
        return false;
    }

    public static class CompoundOrder
    extends BucketOrder {
        static final byte ID = -1;
        final List<BucketOrder> orderElements;

        CompoundOrder(List<BucketOrder> compoundOrder) {
            this(compoundOrder, true);
        }

        CompoundOrder(List<BucketOrder> compoundOrder, boolean absoluteOrdering) {
            this.orderElements = new LinkedList<BucketOrder>(compoundOrder);
            BucketOrder lastElement = null;
            for (BucketOrder order : this.orderElements) {
                if (order instanceof CompoundOrder) {
                    throw new IllegalArgumentException("nested compound order not supported");
                }
                lastElement = order;
            }
            if (absoluteOrdering && !InternalOrder.isKeyOrder(lastElement)) {
                this.orderElements.add(KEY_ASC);
            }
            if (this.orderElements.isEmpty()) {
                throw new IllegalArgumentException("empty compound order not supported");
            }
        }

        @Override
        byte id() {
            return -1;
        }

        public List<BucketOrder> orderElements() {
            return Collections.unmodifiableList(this.orderElements);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray();
            for (BucketOrder order : this.orderElements) {
                order.toXContent(builder, params);
            }
            return builder.endArray();
        }

        @Override
        public <T extends MultiBucketsAggregation.Bucket> Comparator<T> partiallyBuiltBucketComparator(ToLongFunction<T> ordinalReader, Aggregator aggregator) {
            List comparators = this.orderElements.stream().map(oe -> oe.partiallyBuiltBucketComparator(ordinalReader, aggregator)).collect(Collectors.toList());
            return (lhs, rhs) -> {
                for (Comparator c : comparators) {
                    int result = c.compare(lhs, rhs);
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            };
        }

        @Override
        public Comparator<MultiBucketsAggregation.Bucket> comparator() {
            List comparators = this.orderElements.stream().map(BucketOrder::comparator).collect(Collectors.toList());
            return (lhs, rhs) -> {
                for (Comparator c : comparators) {
                    int result = c.compare(lhs, rhs);
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            };
        }

        @Override
        Comparator<DelayedBucket<? extends MultiBucketsAggregation.Bucket>> delayedBucketComparator() {
            List comparators = this.orderElements.stream().map(BucketOrder::delayedBucketComparator).collect(Collectors.toList());
            return (lhs, rhs) -> {
                for (Comparator c : comparators) {
                    int result = c.compare(lhs, rhs);
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            };
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.orderElements);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompoundOrder other = (CompoundOrder)obj;
            return Objects.equals(this.orderElements, other.orderElements);
        }
    }

    private static class SimpleOrder
    extends InternalOrder {
        private final byte id;
        private final String key;
        private final SortOrder order;
        private final Comparator<MultiBucketsAggregation.Bucket> comparator;
        private final Comparator<DelayedBucket<? extends MultiBucketsAggregation.Bucket>> delayedBucketCompator;

        SimpleOrder(byte id, String key, SortOrder order, Comparator<MultiBucketsAggregation.Bucket> comparator, Comparator<DelayedBucket<? extends MultiBucketsAggregation.Bucket>> delayedBucketCompator) {
            this.id = id;
            this.key = key;
            this.order = order;
            this.comparator = comparator;
            this.delayedBucketCompator = delayedBucketCompator;
        }

        @Override
        public Comparator<MultiBucketsAggregation.Bucket> comparator() {
            return this.comparator;
        }

        @Override
        Comparator<DelayedBucket<? extends MultiBucketsAggregation.Bucket>> delayedBucketComparator() {
            return this.delayedBucketCompator;
        }

        @Override
        byte id() {
            return this.id;
        }

        @Override
        public <T extends MultiBucketsAggregation.Bucket> Comparator<T> partiallyBuiltBucketComparator(ToLongFunction<T> ordinalReader, Aggregator aggregator) {
            Comparator<MultiBucketsAggregation.Bucket> comparator = this.comparator();
            return (lhs, rhs) -> comparator.compare((MultiBucketsAggregation.Bucket)lhs, (MultiBucketsAggregation.Bucket)rhs);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(this.key, this.order.toString()).endObject();
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.id, this.key, this.order);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleOrder other = (SimpleOrder)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.key, other.key) && Objects.equals(this.order, other.order);
        }
    }

    public static class Parser {
        private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(Parser.class);

        public static BucketOrder parseOrderParam(XContentParser parser) throws IOException {
            XContentParser.Token token;
            String orderKey = null;
            boolean orderAsc = false;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    orderKey = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    String dir = parser.text();
                    if ("asc".equalsIgnoreCase(dir)) {
                        orderAsc = true;
                        continue;
                    }
                    if ("desc".equalsIgnoreCase(dir)) {
                        orderAsc = false;
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "Unknown order direction [" + dir + "]", new Object[0]);
                }
                throw new ParsingException(parser.getTokenLocation(), "Unexpected token [" + token + "] for [order]", new Object[0]);
            }
            if (orderKey == null) {
                throw new ParsingException(parser.getTokenLocation(), "Must specify at least one field for [order]", new Object[0]);
            }
            if (parser.getRestApiVersion() == RestApiVersion.V_7 && ("_term".equals(orderKey) || "_time".equals(orderKey))) {
                deprecationLogger.compatibleCritical("_term_and_time_key_removal", "Deprecated aggregation order key [{}] used, replaced by [_key]", orderKey);
                return orderAsc ? KEY_ASC : KEY_DESC;
            }
            return switch (orderKey) {
                case "_key" -> {
                    if (orderAsc) {
                        yield KEY_ASC;
                    }
                    yield KEY_DESC;
                }
                case "_count" -> {
                    if (orderAsc) {
                        yield COUNT_ASC;
                    }
                    yield COUNT_DESC;
                }
                default -> BucketOrder.aggregation(orderKey, orderAsc);
            };
        }
    }

    public static class Streams {
        public static BucketOrder readOrder(StreamInput in) throws IOException {
            byte id = in.readByte();
            switch (id) {
                case 1: {
                    return COUNT_DESC;
                }
                case 2: {
                    return COUNT_ASC;
                }
                case 3: {
                    return KEY_DESC;
                }
                case 4: {
                    return KEY_ASC;
                }
                case 0: {
                    boolean asc = in.readBoolean();
                    String key = in.readString();
                    return new Aggregation(key, asc);
                }
                case -1: {
                    int size = in.readVInt();
                    ArrayList<BucketOrder> compoundOrder = new ArrayList<BucketOrder>(size);
                    for (int i = 0; i < size; ++i) {
                        compoundOrder.add(Streams.readOrder(in));
                    }
                    return new CompoundOrder(compoundOrder, false);
                }
            }
            throw new RuntimeException("unknown order id [" + id + "]");
        }

        public static BucketOrder readHistogramOrder(StreamInput in) throws IOException {
            return Streams.readOrder(in);
        }

        public static void writeOrder(BucketOrder order, StreamOutput out) throws IOException {
            out.writeByte(order.id());
            if (order instanceof Aggregation) {
                Aggregation aggregationOrder = (Aggregation)order;
                out.writeBoolean(aggregationOrder.order == SortOrder.ASC);
                out.writeString(aggregationOrder.path().toString());
            } else if (order instanceof CompoundOrder) {
                CompoundOrder compoundOrder = (CompoundOrder)order;
                out.writeVInt(compoundOrder.orderElements.size());
                for (BucketOrder innerOrder : compoundOrder.orderElements) {
                    innerOrder.writeTo(out);
                }
            }
        }

        public static void writeHistogramOrder(BucketOrder order, StreamOutput out) throws IOException {
            order.writeTo(out);
        }
    }

    public static class Aggregation
    extends InternalOrder {
        static final byte ID = 0;
        private final SortOrder order;
        private final AggregationPath path;

        Aggregation(String path, boolean asc) {
            this.order = asc ? SortOrder.ASC : SortOrder.DESC;
            this.path = AggregationPath.parse(path);
        }

        public AggregationPath path() {
            return this.path;
        }

        @Override
        public <T extends MultiBucketsAggregation.Bucket> Comparator<T> partiallyBuiltBucketComparator(ToLongFunction<T> ordinalReader, Aggregator aggregator) {
            try {
                Aggregator.BucketComparator bucketComparator = this.path.bucketComparator(aggregator, this.order);
                return (lhs, rhs) -> bucketComparator.compare(ordinalReader.applyAsLong(lhs), ordinalReader.applyAsLong(rhs));
            }
            catch (IllegalArgumentException e) {
                throw new AggregationExecutionException("Invalid aggregation order path [" + this.path + "]. " + e.getMessage(), e);
            }
        }

        @Override
        public Comparator<MultiBucketsAggregation.Bucket> comparator() {
            return (lhs, rhs) -> {
                double l = this.path.resolveValue((InternalAggregations)lhs.getAggregations());
                double r = this.path.resolveValue((InternalAggregations)rhs.getAggregations());
                return Comparators.compareDiscardNaN(l, r, this.order == SortOrder.ASC);
            };
        }

        @Override
        Comparator<DelayedBucket<? extends MultiBucketsAggregation.Bucket>> delayedBucketComparator() {
            Comparator<MultiBucketsAggregation.Bucket> comparator = this.comparator();
            return (lhs, rhs) -> comparator.compare((MultiBucketsAggregation.Bucket)lhs.reduced(), (MultiBucketsAggregation.Bucket)rhs.reduced());
        }

        @Override
        byte id() {
            return 0;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(this.path.toString(), this.order.toString()).endObject();
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.path, this.order);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Aggregation other = (Aggregation)obj;
            return Objects.equals(this.path, other.path) && Objects.equals(this.order, other.order);
        }
    }
}

