/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.script.field.DocValuesField;

public class ScaledFloatDocValuesField
implements DocValuesField<Double>,
ScriptDocValues.Supplier<Double> {
    protected final SortedNumericDoubleValues input;
    protected final String name;
    protected double[] values = new double[0];
    protected int count;
    private ScriptDocValues.Doubles doubles = null;

    public ScaledFloatDocValuesField(SortedNumericDoubleValues input, String name) {
        this.input = input;
        this.name = name;
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        if (this.input.advanceExact(docId)) {
            this.resize(this.input.docValueCount());
            for (int i = 0; i < this.count; ++i) {
                this.values[i] = this.input.nextValue();
            }
        } else {
            this.resize(0);
        }
    }

    protected void resize(int newSize) {
        this.count = newSize;
        assert (this.count >= 0) : "size must be positive (got " + this.count + "): likely integer overflow?";
        this.values = ArrayUtil.grow((double[])this.values, (int)this.count);
    }

    @Override
    public ScriptDocValues<Double> getScriptDocValues() {
        if (this.doubles == null) {
            this.doubles = new ScriptDocValues.Doubles(this);
        }
        return this.doubles;
    }

    @Override
    public Double getInternal(int index) {
        return this.values[index];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    public double get(double defaultValue) {
        return this.get(0, defaultValue);
    }

    public double get(int index, double defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.count) {
            return defaultValue;
        }
        return this.values[index];
    }

    public PrimitiveIterator.OfDouble iterator() {
        return new PrimitiveIterator.OfDouble(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ScaledFloatDocValuesField.this.count;
            }

            @Override
            public Double next() {
                return this.nextDouble();
            }

            @Override
            public double nextDouble() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ScaledFloatDocValuesField.this.values[this.index++];
            }
        };
    }
}

