/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.script.field.DocValuesField;

public class HalfFloatDocValuesField
implements DocValuesField<Float>,
ScriptDocValues.Supplier<Double> {
    protected final SortedNumericDoubleValues input;
    protected final String name;
    protected double[] values = new double[0];
    protected int count;
    private ScriptDocValues.Doubles doubles = null;

    public HalfFloatDocValuesField(SortedNumericDoubleValues input, String name) {
        this.input = input;
        this.name = name;
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        if (this.input.advanceExact(docId)) {
            this.resize(this.input.docValueCount());
            for (int i = 0; i < this.count; ++i) {
                this.values[i] = this.input.nextValue();
            }
        } else {
            this.resize(0);
        }
    }

    protected void resize(int newSize) {
        this.count = newSize;
        assert (this.count >= 0) : "size must be positive (got " + this.count + "): likely integer overflow?";
        this.values = ArrayUtil.grow((double[])this.values, (int)this.count);
    }

    @Override
    public ScriptDocValues<Double> getScriptDocValues() {
        if (this.doubles == null) {
            this.doubles = new ScriptDocValues.Doubles(this);
        }
        return this.doubles;
    }

    @Override
    public Double getInternal(int index) {
        return this.values[index];
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    public float get(double defaultValue) {
        return this.get(0, defaultValue);
    }

    public float get(int index, double defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.count) {
            return (float)defaultValue;
        }
        return (float)this.values[index];
    }

    @Override
    public Iterator<Float> iterator() {
        return new Iterator<Float>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < HalfFloatDocValuesField.this.count;
            }

            @Override
            public Float next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Float.valueOf((float)HalfFloatDocValuesField.this.values[this.index++]);
            }
        };
    }

    public List<Double> asDoubles() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Double> doubleValues = new ArrayList<Double>(this.count);
        for (int index = 0; index < this.count; ++index) {
            doubleValues.add(this.values[index]);
        }
        return doubleValues;
    }

    public double asDouble(double defaultValue) {
        return this.asDouble(0, defaultValue);
    }

    public double asDouble(int index, double defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.count) {
            return defaultValue;
        }
        return this.values[index];
    }
}

