/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.field.DocValuesField;

public class GeoPointDocValuesField
implements DocValuesField<GeoPoint>,
ScriptDocValues.GeometrySupplier<GeoPoint> {
    protected final MultiGeoPointValues input;
    protected final String name;
    protected GeoPoint[] values = new GeoPoint[0];
    protected int count;
    private ScriptDocValues.GeoPoints geoPoints = null;
    private final GeoPoint centroid = new GeoPoint();
    private final GeoBoundingBox boundingBox = new GeoBoundingBox(new GeoPoint(), new GeoPoint());

    public GeoPointDocValuesField(MultiGeoPointValues input, String name) {
        this.input = input;
        this.name = name;
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        if (this.input.advanceExact(docId)) {
            this.resize(this.input.docValueCount());
            if (this.count == 1) {
                this.setSingleValue();
            } else {
                this.setMultiValue();
            }
        } else {
            this.resize(0);
        }
    }

    private void resize(int newSize) {
        this.count = newSize;
        if (newSize > this.values.length) {
            int oldLength = this.values.length;
            this.values = (GeoPoint[])ArrayUtil.grow((Object[])this.values, (int)this.count);
            for (int i = oldLength; i < this.values.length; ++i) {
                this.values[i] = new GeoPoint();
            }
        }
    }

    private void setSingleValue() throws IOException {
        GeoPoint point = this.input.nextValue();
        this.values[0].reset(point.lat(), point.lon());
        this.centroid.reset(point.lat(), point.lon());
        this.boundingBox.topLeft().reset(point.lat(), point.lon());
        this.boundingBox.bottomRight().reset(point.lat(), point.lon());
    }

    private void setMultiValue() throws IOException {
        double centroidLat = 0.0;
        double centroidLon = 0.0;
        double maxLon = Double.NEGATIVE_INFINITY;
        double minLon = Double.POSITIVE_INFINITY;
        double maxLat = Double.NEGATIVE_INFINITY;
        double minLat = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.count; ++i) {
            GeoPoint point = this.input.nextValue();
            this.values[i].reset(point.lat(), point.lon());
            centroidLat += point.getLat();
            centroidLon += point.getLon();
            maxLon = Math.max(maxLon, this.values[i].getLon());
            minLon = Math.min(minLon, this.values[i].getLon());
            maxLat = Math.max(maxLat, this.values[i].getLat());
            minLat = Math.min(minLat, this.values[i].getLat());
        }
        this.centroid.reset(centroidLat / (double)this.count, centroidLon / (double)this.count);
        this.boundingBox.topLeft().reset(maxLat, minLon);
        this.boundingBox.bottomRight().reset(minLat, maxLon);
    }

    @Override
    public ScriptDocValues<GeoPoint> getScriptDocValues() {
        if (this.geoPoints == null) {
            this.geoPoints = new ScriptDocValues.GeoPoints(this);
        }
        return this.geoPoints;
    }

    @Override
    public GeoPoint getInternal(int index) {
        return this.values[index];
    }

    @Override
    public GeoPoint getInternalCentroid() {
        return this.centroid;
    }

    @Override
    public GeoBoundingBox getInternalBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    public GeoPoint get(GeoPoint defaultValue) {
        return this.get(0, defaultValue);
    }

    public GeoPoint get(int index, GeoPoint defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.count) {
            return defaultValue;
        }
        return this.values[index];
    }

    @Override
    public Iterator<GeoPoint> iterator() {
        return new Iterator<GeoPoint>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < GeoPointDocValuesField.this.count;
            }

            @Override
            public GeoPoint next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return GeoPointDocValuesField.this.values[this.index++];
            }
        };
    }
}

