/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.script.field.DocValuesField;

public class BinaryDocValuesField
implements DocValuesField<ByteBuffer>,
ScriptDocValues.Supplier<BytesRef> {
    private final SortedBinaryDocValues input;
    private final String name;
    private BytesRefBuilder[] values = new BytesRefBuilder[0];
    private int count;
    private ScriptDocValues.BytesRefs bytesRefs = null;

    public BinaryDocValuesField(SortedBinaryDocValues input, String name) {
        this.input = input;
        this.name = name;
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        if (this.input.advanceExact(docId)) {
            this.resize(this.input.docValueCount());
            for (int i = 0; i < this.count; ++i) {
                this.values[i].copyBytes(this.input.nextValue());
            }
        } else {
            this.resize(0);
        }
    }

    private void resize(int newSize) {
        this.count = newSize;
        if (newSize > this.values.length) {
            int oldLength = this.values.length;
            this.values = (BytesRefBuilder[])ArrayUtil.grow((Object[])this.values, (int)this.count);
            for (int i = oldLength; i < this.values.length; ++i) {
                this.values[i] = new BytesRefBuilder();
            }
        }
    }

    @Override
    public ScriptDocValues<?> getScriptDocValues() {
        if (this.bytesRefs == null) {
            this.bytesRefs = new ScriptDocValues.BytesRefs(this);
        }
        return this.bytesRefs;
    }

    @Override
    public BytesRef getInternal(int index) {
        return this.values[index].toBytesRef();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    protected ByteBuffer toWrapped(int index) {
        return ByteBuffer.wrap(this.values[index].toBytesRef().bytes);
    }

    public ByteBuffer get(ByteBuffer defaultValue) {
        return this.get(0, defaultValue);
    }

    public ByteBuffer get(int index, ByteBuffer defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.count) {
            return defaultValue;
        }
        return this.toWrapped(index);
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new Iterator<ByteBuffer>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < BinaryDocValuesField.this.count;
            }

            @Override
            public ByteBuffer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return BinaryDocValuesField.this.toWrapped(this.index++);
            }
        };
    }
}

