/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.field.DocValuesField;

public abstract class AbstractLongDocValuesField
implements ScriptDocValues.Supplier<Long>,
DocValuesField<Long> {
    protected final String name;
    protected ScriptDocValues<?> scriptDocValues = null;
    protected final SortedNumericDocValues input;
    protected long[] values = new long[0];
    protected int count;

    public AbstractLongDocValuesField(SortedNumericDocValues input, String name) {
        this.input = input;
        this.name = name;
    }

    protected ScriptDocValues<?> newScriptDocValues() {
        return new ScriptDocValues.Longs(this);
    }

    protected long formatLong(long raw) {
        return raw;
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        if (this.input.advanceExact(docId)) {
            this.resize(this.input.docValueCount());
            for (int i = 0; i < this.count; ++i) {
                this.values[i] = this.formatLong(this.input.nextValue());
            }
        } else {
            this.resize(0);
        }
    }

    @Override
    public ScriptDocValues<?> getScriptDocValues() {
        if (this.scriptDocValues == null) {
            this.scriptDocValues = this.newScriptDocValues();
        }
        return this.scriptDocValues;
    }

    private void resize(int newSize) {
        this.count = newSize;
        this.values = ArrayUtil.grow((long[])this.values, (int)this.count);
    }

    @Override
    public Long getInternal(int index) {
        return this.getLong(index);
    }

    protected long getLong(int index) {
        return this.values[index];
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public PrimitiveIterator.OfLong iterator() {
        return new PrimitiveIterator.OfLong(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < AbstractLongDocValuesField.this.count;
            }

            @Override
            public Long next() {
                return this.nextLong();
            }

            @Override
            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return AbstractLongDocValuesField.this.getLong(this.index++);
            }
        };
    }

    public long get(long defaultValue) {
        return this.get(0, defaultValue);
    }

    public long get(int index, long defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.count) {
            return defaultValue;
        }
        return this.getLong(index);
    }
}

