/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.script.field.DocValuesField;

public class AbstractKeywordDocValuesField
implements DocValuesField<String>,
ScriptDocValues.Supplier<String> {
    protected final SortedBinaryDocValues input;
    protected final String name;
    protected BytesRefBuilder[] values = new BytesRefBuilder[0];
    protected int count;
    protected ScriptDocValues.Strings strings = null;

    public AbstractKeywordDocValuesField(SortedBinaryDocValues input, String name) {
        this.input = input;
        this.name = name;
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        if (this.input.advanceExact(docId)) {
            this.resize(this.input.docValueCount());
            for (int i = 0; i < this.count; ++i) {
                this.values[i].copyBytes(this.input.nextValue());
            }
        } else {
            this.resize(0);
        }
    }

    private void resize(int newSize) {
        this.count = newSize;
        assert (this.count >= 0) : "size must be positive (got " + this.count + "): likely integer overflow?";
        if (newSize > this.values.length) {
            int oldLength = this.values.length;
            this.values = (BytesRefBuilder[])ArrayUtil.grow((Object[])this.values, (int)this.count);
            for (int i = oldLength; i < this.values.length; ++i) {
                this.values[i] = new BytesRefBuilder();
            }
        }
    }

    @Override
    public ScriptDocValues<String> getScriptDocValues() {
        if (this.strings == null) {
            this.strings = new ScriptDocValues.Strings(this);
        }
        return this.strings;
    }

    @Override
    public String getInternal(int index) {
        return this.bytesToString(this.values[index].toBytesRef());
    }

    protected String bytesToString(BytesRef bytesRef) {
        return bytesRef.utf8ToString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    public String get(String defaultValue) {
        return this.get(0, defaultValue);
    }

    public String get(int index, String defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.count) {
            return defaultValue;
        }
        return this.bytesToString(this.values[index].toBytesRef());
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < AbstractKeywordDocValuesField.this.count;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return AbstractKeywordDocValuesField.this.bytesToString(AbstractKeywordDocValuesField.this.values[this.index++].toBytesRef());
            }
        };
    }
}

