/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class StoredScriptSource
implements SimpleDiffable<StoredScriptSource>,
Writeable,
ToXContentObject {
    public static final ParseField SCRIPT_PARSE_FIELD = new ParseField("script", new String[0]);
    public static final ParseField LANG_PARSE_FIELD = new ParseField("lang", new String[0]);
    public static final ParseField SOURCE_PARSE_FIELD = new ParseField("source", new String[0]);
    public static final ParseField OPTIONS_PARSE_FIELD = new ParseField("options", new String[0]);
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("stored script source", true, Builder::new);
    private final String lang;
    private final String source;
    private final Map<String, String> options;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StoredScriptSource parse(BytesReference content, XContentType xContentType) {
        try (StreamInput stream = content.streamInput();
             XContentParser parser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + token + "], expected [{]", new Object[0]);
            }
            token = parser.nextToken();
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + token + ", expected [" + SCRIPT_PARSE_FIELD.getPreferredName() + "]", new Object[0]);
            }
            String name = parser.currentName();
            if (!SCRIPT_PARSE_FIELD.getPreferredName().equals(name)) throw new ParsingException(parser.getTokenLocation(), "unexpected field [" + name + "], expected [" + SCRIPT_PARSE_FIELD.getPreferredName() + "]", new Object[0]);
            token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + token + "], expected [{, <source>]", new Object[0]);
            StoredScriptSource storedScriptSource = ((Builder)PARSER.apply(parser, null)).build(false);
            return storedScriptSource;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public static StoredScriptSource fromXContent(XContentParser parser, boolean ignoreEmpty) {
        return ((Builder)PARSER.apply(parser, null)).build(ignoreEmpty);
    }

    public static Diff<StoredScriptSource> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(StoredScriptSource::new, in);
    }

    public StoredScriptSource(String lang, String source, Map<String, String> options) {
        this.lang = Objects.requireNonNull(lang);
        this.source = Objects.requireNonNull(source);
        this.options = Collections.unmodifiableMap(Objects.requireNonNull(options));
    }

    public StoredScriptSource(StreamInput in) throws IOException {
        this.lang = in.readString();
        this.source = in.readString();
        Map<String, Object> options = in.readMap();
        this.options = options;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.lang);
        out.writeString(this.source);
        Map<String, Object> options = this.options;
        out.writeMap(options);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(LANG_PARSE_FIELD.getPreferredName(), this.lang);
        builder.field(SOURCE_PARSE_FIELD.getPreferredName(), this.source);
        if (!this.options.isEmpty()) {
            builder.field(OPTIONS_PARSE_FIELD.getPreferredName(), this.options);
        }
        builder.endObject();
        return builder;
    }

    public String getLang() {
        return this.lang;
    }

    public String getSource() {
        return this.source;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredScriptSource that = (StoredScriptSource)o;
        return Objects.equals(this.lang, that.lang) && Objects.equals(this.source, that.source) && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        int result = this.lang != null ? this.lang.hashCode() : 0;
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StoredScriptSource{lang='" + this.lang + "', source='" + this.source + "', options=" + this.options + "}";
    }

    static {
        PARSER.declareString(Builder::setLang, LANG_PARSE_FIELD);
        PARSER.declareField(Builder::setSource, parser -> parser, SOURCE_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareField(Builder::setOptions, XContentParser::mapStrings, OPTIONS_PARSE_FIELD, ObjectParser.ValueType.OBJECT);
    }

    private static final class Builder {
        private String lang;
        private String source;
        private Map<String, String> options = new HashMap<String, String>();

        private Builder() {
        }

        private void setLang(String lang) {
            this.lang = lang;
        }

        private void setSource(XContentParser parser) {
            try {
                if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    this.source = Strings.toString(builder.copyCurrentStructure(parser));
                    this.options.put("content_type", XContentType.JSON.mediaType());
                } else {
                    this.source = parser.text();
                }
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }

        private void setOptions(Map<String, String> options) {
            this.options.putAll(options);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private StoredScriptSource build(boolean ignoreEmpty) {
            if (this.lang == null) {
                throw new IllegalArgumentException("must specify lang for stored script");
            }
            if (this.lang.isEmpty()) {
                throw new IllegalArgumentException("lang cannot be empty");
            }
            if (this.source == null) {
                if (!ignoreEmpty) throw new IllegalArgumentException("must specify source for stored script");
                this.source = "";
            } else if (this.source.isEmpty() && !ignoreEmpty) {
                throw new IllegalArgumentException("source cannot be empty");
            }
            if (this.options.size() <= 1 && (this.options.size() != 1 || this.options.get("content_type") != null)) return new StoredScriptSource(this.lang, this.source, this.options);
            throw new IllegalArgumentException("illegal compiler options [" + this.options + "] specified");
        }
    }
}

