/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorable;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.DocBasedScript;
import org.elasticsearch.script.DocValuesDocReader;
import org.elasticsearch.script.DynamicMap;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public class ScriptedMetricAggContexts {

    public static abstract class ReduceScript {
        private final Map<String, Object> params;
        private final List<Object> states;
        public static String[] PARAMETERS = new String[0];
        public static ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("aggs_reduce", Factory.class);

        public ReduceScript(Map<String, Object> params, List<Object> states) {
            this.params = params;
            this.states = states;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public List<Object> getStates() {
            return this.states;
        }

        public abstract Object execute();

        public static interface Factory
        extends ScriptFactory {
            public ReduceScript newInstance(Map<String, Object> var1, List<Object> var2);
        }
    }

    public static abstract class CombineScript {
        private final Map<String, Object> params;
        private final Map<String, Object> state;
        public static String[] PARAMETERS = new String[0];
        public static ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("aggs_combine", Factory.class);

        public CombineScript(Map<String, Object> params, Map<String, Object> state) {
            this.params = params;
            this.state = state;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Map<String, Object> getState() {
            return this.state;
        }

        public abstract Object execute();

        public static interface Factory
        extends ScriptFactory {
            public CombineScript newInstance(Map<String, Object> var1, Map<String, Object> var2);
        }
    }

    public static abstract class MapScript
    extends DocBasedScript {
        private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(DynamicMap.class);
        private static final Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = Map.of("doc", value -> {
            deprecationLogger.warn(DeprecationCategory.SCRIPTING, "map-script_doc", "Accessing variable [doc] via [params.doc] from within an scripted metric agg map script is deprecated in favor of directly accessing [doc].", new Object[0]);
            return value;
        }, "_doc", value -> {
            deprecationLogger.warn(DeprecationCategory.SCRIPTING, "map-script__doc", "Accessing variable [doc] via [params._doc] from within an scripted metric agg map script is deprecated in favor of directly accessing [doc].", new Object[0]);
            return value;
        }, "_agg", value -> {
            deprecationLogger.warn(DeprecationCategory.SCRIPTING, "map-script__agg", "Accessing variable [_agg] via [params._agg] from within a scripted metric agg map script is deprecated in favor of using [state].", new Object[0]);
            return value;
        }, "_source", value -> ((SourceLookup)value).source());
        private final Map<String, Object> params;
        private final Map<String, Object> state;
        private Scorable scorer;
        public static String[] PARAMETERS = new String[0];
        public static ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("aggs_map", Factory.class);

        public MapScript(Map<String, Object> params, Map<String, Object> state, SearchLookup lookup, LeafReaderContext leafContext) {
            super(leafContext == null ? null : new DocValuesDocReader(lookup, leafContext));
            this.state = state;
            params = new HashMap<String, Object>(params);
            params.putAll(this.docAsMap());
            this.params = new DynamicMap(params, PARAMS_FUNCTIONS);
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Map<String, Object> getState() {
            return this.state;
        }

        @Override
        public Map<String, ScriptDocValues<?>> getDoc() {
            return this.docReader == null ? null : this.docReader.doc();
        }

        public void setScorer(Scorable scorer) {
            this.scorer = scorer;
        }

        public double get_score() {
            if (this.scorer == null) {
                return 0.0;
            }
            try {
                return this.scorer.score();
            }
            catch (IOException e) {
                throw new ElasticsearchException("Couldn't look up score", (Throwable)e, new Object[0]);
            }
        }

        public abstract void execute();

        public static interface Factory
        extends ScriptFactory {
            public LeafFactory newFactory(Map<String, Object> var1, Map<String, Object> var2, SearchLookup var3);
        }

        public static interface LeafFactory {
            public MapScript newInstance(LeafReaderContext var1);
        }
    }

    public static abstract class InitScript {
        private final Map<String, Object> params;
        private final Map<String, Object> state;
        public static String[] PARAMETERS = new String[0];
        public static ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("aggs_init", Factory.class);

        public InitScript(Map<String, Object> params, Map<String, Object> state) {
            this.params = params;
            this.state = state;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Object getState() {
            return this.state;
        }

        public abstract void execute();

        public static interface Factory
        extends ScriptFactory {
            public InitScript newInstance(Map<String, Object> var1, Map<String, Object> var2);
        }
    }
}

