/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.script.ScriptCacheStats;
import org.elasticsearch.script.ScriptContextStats;
import org.elasticsearch.script.TimeSeries;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ScriptStats
implements Writeable,
ToXContentFragment {
    private final List<ScriptContextStats> contextStats;
    private final long compilations;
    private final long cacheEvictions;
    private final long compilationLimitTriggered;
    private final TimeSeries compilationsHistory;
    private final TimeSeries cacheEvictionsHistory;

    public ScriptStats(List<ScriptContextStats> contextStats) {
        ArrayList<ScriptContextStats> ctxStats = new ArrayList<ScriptContextStats>(contextStats.size());
        ctxStats.addAll(contextStats);
        ctxStats.sort(ScriptContextStats::compareTo);
        this.contextStats = Collections.unmodifiableList(ctxStats);
        long compilations = 0L;
        long cacheEvictions = 0L;
        long compilationLimitTriggered = 0L;
        for (ScriptContextStats stats : contextStats) {
            compilations += stats.getCompilations();
            cacheEvictions += stats.getCacheEvictions();
            compilationLimitTriggered += stats.getCompilationLimitTriggered();
        }
        this.compilations = compilations;
        this.cacheEvictions = cacheEvictions;
        this.compilationLimitTriggered = compilationLimitTriggered;
        this.compilationsHistory = new TimeSeries(compilations);
        this.cacheEvictionsHistory = new TimeSeries(cacheEvictions);
    }

    public ScriptStats(long compilations, long cacheEvictions, long compilationLimitTriggered, TimeSeries compilationsHistory, TimeSeries cacheEvictionsHistory) {
        this.contextStats = Collections.emptyList();
        this.compilations = compilations;
        this.cacheEvictions = cacheEvictions;
        this.compilationLimitTriggered = compilationLimitTriggered;
        this.compilationsHistory = compilationsHistory == null ? new TimeSeries(compilations) : compilationsHistory;
        this.cacheEvictionsHistory = cacheEvictionsHistory == null ? new TimeSeries(cacheEvictions) : cacheEvictionsHistory;
    }

    public ScriptStats(ScriptContextStats context) {
        this(context.getCompilations(), context.getCacheEvictions(), context.getCompilationLimitTriggered(), context.getCompilationsHistory(), context.getCacheEvictionsHistory());
    }

    public ScriptStats(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_8_1_0)) {
            this.compilationsHistory = new TimeSeries(in);
            this.cacheEvictionsHistory = new TimeSeries(in);
            this.compilations = this.compilationsHistory.total;
            this.cacheEvictions = this.cacheEvictionsHistory.total;
        } else {
            this.compilations = in.readVLong();
            this.cacheEvictions = in.readVLong();
            this.compilationsHistory = new TimeSeries(this.compilations);
            this.cacheEvictionsHistory = new TimeSeries(this.cacheEvictions);
        }
        this.compilationLimitTriggered = in.readVLong();
        this.contextStats = in.readList(ScriptContextStats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_8_1_0)) {
            this.compilationsHistory.writeTo(out);
            this.cacheEvictionsHistory.writeTo(out);
        } else {
            out.writeVLong(this.compilations);
            out.writeVLong(this.cacheEvictions);
        }
        out.writeVLong(this.compilationLimitTriggered);
        out.writeList(this.contextStats);
    }

    public List<ScriptContextStats> getContextStats() {
        return this.contextStats;
    }

    public long getCompilations() {
        return this.compilations;
    }

    public long getCacheEvictions() {
        return this.cacheEvictions;
    }

    public long getCompilationLimitTriggered() {
        return this.compilationLimitTriggered;
    }

    public ScriptCacheStats toScriptCacheStats() {
        if (this.contextStats.isEmpty()) {
            return new ScriptCacheStats(this);
        }
        Map<String, ScriptStats> contexts = Maps.newMapWithExpectedSize(this.contextStats.size());
        for (ScriptContextStats contextStats : this.contextStats) {
            contexts.put(contextStats.getContext(), new ScriptStats(contextStats));
        }
        return new ScriptCacheStats(contexts);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("script");
        builder.field("compilations", this.compilations);
        builder.field("cache_evictions", this.cacheEvictions);
        builder.field("compilation_limit_triggered", this.compilationLimitTriggered);
        if (this.compilationsHistory != null && !this.compilationsHistory.areTimingsEmpty()) {
            builder.startObject("compilations_history");
            this.compilationsHistory.toXContent(builder, params);
            builder.endObject();
        }
        if (this.cacheEvictionsHistory != null && !this.cacheEvictionsHistory.areTimingsEmpty()) {
            builder.startObject("compilations_history");
            this.cacheEvictionsHistory.toXContent(builder, params);
            builder.endObject();
        }
        builder.startArray("contexts");
        for (ScriptContextStats contextStats : this.contextStats) {
            contextStats.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String SCRIPT_STATS = "script";
        static final String CONTEXTS = "contexts";
        static final String COMPILATIONS = "compilations";
        static final String CACHE_EVICTIONS = "cache_evictions";
        static final String COMPILATION_LIMIT_TRIGGERED = "compilation_limit_triggered";

        Fields() {
        }
    }
}

