/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.storedscripts.DeleteStoredScriptRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.GetStoredScriptRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCache;
import org.elasticsearch.script.ScriptCacheStats;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptContextInfo;
import org.elasticsearch.script.ScriptContextStats;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.ScriptLanguagesInfo;
import org.elasticsearch.script.ScriptMetadata;
import org.elasticsearch.script.ScriptStats;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.StoredScriptSource;

public class ScriptService
implements Closeable,
ClusterStateApplier,
ScriptCompiler {
    private static final Logger logger = LogManager.getLogger(ScriptService.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ScriptService.class);
    static final String DISABLE_DYNAMIC_SCRIPTING_SETTING = "script.disable_dynamic";
    static final ScriptCache.CompilationRate USE_CONTEXT_RATE_VALUE = new ScriptCache.CompilationRate(-1, TimeValue.MINUS_ONE);
    static final String USE_CONTEXT_RATE_KEY = "use-context";
    public static final Setting<Integer> SCRIPT_GENERAL_CACHE_SIZE_SETTING = Setting.intSetting("script.cache.max_size", 3000, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> SCRIPT_GENERAL_CACHE_EXPIRE_SETTING = Setting.positiveTimeSetting("script.cache.expire", TimeValue.timeValueMillis((long)0L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> SCRIPT_MAX_SIZE_IN_BYTES = Setting.intSetting("script.max_size_in_bytes", 65535, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ScriptCache.CompilationRate> SCRIPT_GENERAL_MAX_COMPILATIONS_RATE_SETTING = new Setting<ScriptCache.CompilationRate>("script.max_compilations_rate", "150/5m", value -> value.equals(USE_CONTEXT_RATE_KEY) ? USE_CONTEXT_RATE_VALUE : new ScriptCache.CompilationRate((String)value), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final String USE_CONTEXT_RATE_KEY_DEPRECATION_MESSAGE = "[use-context] is deprecated for the setting [" + SCRIPT_GENERAL_MAX_COMPILATIONS_RATE_SETTING.getKey() + "] as system scripts are now exempt from the rate limit. Set to a value such as [150/5m] (a rate of 150 compilations per five minutes) to rate limit user scripts in case the script cache [" + SCRIPT_GENERAL_CACHE_SIZE_SETTING.getKey() + "] is undersized causing script compilation thrashing.";
    static final String CONTEXT_PREFIX = "script.context.";
    public static final Setting.AffixSetting<Integer> SCRIPT_CACHE_SIZE_SETTING = Setting.affixKeySetting("script.context.", "cache_max_size", key -> Setting.intSetting(key, SCRIPT_GENERAL_CACHE_SIZE_SETTING, 0, Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.DeprecatedWarning), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> SCRIPT_CACHE_EXPIRE_SETTING = Setting.affixKeySetting("script.context.", "cache_expire", key -> Setting.positiveTimeSetting(key, SCRIPT_GENERAL_CACHE_EXPIRE_SETTING, TimeValue.timeValueMillis((long)0L), Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.DeprecatedWarning), new Setting.AffixSettingDependency[0]);
    static final String UNLIMITED_COMPILATION_RATE_KEY = "unlimited";
    public static final Setting.AffixSetting<ScriptCache.CompilationRate> SCRIPT_MAX_COMPILATIONS_RATE_SETTING = Setting.affixKeySetting("script.context.", "max_compilations_rate", key -> new Setting<ScriptCache.CompilationRate>((String)key, "75/5m", value -> value.equals(UNLIMITED_COMPILATION_RATE_KEY) ? ScriptCache.UNLIMITED_COMPILATION_RATE : new ScriptCache.CompilationRate((String)value), Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.DeprecatedWarning), new Setting.AffixSettingDependency[0]);
    private static final ScriptCache.CompilationRate SCRIPT_COMPILATION_RATE_ZERO = new ScriptCache.CompilationRate(0, TimeValue.ZERO);
    public static final Setting<Boolean> SCRIPT_DISABLE_MAX_COMPILATIONS_RATE_SETTING = Setting.boolSetting("script.disable_max_compilations_rate", false, Setting.Property.NodeScope);
    public static final String ALLOW_NONE = "none";
    public static final Setting<List<String>> TYPES_ALLOWED_SETTING = Setting.listSetting("script.allowed_types", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<String>> CONTEXTS_ALLOWED_SETTING = Setting.listSetting("script.allowed_contexts", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    private final Set<String> typesAllowed;
    private final Set<String> contextsAllowed;
    private final Map<String, ScriptEngine> engines;
    private final Map<String, ScriptContext<?>> contexts;
    private final LongSupplier timeProvider;
    private ClusterState clusterState;
    private int maxSizeInBytes;
    final AtomicReference<CacheHolder> cacheHolder = new AtomicReference();

    public ScriptService(Settings settings, Map<String, ScriptEngine> engines, Map<String, ScriptContext<?>> contexts, LongSupplier timeProvider) {
        this.engines = Collections.unmodifiableMap(Objects.requireNonNull(engines));
        this.contexts = Collections.unmodifiableMap(Objects.requireNonNull(contexts));
        if (Strings.hasLength(settings.get(DISABLE_DYNAMIC_SCRIPTING_SETTING))) {
            throw new IllegalArgumentException("script.disable_dynamic is not a supported setting, replace with fine-grained script settings. \n Dynamic scripts can be enabled for all languages and all operations not using `script.disable_dynamic: false` in elasticsearch.yml");
        }
        HashSet hashSet = this.typesAllowed = TYPES_ALLOWED_SETTING.exists(settings) ? new HashSet() : null;
        if (this.typesAllowed != null) {
            List<String> typesAllowedList = TYPES_ALLOWED_SETTING.get(settings);
            if (typesAllowedList.isEmpty()) {
                throw new IllegalArgumentException("must specify at least one script type or none for setting [" + TYPES_ALLOWED_SETTING.getKey() + "].");
            }
            for (String settingType : typesAllowedList) {
                if (ALLOW_NONE.equals(settingType)) {
                    if (typesAllowedList.size() == 1) break;
                    throw new IllegalArgumentException("cannot specify both [none] and other script types for setting [" + TYPES_ALLOWED_SETTING.getKey() + "].");
                }
                boolean found = false;
                for (ScriptType scriptType : ScriptType.values()) {
                    if (!scriptType.getName().equals(settingType)) continue;
                    found = true;
                    this.typesAllowed.add(settingType);
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException("unknown script type [" + settingType + "] found in setting [" + TYPES_ALLOWED_SETTING.getKey() + "].");
            }
        }
        HashSet hashSet2 = this.contextsAllowed = CONTEXTS_ALLOWED_SETTING.exists(settings) ? new HashSet() : null;
        if (this.contextsAllowed != null) {
            List<String> contextsAllowedList = CONTEXTS_ALLOWED_SETTING.get(settings);
            if (contextsAllowedList.isEmpty()) {
                throw new IllegalArgumentException("must specify at least one script context or none for setting [" + CONTEXTS_ALLOWED_SETTING.getKey() + "].");
            }
            for (String settingContext : contextsAllowedList) {
                if (ALLOW_NONE.equals(settingContext)) {
                    if (contextsAllowedList.size() == 1) break;
                    throw new IllegalArgumentException("cannot specify both [none] and other script contexts for setting [" + CONTEXTS_ALLOWED_SETTING.getKey() + "].");
                }
                if (contexts.containsKey(settingContext)) {
                    this.contextsAllowed.add(settingContext);
                    continue;
                }
                throw new IllegalArgumentException("unknown script context [" + settingContext + "] found in setting [" + CONTEXTS_ALLOWED_SETTING.getKey() + "].");
            }
        }
        this.setMaxSizeInBytes(SCRIPT_MAX_SIZE_IN_BYTES.get(settings));
        this.timeProvider = timeProvider;
        this.validateCacheSettings(settings);
        this.setCacheHolder(settings);
    }

    public static boolean isUseContextCacheSet(Settings settings) {
        return SCRIPT_GENERAL_MAX_COMPILATIONS_RATE_SETTING.get(settings).equals(USE_CONTEXT_RATE_VALUE);
    }

    public static boolean isImplicitContextCacheSet(Settings settings) {
        return new ContextSettings(settings).implicitContextCache();
    }

    public static String contextDeprecationMessage(Settings settings) {
        return new ContextSettings(settings).deprecationMessage();
    }

    boolean compilationLimitsEnabled() {
        return true;
    }

    void registerClusterSettingsListeners(ClusterSettings clusterSettings) {
        clusterSettings.addSettingsUpdateConsumer(SCRIPT_MAX_SIZE_IN_BYTES, this::setMaxSizeInBytes);
        for (ScriptContext<?> context : this.contexts.values()) {
            clusterSettings.addSettingsUpdateConsumer(settings -> this.cacheHolder.get().set(context.name, this.contextCache((Settings)settings, context)), Arrays.asList(SCRIPT_CACHE_SIZE_SETTING.getConcreteSettingForNamespace(context.name), SCRIPT_CACHE_EXPIRE_SETTING.getConcreteSettingForNamespace(context.name), SCRIPT_MAX_COMPILATIONS_RATE_SETTING.getConcreteSettingForNamespace(context.name), SCRIPT_GENERAL_CACHE_EXPIRE_SETTING, SCRIPT_GENERAL_CACHE_SIZE_SETTING));
        }
        clusterSettings.addSettingsUpdateConsumer(this::setCacheHolder, Arrays.asList(SCRIPT_GENERAL_MAX_COMPILATIONS_RATE_SETTING, SCRIPT_GENERAL_CACHE_EXPIRE_SETTING, SCRIPT_GENERAL_CACHE_SIZE_SETTING, SCRIPT_MAX_COMPILATIONS_RATE_SETTING, SCRIPT_DISABLE_MAX_COMPILATIONS_RATE_SETTING, SCRIPT_CACHE_EXPIRE_SETTING, SCRIPT_CACHE_SIZE_SETTING), this::validateCacheSettings);
    }

    void validateCacheSettings(Settings settings) {
        ContextSettings contextSettings = new ContextSettings(settings, this.contexts.keySet());
        if (contextSettings.useContextSet) {
            deprecationLogger.warn(DeprecationCategory.SCRIPTING, "scripting-context-cache", USE_CONTEXT_RATE_KEY_DEPRECATION_MESSAGE, new Object[0]);
        } else if (contextSettings.hasContextSettings()) {
            deprecationLogger.warn(DeprecationCategory.SCRIPTING, "scripting-context-cache", contextSettings.deprecationMessage(), new Object[0]);
        }
        if (contextSettings.incompatibleSettings()) {
            throw new IllegalArgumentException(contextSettings.incompatibleSettingsMessage());
        }
        if (SCRIPT_DISABLE_MAX_COMPILATIONS_RATE_SETTING.get(settings).booleanValue()) {
            if (contextSettings.compilationContexts.size() > 0) {
                throw new IllegalArgumentException("Cannot set custom context compilation rates [" + String.join((CharSequence)", ", contextSettings.contextCompilationKeys()) + "] if compile rates disabled via [" + SCRIPT_DISABLE_MAX_COMPILATIONS_RATE_SETTING.getKey() + "]");
            }
            if (!contextSettings.useContextSet && contextSettings.isGeneralCompilationRateSet) {
                throw new IllegalArgumentException("Cannot set custom general compilation rates [" + SCRIPT_GENERAL_MAX_COMPILATIONS_RATE_SETTING.getKey() + "] to [" + SCRIPT_GENERAL_MAX_COMPILATIONS_RATE_SETTING.get(settings) + "] if compile rates disabled via [" + SCRIPT_DISABLE_MAX_COMPILATIONS_RATE_SETTING.getKey() + "]");
            }
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.engines.values());
    }

    public Map<String, ScriptContext<?>> getScriptContexts() {
        return this.contexts;
    }

    private ScriptEngine getEngine(String lang) {
        ScriptEngine scriptEngine = this.engines.get(lang);
        if (scriptEngine == null) {
            throw new IllegalArgumentException("script_lang not supported [" + lang + "]");
        }
        return scriptEngine;
    }

    void setMaxSizeInBytes(int newMaxSizeInBytes) {
        for (Map.Entry<String, StoredScriptSource> source : this.getScriptsFromClusterState().entrySet()) {
            if (source.getValue().getSource().getBytes(StandardCharsets.UTF_8).length <= newMaxSizeInBytes) continue;
            throw new IllegalArgumentException("script.max_size_in_bytes cannot be set to [" + newMaxSizeInBytes + "], stored script [" + source.getKey() + "] exceeds the new value with a size of [" + source.getValue().getSource().getBytes(StandardCharsets.UTF_8).length + "]");
        }
        this.maxSizeInBytes = newMaxSizeInBytes;
    }

    public <FactoryType> FactoryType compile(Script script, ScriptContext<FactoryType> context) {
        Objects.requireNonNull(script);
        Objects.requireNonNull(context);
        ScriptType type = script.getType();
        String lang = script.getLang();
        String idOrCode = script.getIdOrCode();
        Map<String, String> options = script.getOptions();
        String id = idOrCode;
        if (type == ScriptType.STORED) {
            StoredScriptSource source = this.getScriptFromClusterState(id);
            lang = source.getLang();
            idOrCode = source.getSource();
            options = source.getOptions();
        }
        ScriptEngine scriptEngine = this.getEngine(lang);
        if (!this.isTypeEnabled(type)) {
            throw new IllegalArgumentException("cannot execute [" + type + "] scripts");
        }
        if (!this.contexts.containsKey(context.name)) {
            throw new IllegalArgumentException("script context [" + context.name + "] not supported");
        }
        if (!this.isContextEnabled(context)) {
            throw new IllegalArgumentException("cannot execute scripts using [" + context.name + "] context");
        }
        if (type == ScriptType.INLINE && idOrCode.getBytes(StandardCharsets.UTF_8).length > this.maxSizeInBytes) {
            throw new IllegalArgumentException("exceeded max allowed inline script size in bytes [" + this.maxSizeInBytes + "] with size [" + idOrCode.getBytes(StandardCharsets.UTF_8).length + "] for script [" + idOrCode + "]");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("compiling lang: [{}] type: [{}] script: {}", (Object)lang, (Object)type, (Object)idOrCode);
        }
        ScriptCache scriptCache = this.cacheHolder.get().get(context.name);
        assert (scriptCache != null) : "script context [" + context.name + "] has no script cache";
        return scriptCache.compile(context, scriptEngine, id, idOrCode, type, options);
    }

    public boolean isLangSupported(String lang) {
        Objects.requireNonNull(lang);
        return this.engines.containsKey(lang);
    }

    public boolean isTypeEnabled(ScriptType scriptType) {
        return this.typesAllowed == null || this.typesAllowed.contains(scriptType.getName());
    }

    public boolean isContextEnabled(ScriptContext<?> scriptContext) {
        return this.contextsAllowed == null || this.contextsAllowed.contains(scriptContext.name);
    }

    public boolean isAnyContextEnabled() {
        return this.contextsAllowed == null || !this.contextsAllowed.isEmpty();
    }

    Map<String, StoredScriptSource> getScriptsFromClusterState() {
        if (this.clusterState == null) {
            return Collections.emptyMap();
        }
        ScriptMetadata scriptMetadata = (ScriptMetadata)this.clusterState.metadata().custom("stored_scripts");
        if (scriptMetadata == null) {
            return Collections.emptyMap();
        }
        return scriptMetadata.getStoredScripts();
    }

    protected StoredScriptSource getScriptFromClusterState(String id) {
        ScriptMetadata scriptMetadata = (ScriptMetadata)this.clusterState.metadata().custom("stored_scripts");
        if (scriptMetadata == null) {
            throw new ResourceNotFoundException("unable to find script [" + id + "] in cluster state", new Object[0]);
        }
        StoredScriptSource source = scriptMetadata.getStoredScript(id);
        if (source == null) {
            throw new ResourceNotFoundException("unable to find script [" + id + "] in cluster state", new Object[0]);
        }
        return source;
    }

    public void putStoredScript(ClusterService clusterService, final PutStoredScriptRequest request, ActionListener<AcknowledgedResponse> listener) {
        if (request.content().length() > this.maxSizeInBytes) {
            throw new IllegalArgumentException("exceeded max allowed stored script size in bytes [" + this.maxSizeInBytes + "] with size [" + request.content().length() + "] for script [" + request.id() + "]");
        }
        final StoredScriptSource source = request.source();
        if (!this.isLangSupported(source.getLang())) {
            throw new IllegalArgumentException("unable to put stored script with unsupported lang [" + source.getLang() + "]");
        }
        try {
            ScriptEngine scriptEngine = this.getEngine(source.getLang());
            if (!this.isTypeEnabled(ScriptType.STORED)) {
                throw new IllegalArgumentException("cannot put [" + ScriptType.STORED + "] script, [" + ScriptType.STORED + "] scripts are not enabled");
            }
            if (!this.isAnyContextEnabled()) {
                throw new IllegalArgumentException("cannot put [" + ScriptType.STORED + "] script, no script contexts are enabled");
            }
            if (request.context() != null) {
                ScriptContext<?> context = this.contexts.get(request.context());
                if (context == null) {
                    throw new IllegalArgumentException("Unknown context [" + request.context() + "]");
                }
                if (!context.allowStoredScript) {
                    throw new IllegalArgumentException("cannot store a script for context [" + request.context() + "]");
                }
                scriptEngine.compile(request.id(), source.getSource(), context, Collections.emptyMap());
            }
        }
        catch (ScriptException good) {
            throw good;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("failed to parse/compile stored script [" + request.id() + "]", exception);
        }
        clusterService.submitStateUpdateTask("put-script-" + request.id(), new AckedClusterStateUpdateTask(request, listener){

            @Override
            public ClusterState execute(ClusterState currentState) {
                ScriptMetadata smd = (ScriptMetadata)currentState.metadata().custom("stored_scripts");
                smd = ScriptMetadata.putStoredScript(smd, request.id(), source);
                Metadata.Builder mdb = Metadata.builder(currentState.getMetadata()).putCustom("stored_scripts", smd);
                return ClusterState.builder(currentState).metadata(mdb).build();
            }
        }, ClusterStateTaskExecutor.unbatched());
    }

    public void deleteStoredScript(ClusterService clusterService, final DeleteStoredScriptRequest request, ActionListener<AcknowledgedResponse> listener) {
        clusterService.submitStateUpdateTask("delete-script-" + request.id(), new AckedClusterStateUpdateTask(request, listener){

            @Override
            public ClusterState execute(ClusterState currentState) {
                ScriptMetadata smd = (ScriptMetadata)currentState.metadata().custom("stored_scripts");
                smd = ScriptMetadata.deleteStoredScript(smd, request.id());
                Metadata.Builder mdb = Metadata.builder(currentState.getMetadata()).putCustom("stored_scripts", smd);
                return ClusterState.builder(currentState).metadata(mdb).build();
            }
        }, ClusterStateTaskExecutor.unbatched());
    }

    public StoredScriptSource getStoredScript(ClusterState state, GetStoredScriptRequest request) {
        ScriptMetadata scriptMetadata = (ScriptMetadata)state.metadata().custom("stored_scripts");
        if (scriptMetadata != null) {
            return scriptMetadata.getStoredScript(request.id());
        }
        return null;
    }

    public Set<ScriptContextInfo> getContextInfos() {
        HashSet<ScriptContextInfo> infos = new HashSet<ScriptContextInfo>(this.contexts.size());
        for (ScriptContext<?> context : this.contexts.values()) {
            infos.add(new ScriptContextInfo(context.name, context.instanceClazz));
        }
        return infos;
    }

    public ScriptLanguagesInfo getScriptLanguages() {
        Set<String> types = this.typesAllowed;
        if (types == null) {
            types = new HashSet<String>();
            for (ScriptType type : ScriptType.values()) {
                types.add(type.getName());
            }
        }
        Set<String> contexts = this.contextsAllowed != null ? this.contextsAllowed : this.contexts.keySet();
        HashMap<String, Set<String>> languageContexts = new HashMap<String, Set<String>>();
        this.engines.forEach((key, value) -> languageContexts.put((String)key, value.getSupportedContexts().stream().map(c -> c.name).filter(contexts::contains).collect(Collectors.toSet())));
        return new ScriptLanguagesInfo(types, languageContexts);
    }

    public ScriptStats stats() {
        return this.cacheHolder.get().stats();
    }

    public ScriptCacheStats cacheStats() {
        return this.cacheHolder.get().cacheStats();
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        this.clusterState = event.state();
    }

    void setCacheHolder(Settings settings) {
        CacheHolder current = this.cacheHolder.get();
        ContextSettings contextSettings = new ContextSettings(settings, this.contexts.keySet());
        if (current == null) {
            if (contextSettings.useContextCache()) {
                this.cacheHolder.set(this.contextCacheHolder(settings));
            } else {
                this.cacheHolder.set(this.generalCacheHolder(settings));
            }
            return;
        }
        if (contextSettings.useContextCache()) {
            if (current.general != null) {
                this.cacheHolder.set(this.contextCacheHolder(settings));
            }
        } else if (current.general == null) {
            this.cacheHolder.set(this.generalCacheHolder(settings));
        } else if (!current.general.rate.equals(SCRIPT_GENERAL_MAX_COMPILATIONS_RATE_SETTING.get(settings)) || !current.general.cacheExpire.equals((Object)SCRIPT_GENERAL_CACHE_EXPIRE_SETTING.get(settings)) || current.general.cacheSize != SCRIPT_GENERAL_CACHE_SIZE_SETTING.get(settings)) {
            this.cacheHolder.set(this.generalCacheHolder(settings));
        }
    }

    CacheHolder generalCacheHolder(Settings settings) {
        ScriptCache.CompilationRate rate = SCRIPT_GENERAL_MAX_COMPILATIONS_RATE_SETTING.get(settings);
        if (SCRIPT_DISABLE_MAX_COMPILATIONS_RATE_SETTING.get(settings).booleanValue() || !this.compilationLimitsEnabled()) {
            rate = SCRIPT_COMPILATION_RATE_ZERO;
        }
        return new CacheHolder(SCRIPT_GENERAL_CACHE_SIZE_SETTING.get(settings), SCRIPT_GENERAL_CACHE_EXPIRE_SETTING.get(settings), rate, SCRIPT_GENERAL_MAX_COMPILATIONS_RATE_SETTING.getKey(), this.timeProvider);
    }

    CacheHolder contextCacheHolder(Settings settings) {
        Map<String, ScriptCache> contextCache = Maps.newMapWithExpectedSize(this.contexts.size());
        this.contexts.forEach((k, v) -> contextCache.put((String)k, this.contextCache(settings, (ScriptContext<?>)v)));
        return new CacheHolder(contextCache);
    }

    ScriptCache contextCache(Settings settings, ScriptContext<?> context) {
        Setting<Integer> cacheSizeSetting = SCRIPT_CACHE_SIZE_SETTING.getConcreteSettingForNamespace(context.name);
        int cacheSize = cacheSizeSetting.existsOrFallbackExists(settings) ? cacheSizeSetting.get(settings) : context.cacheSizeDefault;
        Setting<TimeValue> cacheExpireSetting = SCRIPT_CACHE_EXPIRE_SETTING.getConcreteSettingForNamespace(context.name);
        TimeValue cacheExpire = cacheExpireSetting.existsOrFallbackExists(settings) ? cacheExpireSetting.get(settings) : context.cacheExpireDefault;
        Setting<ScriptCache.CompilationRate> rateSetting = SCRIPT_MAX_COMPILATIONS_RATE_SETTING.getConcreteSettingForNamespace(context.name);
        ScriptCache.CompilationRate rate = SCRIPT_DISABLE_MAX_COMPILATIONS_RATE_SETTING.get(settings) != false || !this.compilationLimitsEnabled() || !context.compilationRateLimited ? SCRIPT_COMPILATION_RATE_ZERO : (rateSetting.existsOrFallbackExists(settings) ? rateSetting.get(settings) : new ScriptCache.CompilationRate(ScriptContext.DEFAULT_COMPILATION_RATE_LIMIT));
        return new ScriptCache(cacheSize, cacheExpire, rate, rateSetting.getKey(), this.timeProvider);
    }

    public static class ContextSettings {
        public final Settings settings;
        public final boolean useContextSet;
        public final boolean isGeneralCompilationRateSet;
        public final ScriptCache.CompilationRate generalCompilationRate;
        public final List<String> compilationContexts;
        public final List<String> sizeContexts;
        public final List<String> expireContexts;

        public ContextSettings(Settings settings, Set<String> contexts) {
            this.settings = settings;
            this.generalCompilationRate = SCRIPT_GENERAL_MAX_COMPILATIONS_RATE_SETTING.get(settings);
            this.useContextSet = this.generalCompilationRate.equals(USE_CONTEXT_RATE_VALUE);
            this.isGeneralCompilationRateSet = SCRIPT_GENERAL_MAX_COMPILATIONS_RATE_SETTING.exists(settings);
            this.compilationContexts = ContextSettings.getContexts(SCRIPT_MAX_COMPILATIONS_RATE_SETTING, settings, contexts);
            this.sizeContexts = ContextSettings.getContexts(SCRIPT_CACHE_SIZE_SETTING, settings, contexts);
            this.expireContexts = ContextSettings.getContexts(SCRIPT_CACHE_EXPIRE_SETTING, settings, contexts);
        }

        public ContextSettings(Settings settings) {
            this(settings, Collections.emptySet());
        }

        protected static List<String> getContexts(Setting.AffixSetting<?> setting, Settings settings, Set<String> contexts) {
            ArrayList<String> contextSettings = new ArrayList<String>();
            for (String context : setting.getAsMap(settings).keySet()) {
                if (!contexts.isEmpty() && !contexts.contains(context)) {
                    String settingKey = setting.getConcreteSettingForNamespace(context).getKey();
                    throw new IllegalArgumentException("Context [" + context + "] doesn't exist for setting [" + settingKey + "]");
                }
                contextSettings.add(context);
            }
            contextSettings.sort(Comparator.naturalOrder());
            return contextSettings;
        }

        public boolean hasContextSettings() {
            return !this.compilationContexts.isEmpty() || !this.expireContexts.isEmpty() || !this.sizeContexts.isEmpty();
        }

        public String deprecationMessage() {
            if (!this.hasContextSettings()) {
                return "";
            }
            ArrayList<String> settingsKeys = new ArrayList<String>();
            settingsKeys.addAll(ContextSettings.fullKeys(SCRIPT_MAX_COMPILATIONS_RATE_SETTING, this.compilationContexts));
            settingsKeys.addAll(ContextSettings.fullKeys(SCRIPT_CACHE_SIZE_SETTING, this.sizeContexts));
            settingsKeys.addAll(ContextSettings.fullKeys(SCRIPT_CACHE_EXPIRE_SETTING, this.expireContexts));
            settingsKeys.sort(Comparator.naturalOrder());
            return "Implicitly using the script context cache is deprecated, remove settings [" + String.join((CharSequence)", ", settingsKeys) + "] to use the script general cache.";
        }

        public List<String> contextCompilationKeys() {
            return ContextSettings.fullKeys(SCRIPT_MAX_COMPILATIONS_RATE_SETTING, this.compilationContexts);
        }

        protected static List<String> fullKeys(Setting.AffixSetting<?> affix, List<String> contexts) {
            return contexts.stream().map(ctx -> affix.getConcreteSettingForNamespace((String)ctx).getKey()).collect(Collectors.toList());
        }

        public boolean useContextCache() {
            return this.useContextSet || this.implicitContextCache();
        }

        public boolean implicitContextCache() {
            return !this.useContextSet && this.hasContextSettings() && !this.isGeneralCompilationRateSet;
        }

        public boolean incompatibleSettings() {
            return !this.useContextSet && this.hasContextSettings() && this.isGeneralCompilationRateSet;
        }

        public List<String> contextSettings() {
            List<String> contextSettings = ContextSettings.fullKeys(SCRIPT_MAX_COMPILATIONS_RATE_SETTING, this.compilationContexts);
            contextSettings.addAll(ContextSettings.fullKeys(SCRIPT_CACHE_SIZE_SETTING, this.sizeContexts));
            contextSettings.addAll(ContextSettings.fullKeys(SCRIPT_CACHE_EXPIRE_SETTING, this.expireContexts));
            return contextSettings;
        }

        public String incompatibleSettingsMessage() {
            if (!this.incompatibleSettings()) {
                return "";
            }
            List<String> incompatible = this.contextSettings();
            return "Context cache settings [" + String.join((CharSequence)",", incompatible) + "] are incompatible with [" + SCRIPT_GENERAL_MAX_COMPILATIONS_RATE_SETTING.getKey() + "] set to non-default value [" + this.generalCompilationRate + "]. Either remove the incompatible settings (recommended) or set [" + SCRIPT_GENERAL_MAX_COMPILATIONS_RATE_SETTING.getKey() + "] to [use-context] to use per-context settings";
        }
    }

    static class CacheHolder {
        final ScriptCache general;
        final Map<String, AtomicReference<ScriptCache>> contextCache;

        CacheHolder(int cacheMaxSize, TimeValue cacheExpire, ScriptCache.CompilationRate maxCompilationRate, String contextRateSetting, LongSupplier timeProvider) {
            this.contextCache = null;
            this.general = new ScriptCache(cacheMaxSize, cacheExpire, maxCompilationRate, contextRateSetting, timeProvider);
        }

        CacheHolder(Map<String, ScriptCache> context) {
            Map refs = Maps.newMapWithExpectedSize(context.size());
            context.forEach((k, v) -> refs.put(k, new AtomicReference<ScriptCache>((ScriptCache)v)));
            this.contextCache = Collections.unmodifiableMap(refs);
            this.general = null;
        }

        ScriptCache get(String context) {
            if (this.general != null) {
                return this.general;
            }
            AtomicReference<ScriptCache> ref = this.contextCache.get(context);
            if (ref == null) {
                return null;
            }
            return ref.get();
        }

        ScriptStats stats() {
            if (this.general != null) {
                return this.general.stats();
            }
            ArrayList<ScriptContextStats> contextStats = new ArrayList<ScriptContextStats>(this.contextCache.size());
            for (Map.Entry<String, AtomicReference<ScriptCache>> entry : this.contextCache.entrySet()) {
                ScriptCache cache = entry.getValue().get();
                contextStats.add(cache.stats(entry.getKey()));
            }
            return new ScriptStats(contextStats);
        }

        ScriptCacheStats cacheStats() {
            if (this.general != null) {
                return new ScriptCacheStats(this.general.stats());
            }
            Map<String, ScriptStats> context = Maps.newMapWithExpectedSize(this.contextCache.size());
            for (String name : this.contextCache.keySet()) {
                context.put(name, this.contextCache.get(name).get().stats());
            }
            return new ScriptCacheStats(context);
        }

        void set(String name, ScriptCache cache) {
            if (this.general != null) {
                return;
            }
            AtomicReference<ScriptCache> ref = this.contextCache.get(name);
            assert (ref != null) : "expected script cache to exist for context [" + name + "]";
            ScriptCache oldCache = ref.get();
            assert (oldCache != null) : "expected script cache to be non-null for context [" + name + "]";
            ref.set(cache);
            logger.debug("Replaced context [" + name + "] with new settings");
        }
    }
}

