/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.DocReader;
import org.elasticsearch.script.LeafReaderContextSupplier;
import org.elasticsearch.script.field.EmptyField;
import org.elasticsearch.script.field.Field;
import org.elasticsearch.search.lookup.LeafDocLookup;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;

public class DocValuesDocReader
implements DocReader,
LeafReaderContextSupplier {
    protected final SearchLookup searchLookup;
    protected final LeafReaderContext leafReaderContext;
    protected LeafSearchLookup leafSearchLookup;

    public DocValuesDocReader(SearchLookup searchLookup, LeafReaderContext leafContext) {
        this.searchLookup = searchLookup;
        this.leafReaderContext = leafContext;
        this.leafSearchLookup = searchLookup.getLeafSearchLookup(this.leafReaderContext);
    }

    @Override
    public Field<?> field(String fieldName) {
        LeafDocLookup leafDocLookup = this.leafSearchLookup.doc();
        if (!leafDocLookup.containsKey(fieldName)) {
            return new EmptyField(fieldName);
        }
        return leafDocLookup.getScriptField(fieldName);
    }

    @Override
    public Stream<Field<?>> fields(String fieldGlob) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void setDocument(int docID) {
        this.leafSearchLookup.setDocument(docID);
    }

    @Override
    public Map<String, Object> docAsMap() {
        return this.leafSearchLookup.asMap();
    }

    @Override
    public Map<String, ScriptDocValues<?>> doc() {
        return this.leafSearchLookup.doc();
    }

    @Override
    public LeafReaderContext getLeafReaderContext() {
        return this.leafReaderContext;
    }
}

